/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class ARCRecipeSerializer<RECIPE extends RecipeARC>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ARCRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        JsonArray tool = GsonHelper.m_13885_((JsonObject)json, (String)"tool") ? GsonHelper.m_13933_((JsonObject)json, (String)"tool") : GsonHelper.m_13930_((JsonObject)json, (String)"tool");
        Ingredient inputIng = Ingredient.m_43917_((JsonElement)input);
        Ingredient toolIng = Ingredient.m_43917_((JsonElement)tool);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        ArrayList<Pair<ItemStack, Double>> addedItems = new ArrayList<Pair<ItemStack, Double>>();
        if (json.has("addedoutput") && GsonHelper.m_13885_((JsonObject)json, (String)"addedoutput")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"addedoutput");
            for (JsonElement element : mainArray) {
                if (addedItems.size() >= 3) break;
                if (!element.isJsonObject()) continue;
                JsonObject obj = element.getAsJsonObject();
                double chance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
                ItemStack extraDrop = SerializerHelper.getItemStack(obj, "type");
                addedItems.add((Pair<ItemStack, Double>)Pair.of((Object)extraDrop, (Object)chance));
            }
        }
        FluidStackIngredient inputFluidIng = null;
        if (json.has("inputFluid")) {
            JsonArray inputFluid = GsonHelper.m_13885_((JsonObject)json, (String)"inputFluid") ? GsonHelper.m_13933_((JsonObject)json, (String)"inputFluid") : GsonHelper.m_13930_((JsonObject)json, (String)"inputFluid");
            inputFluidIng = FluidStackIngredient.deserialize((JsonElement)inputFluid);
        }
        FluidStack outputFluidStack = FluidStack.EMPTY;
        if (json.has("outputFluid")) {
            JsonObject outputFluid = GsonHelper.m_13930_((JsonObject)json, (String)"outputFluid").getAsJsonObject();
            outputFluidStack = SerializerHelper.deserializeFluid(outputFluid);
        }
        boolean consumeIngredient = GsonHelper.m_13912_((JsonObject)json, (String)"consumeingredient");
        return this.factory.create(recipeId, inputIng, toolIng, inputFluidIng, output, addedItems, outputFluidStack, consumeIngredient);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ArrayList<Pair<ItemStack, Double>> addedItems = new ArrayList<Pair<ItemStack, Double>>();
            Ingredient inputIng = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient toolIng = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int addedItemSize = buffer.readInt();
            for (int i = 0; i < addedItemSize; ++i) {
                ItemStack stack = buffer.m_130267_();
                double chance = buffer.readDouble();
                addedItems.add(Pair.of((Object)stack, (Object)chance));
            }
            FluidStackIngredient inputFluid = null;
            FluidStack outputFluid = new FluidStack(Fluids.f_76191_, 1000);
            if (buffer.readBoolean()) {
                inputFluid = FluidStackIngredient.read(buffer);
            }
            if (buffer.readBoolean()) {
                outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            }
            boolean consumeIngredient = buffer.readBoolean();
            return this.factory.create(recipeId, inputIng, toolIng, inputFluid, output, addedItems, outputFluid, consumeIngredient);
        }
        catch (Exception e) {
            BloodMagic.LOGGER.error("Error reading ARC recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((RecipeARC)recipe).write(buffer);
        }
        catch (Exception e) {
            BloodMagic.LOGGER.error("Error writing ARC recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeARC> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, Ingredient var3, FluidStackIngredient var4, ItemStack var5, List<Pair<ItemStack, Double>> var6, FluidStack var7, boolean var8);
    }
}

