/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.client.button.FilterButtonTogglePress;
import wayoftime.bloodmagic.common.container.item.ContainerFilter;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.CollectionTagFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.ItemRouterFilter;
import wayoftime.bloodmagic.common.item.routing.TagFilterKey;
import wayoftime.bloodmagic.common.routing.BasicItemFilter;
import wayoftime.bloodmagic.common.routing.BlacklistItemFilter;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;

public class ItemTagFilter
extends ItemRouterFilter
implements INestableItemFilterProvider {
    @Override
    protected IItemFilter getFilterTypeFromConfig(ItemStack filterStack) {
        int state = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        if (state == 1) {
            return new BlacklistItemFilter();
        }
        return new BasicItemFilter();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack filterStack, Level world, List<Component> tooltip, TooltipFlag flag) {
        boolean isWhitelist;
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.tagfilter.desc").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
        if (filterStack.m_41783_() == null) {
            return;
        }
        int whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0);
        boolean bl = isWhitelist = whitelistState == 0;
        if (isWhitelist) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.whitelist").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.blacklist").m_130940_(ChatFormatting.GRAY));
        }
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            ResourceLocation tag = this.getItemTagResource(filterStack, i);
            Object display = stack.m_41786_();
            display = tag != null ? new TextComponent(tag.toString()) : new TranslatableComponent("tooltip.bloodmagic.filter.anytag", new Object[]{display});
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, display}));
                    continue;
                }
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.filter.all", new Object[]{display}));
                continue;
            }
            tooltip.add((Component)display);
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        int index = this.getItemTagIndex(filterStack, slot);
        if (index == 0) {
            List<TagKey<Item>> tagList = this.getAllItemTags(filterStack, slot);
            if (tagList != null && !tagList.isEmpty()) {
                return new CollectionTagFilterKey(tagList, amount);
            }
        } else {
            TagKey<Item> tag = this.getItemTag(filterStack, slot);
            if (tag != null) {
                return new TagFilterKey(tag, amount);
            }
        }
        return new BasicFilterKey(ghostStack, amount);
    }

    public int getItemTagIndex(ItemStack filterStack, int slot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            filterStack.m_41751_(tag);
        }
        return tag.m_128451_("button:itemtag" + slot);
    }

    public void setItemTagIndex(ItemStack filterStack, int slot, int index) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
            filterStack.m_41751_(tag);
        }
        tag.m_128405_("button:itemtag" + slot, index);
    }

    public void cycleToNextTag(ItemStack filterStack, int slot) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.m_8020_(slot);
        if (ghostStack.m_41619_()) {
            return;
        }
        int index = this.getItemTagIndex(filterStack, slot);
        List<TagKey<Item>> tags = this.getAllItemTags(ghostStack);
        if (++index > tags.size()) {
            index = 0;
        }
        this.setItemTagIndex(filterStack, slot, index);
    }

    public TagKey<Item> getItemTag(ItemStack filterStack, int slot) {
        int index = this.getItemTagIndex(filterStack, slot);
        if (index <= 0) {
            return null;
        }
        --index;
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.m_8020_(slot);
        if (ghostStack.m_41619_()) {
            return null;
        }
        List<TagKey<Item>> tags = this.getAllItemTags(ghostStack);
        if (tags.size() < index) {
            return null;
        }
        return tags.get(index);
    }

    public ResourceLocation getItemTagResource(ItemStack filterStack, int slot) {
        TagKey<Item> tag = this.getItemTag(filterStack, slot);
        if (tag == null) {
            return null;
        }
        return tag.f_203868_();
    }

    public List<TagKey<Item>> getAllItemTags(ItemStack filterStack, int slot) {
        InventoryFilter inv = new InventoryFilter(filterStack);
        ItemStack ghostStack = inv.m_8020_(slot);
        if (ghostStack.m_41619_()) {
            return new ArrayList<TagKey<Item>>();
        }
        return this.getAllItemTags(ghostStack);
    }

    public List<TagKey<Item>> getAllItemTags(ItemStack ghostStack) {
        if (ghostStack.m_41619_()) {
            return new ArrayList<TagKey<Item>>();
        }
        ArrayList<TagKey<Item>> tagList = new ArrayList<TagKey<Item>>();
        Stream stream = ghostStack.m_204131_();
        stream.forEach(a -> tagList.add((TagKey<Item>)a));
        return tagList;
    }

    @Override
    public int receiveButtonPress(ItemStack filterStack, String buttonKey, int ghostItemSlot, int currentButtonState) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag == null) {
            filterStack.m_41751_(new CompoundTag());
            tag = filterStack.m_41783_();
        }
        if (buttonKey.equals("itemtag")) {
            this.cycleToNextTag(filterStack, ghostItemSlot);
        }
        return super.receiveButtonPress(filterStack, buttonKey, ghostItemSlot, currentButtonState);
    }

    @Override
    public int getCurrentButtonState(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        CompoundTag tag = filterStack.m_41783_();
        if (tag != null && buttonKey.equals("itemtag")) {
            int state = this.getItemTagIndex(filterStack, ghostItemSlot);
            return state;
        }
        return super.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<Component> getTextForHoverItem(ItemStack filterStack, String buttonKey, int ghostItemSlot) {
        List<Component> componentList = super.getTextForHoverItem(filterStack, buttonKey, ghostItemSlot);
        if (ghostItemSlot < 0) {
            return componentList;
        }
        int currentState = this.getCurrentButtonState(filterStack, buttonKey, ghostItemSlot);
        if (!buttonKey.equals("itemtag")) return componentList;
        if (currentState == 0) {
            InventoryFilter inv = new InventoryFilter(filterStack);
            ItemStack ghostStack = inv.m_8020_(ghostItemSlot);
            if (ghostStack.m_41619_()) {
                componentList.add((Component)new TranslatableComponent("filter.bloodmagic.novalidtag"));
                return componentList;
            }
            Stream stream = ghostStack.m_204131_();
            ArrayList locations = new ArrayList();
            stream.forEach(a -> locations.add(a.f_203867_().m_135782_()));
            if (locations.size() <= 0) {
                componentList.add((Component)new TranslatableComponent("filter.bloodmagic.novalidtag"));
                return componentList;
            }
            componentList.add((Component)new TranslatableComponent("filter.bloodmagic.anytag"));
            for (ResourceLocation rl : locations) {
                componentList.add((Component)new TextComponent(rl.toString()));
            }
            return componentList;
        } else {
            ResourceLocation rl = this.getItemTagResource(filterStack, ghostItemSlot);
            if (rl == null) return componentList;
            componentList.add((Component)new TranslatableComponent("filter.bloodmagic.specifiedtag"));
            componentList.add((Component)new TextComponent(rl.toString()));
        }
        return componentList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<String, Button.OnPress>> getButtonAction(ContainerFilter container) {
        List<Pair<String, Button.OnPress>> buttonList = super.getButtonAction(container);
        buttonList.add((Pair<String, Button.OnPress>)Pair.of((Object)"itemtag", (Object)new FilterButtonTogglePress("itemtag", container)));
        return buttonList;
    }

    @Override
    public Pair<Integer, Integer> getTexturePositionForState(ItemStack filterStack, String buttonKey, int currentButtonState) {
        if (buttonKey.equals("itemtag")) {
            switch (currentButtonState) {
                case 0: {
                    return Pair.of((Object)196, (Object)20);
                }
            }
            return Pair.of((Object)196, (Object)0);
        }
        return super.getTexturePositionForState(filterStack, buttonKey, currentButtonState);
    }
}

