/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockRitualStone;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.TileMasterRitualStone;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.RitualHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ItemRitualDiviner
extends Item {
    final int type;
    public static final String tooltipBase = "tooltip.bloodmagic.diviner.";
    public static String[] names = new String[]{"normal", "dusk", "dawn"};

    public ItemRitualDiviner(int type) {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB));
        this.type = type;
    }

    public boolean getActivated(ItemStack stack) {
        return !stack.m_41619_() && NBTHelper.checkNBT(stack).m_41783_().m_128471_("activated");
    }

    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (!stack.m_41619_()) {
            NBTHelper.checkNBT(stack).m_41783_().m_128379_("activated", activated);
            return stack;
        }
        return stack;
    }

    public void setStoredPos(ItemStack stack, BlockPos pos) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("xCoord", pos.m_123341_());
        tag.m_128405_("yCoord", pos.m_123342_());
        tag.m_128405_("zCoord", pos.m_123343_());
    }

    public BlockPos getStoredPos(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        return new BlockPos(tag.m_128451_("xCoord"), tag.m_128451_("yCoord"), tag.m_128451_("zCoord"));
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player && this.getActivated(stack) && entityIn.f_19797_ % 4 == 0) {
            BlockPos pos = this.getStoredPos(stack);
            if (!this.addRuneToRitual(stack, worldIn, pos, (Player)entityIn)) {
                this.setActivatedState(stack, false);
            } else if (worldIn.f_46443_) {
                ItemRitualDiviner.spawnParticles(worldIn, pos, 30);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
        if (context.m_43723_().m_6144_()) {
            if (context.m_43725_().f_46443_) {
                this.trySetDisplayedRitual(stack, context.m_43725_(), context.m_8083_());
            }
            return InteractionResult.SUCCESS;
        }
        if (this.addRuneToRitual(stack, context.m_43725_(), context.m_8083_(), context.m_43723_())) {
            this.setStoredPos(stack, context.m_8083_());
            this.setActivatedState(stack, true);
            if (context.m_43725_().f_46443_) {
                ItemRitualDiviner.spawnParticles(context.m_43725_(), context.m_8083_().m_142300_(context.m_43719_()), 15);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean addRuneToRitual(ItemStack stack, Level world, BlockPos pos, Player player) {
        Ritual ritual;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileMasterRitualStone && (ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack))) != null) {
            Direction direction = this.getDirection(stack);
            ArrayList components = Lists.newArrayList();
            ritual.gatherComponents(components::add);
            for (RitualComponent component : components) {
                if (!this.canPlaceRitualStone(component.getRuneType(), stack)) {
                    return false;
                }
                BlockPos offset = component.getOffset(direction);
                BlockPos newPos = pos.m_141952_((Vec3i)offset);
                BlockState state = world.m_8055_(newPos);
                Block block = state.m_60734_();
                if (RitualHelper.isRune(world, newPos)) {
                    if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) {
                        if (!world.f_46443_) continue;
                        this.undisplayHologram();
                        continue;
                    }
                    RitualHelper.setRuneType(world, newPos, component.getRuneType());
                    return true;
                }
                BlockPlaceContext ctx = new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, BlockHitResult.m_82426_((Vec3)new Vec3(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)newPos));
                if (state.m_60629_(ctx)) {
                    if (!this.consumeStone(stack, world, player)) {
                        return false;
                    }
                    ((BlockRitualStone)BloodMagicBlocks.BLANK_RITUAL_STONE.get()).setRuneType(world, newPos, component.getRuneType());
                    return true;
                }
                this.notifyBlockedBuild(player, newPos);
                return false;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void trySetDisplayedRitual(ItemStack itemStack, Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileMasterRitualStone) {
            Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(itemStack));
            TileMasterRitualStone masterRitualStone = (TileMasterRitualStone)tile;
            if (ritual != null) {
                Direction direction = this.getDirection(itemStack);
                ClientHandler.setRitualHolo(masterRitualStone, ritual, direction, true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void undisplayHologram() {
        ClientHandler.setRitualHoloToNull();
    }

    public boolean consumeStone(ItemStack stack, Level world, Player player) {
        if (player.m_7500_()) {
            return true;
        }
        NonNullList inventory = player.m_150109_().f_35974_;
        for (ItemStack newStack : inventory) {
            Block block;
            Item item;
            if (newStack.m_41619_() || !((item = newStack.m_41720_()) instanceof BlockItem) || !((block = ((BlockItem)item).m_40614_()) instanceof BlockRitualStone)) continue;
            newStack.m_41774_(1);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(this.getCurrentRitual(stack));
        if (ritual != null) {
            boolean extraInfo;
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.diviner.currentRitual", new Object[]{new TranslatableComponent(ritual.getTranslationKey())}).m_130940_(ChatFormatting.GRAY));
            boolean sneaking = Screen.m_96638_();
            boolean bl = extraInfo = sneaking && Screen.m_96639_();
            if (extraInfo) {
                tooltip.add((Component)new TextComponent(""));
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    if (!TextHelper.canTranslate(ritual.getTranslationKey() + "." + type.name().toLowerCase(Locale.ROOT) + ".info")) continue;
                    tooltip.add((Component)new TranslatableComponent(ritual.getTranslationKey() + "." + type.name().toLowerCase(Locale.ROOT) + ".info"));
                }
            } else if (sneaking) {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.diviner.currentDirection", new Object[]{Utils.toFancyCasing(this.getDirection(stack).name())}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)new TextComponent(""));
                Tuple<Integer, Map<EnumRuneType, Integer>> runeCount = RitualHelper.countRunes(ritual);
                int totalRunes = (Integer)runeCount.m_14418_();
                Map runeMap = (Map)runeCount.m_14419_();
                for (EnumRuneType type : EnumRuneType.values()) {
                    int count = runeMap.getOrDefault((Object)type, 0);
                    if (count <= 0) continue;
                    tooltip.add((Component)new TranslatableComponent(tooltipBase + type.translationKey, new Object[]{count}).m_130940_(type.colorCode));
                }
                tooltip.add((Component)new TextComponent(""));
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.diviner.totalRune", new Object[]{totalRunes}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)new TextComponent(""));
                if (TextHelper.canTranslate(ritual.getTranslationKey() + ".info")) {
                    tooltip.add((Component)new TranslatableComponent(ritual.getTranslationKey() + ".info").m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)new TextComponent(""));
                }
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.diviner.extraInfo").m_130940_(ChatFormatting.BLUE));
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.diviner.extraExtraInfo").m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.setActivatedState(stack, false);
        BlockHitResult ray = ItemRitualDiviner.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.m_6144_()) {
            if (!world.f_46443_) {
                this.cycleRitual(stack, player, false);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!world.f_46443_) {
            this.cycleDirection(stack, player);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void m_5929_(Level worldIn, LivingEntity entityLiving, ItemStack stack, int count) {
        this.setActivatedState(stack, false);
        if (!entityLiving.f_19853_.f_46443_ && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            BlockHitResult ray = ItemRitualDiviner.m_41435_((Level)player.f_19853_, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (ray != null && ray.m_6662_() == HitResult.Type.BLOCK) {
                return;
            }
            if (!player.f_20911_) {
                if (player.m_6144_()) {
                    this.cycleRitual(stack, player, true);
                } else {
                    this.cycleDirection(stack, player);
                }
            }
        }
    }

    public void cycleDirection(ItemStack stack, Player player) {
        Direction direction = this.getDirection(stack);
        Direction newDirection = switch (direction) {
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.NORTH;
            default -> Direction.NORTH;
        };
        this.setDirection(stack, newDirection);
        this.notifyDirectionChange(newDirection, player);
    }

    public void notifyDirectionChange(Direction direction, Player player) {
        player.m_5661_((Component)new TranslatableComponent("tooltip.bloodmagic.diviner.currentDirection", new Object[]{Utils.toFancyCasing(direction.name())}), true);
    }

    public void setDirection(ItemStack stack, Direction direction) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("direction", direction.m_122411_());
    }

    public Direction getDirection(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
            return Direction.NORTH;
        }
        CompoundTag tag = stack.m_41783_();
        int dir = tag.m_128451_("direction");
        if (dir == 0) {
            return Direction.NORTH;
        }
        return Direction.values()[tag.m_128451_("direction")];
    }

    public void cycleRitual(ItemStack stack, Player player, boolean reverse) {
        String key = this.getCurrentRitual(stack);
        ArrayList rituals = BloodMagic.RITUAL_MANAGER.getSortedRituals();
        if (reverse) {
            rituals = Lists.newArrayList(rituals);
            Collections.reverse(rituals);
        }
        String firstId = "";
        boolean foundId = false;
        boolean foundFirst = false;
        for (Ritual ritual : rituals) {
            String id = BloodMagic.RITUAL_MANAGER.getId(ritual);
            if (!BloodMagic.RITUAL_MANAGER.enabled(id, false) || !this.canDivinerPerformRitual(stack, ritual)) continue;
            if (!foundFirst) {
                firstId = id;
                foundFirst = true;
            }
            if (foundId) {
                this.setCurrentRitual(stack, id);
                this.notifyRitualChange(id, player);
                return;
            }
            if (!id.equals(key)) continue;
            foundId = true;
        }
        if (foundFirst) {
            this.setCurrentRitual(stack, firstId);
            this.notifyRitualChange(firstId, player);
        }
    }

    public boolean canDivinerPerformRitual(ItemStack stack, Ritual ritual) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            if (this.canPlaceRitualStone(component.getRuneType(), stack)) continue;
            return false;
        }
        return true;
    }

    public void notifyRitualChange(String key, Player player) {
        Ritual ritual = BloodMagic.RITUAL_MANAGER.getRitual(key);
        if (ritual != null) {
            player.m_5661_((Component)new TranslatableComponent(ritual.getTranslationKey()), true);
        }
    }

    public void setCurrentRitual(ItemStack stack, String key) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        tag.m_128359_("current_ritual", key);
    }

    public String getCurrentRitual(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128461_("current_ritual");
    }

    public boolean canPlaceRitualStone(EnumRuneType rune, ItemStack stack) {
        int meta = this.type;
        switch (rune) {
            case BLANK: 
            case AIR: 
            case EARTH: 
            case FIRE: 
            case WATER: {
                return true;
            }
            case DUSK: {
                return meta >= 1;
            }
            case DAWN: {
                return meta >= 2;
            }
        }
        return false;
    }

    public static void spawnParticles(Level worldIn, BlockPos pos, int amount) {
        BlockState state = worldIn.m_8055_(pos);
        Block block = worldIn.m_8055_(pos).m_60734_();
        if (state.m_60795_()) {
            for (int i = 0; i < amount; ++i) {
                double d0 = worldIn.f_46441_.nextGaussian() * 0.02;
                double d1 = worldIn.f_46441_.nextGaussian() * 0.02;
                double d2 = worldIn.f_46441_.nextGaussian() * 0.02;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)((float)pos.m_123341_() + worldIn.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)worldIn.f_46441_.nextFloat(), (double)((float)pos.m_123343_() + worldIn.f_46441_.nextFloat()), d0, d1, d2);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = worldIn.f_46441_.nextGaussian() * 0.02;
                double d1 = worldIn.f_46441_.nextGaussian() * 0.02;
                double d2 = worldIn.f_46441_.nextGaussian() * 0.02;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)((float)pos.m_123341_() + worldIn.f_46441_.nextFloat() * 3.0f - 1.0f), (double)pos.m_123342_() + (double)worldIn.f_46441_.nextFloat() * 3.0 - 1.0, (double)((float)pos.m_123343_() + worldIn.f_46441_.nextFloat() * 3.0f - 1.0f), d0, d1, d2);
            }
        }
    }

    public void notifyBlockedBuild(Player player, BlockPos pos) {
        player.m_5661_((Component)new TranslatableComponent("chat.bloodmagic.diviner.blockedBuild", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), true);
    }
}

