/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableCuboid;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.TileAltar;

public class RenderAltar
implements BlockEntityRenderer<TileAltar> {
    private static final float MIN_HEIGHT = 0.499f;
    private static final float MAX_HEIGHT = 0.745f;

    public RenderAltar(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileAltar tileAltar, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        ItemStack inputStack = tileAltar.m_8020_(0);
        float level = (float)tileAltar.getCurrentBlood() / (float)tileAltar.getCapacity();
        this.renderItem(inputStack, tileAltar, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        this.renderFluid(level, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    private void renderFluid(float fluidLevel, PoseStack matrixStack, MultiBufferSource renderer, int combinedLightIn, int combinedOverlayIn) {
        Fluid fluid = (Fluid)BloodMagicBlocks.LIFE_ESSENCE_FLUID.get();
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        FluidRenderData data = new FluidRenderData(fluidStack);
        matrixStack.m_85836_();
        BloodMagicRenderer.Model3D model = this.getFluidModel(fluidLevel, data);
        VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
        RenderResizableCuboid.INSTANCE.renderCube(model, matrixStack, buffer, data.getColorARGB(1.0f), combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
    }

    private void renderItem(ItemStack stack, TileAltar tileAltar, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        if (!stack.m_41619_()) {
            matrixStack.m_85837_(0.5, 1.0, 0.5);
            matrixStack.m_85836_();
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            BakedModel ibakedmodel = itemRenderer.m_174264_(stack, tileAltar.m_58904_(), (LivingEntity)null, 1);
            itemRenderer.m_115143_(stack, ItemTransforms.TransformType.FIXED, true, matrixStack, buffer, combinedLightIn, combinedOverlayIn, ibakedmodel);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private BloodMagicRenderer.Model3D getFluidModel(float fluidLevel, FluidRenderData data) {
        BloodMagicRenderer.Model3D model = new BloodMagicRenderer.Model3D();
        model.setTexture(data.getTexture());
        model.minX = 0.1;
        model.minY = 0.499f;
        model.minZ = 0.1;
        model.maxX = 0.9;
        model.maxY = 0.24599999f * fluidLevel + 0.499f;
        model.maxZ = 0.9;
        return model;
    }

    public class FluidRenderData {
        public BlockPos location;
        public int height;
        public int length;
        public int width;
        public final FluidStack fluidType;

        public FluidRenderData(FluidStack fluidType) {
            this.fluidType = fluidType;
        }

        public TextureAtlasSprite getTexture() {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(this.fluidType.getFluid().getAttributes().getStillTexture());
        }

        public boolean isGaseous() {
            return this.fluidType.getFluid().getAttributes().isGaseous(this.fluidType);
        }

        public int getColorARGB(float scale) {
            return this.fluidType.getFluid().getAttributes().getColor(this.fluidType);
        }

        public int calculateGlowLight(int light) {
            return light;
        }

        public int hashCode() {
            int code = super.hashCode();
            code = 31 * code + this.fluidType.getFluid().getRegistryName().hashCode();
            if (this.fluidType.hasTag()) {
                code = 31 * code + this.fluidType.getTag().hashCode();
            }
            return code;
        }

        public boolean equals(Object data) {
            return super.equals(data) && data instanceof FluidRenderData && this.fluidType.isFluidEqual(((FluidRenderData)data).fluidType);
        }
    }
}

