/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic;

import com.google.gson.Gson;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.client.ClientEvents;
import wayoftime.bloodmagic.client.hud.Elements;
import wayoftime.bloodmagic.client.key.BloodMagicKeyHandler;
import wayoftime.bloodmagic.client.key.KeyBindings;
import wayoftime.bloodmagic.client.model.MimicModelLoader;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.data.GeneratorBaseRecipes;
import wayoftime.bloodmagic.common.data.GeneratorBlockStates;
import wayoftime.bloodmagic.common.data.GeneratorBlockTags;
import wayoftime.bloodmagic.common.data.GeneratorFluidTags;
import wayoftime.bloodmagic.common.data.GeneratorItemModels;
import wayoftime.bloodmagic.common.data.GeneratorItemTags;
import wayoftime.bloodmagic.common.data.GeneratorLanguage;
import wayoftime.bloodmagic.common.data.GeneratorLootTable;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeProvider;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.loot.BloodMagicLootFunctionManager;
import wayoftime.bloodmagic.common.loot.BloodMagicLootTypeManager;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicEntityTypes;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.compat.patchouli.RegisterPatchouliMultiblocks;
import wayoftime.bloodmagic.core.AnointmentRegistrar;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.data.DungeonRoomProvider;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.recipe.IngredientBloodOrb;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRegistry;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.impl.BloodMagicCorePlugin;
import wayoftime.bloodmagic.loot.GlobalLootModifier;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.CapabilityRuneType;
import wayoftime.bloodmagic.ritual.ModRituals;
import wayoftime.bloodmagic.ritual.RitualManager;
import wayoftime.bloodmagic.structures.ModDungeons;
import wayoftime.bloodmagic.structures.ModRoomPools;
import wayoftime.bloodmagic.util.handler.event.GenericHandler;
import wayoftime.bloodmagic.util.handler.event.WillHandler;

@Mod(value="bloodmagic")
public class BloodMagic {
    public static final String MODID = "bloodmagic";
    public static final Logger LOGGER = LogManager.getLogger();
    private static Gson GSON = null;
    public static final BloodMagicPacketHandler packetHandler = new BloodMagicPacketHandler();
    public static final RitualManager RITUAL_MANAGER = new RitualManager();
    public static final CreativeModeTab TAB = new CreativeModeTab("bloodmagictab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)BloodMagicBlocks.BLOOD_ALTAR.get());
        }
    };
    public static final String NAME = "Blood Magic: Alchemical Wizardry";

    public BloodMagic() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::onLoadComplete);
        BloodMagicItems.BLOOD_ORBS.createAndRegister(modBus, BloodOrb.class);
        LivingArmorRegistrar.UPGRADES.createAndRegister(modBus, LivingUpgrade.class);
        AnointmentRegistrar.ANOINTMENTS.createAndRegister(modBus, Anointment.class);
        BloodMagicBlocks.BLOCKS.register(modBus);
        BloodMagicItems.ITEMS.register(modBus);
        BloodMagicItems.BASICITEMS.register(modBus);
        BloodMagicBlocks.BASICBLOCKS.register(modBus);
        BloodMagicBlocks.DUNGEONBLOCKS.register(modBus);
        BloodMagicBlocks.FLUIDS.register(modBus);
        BloodMagicBlocks.CONTAINERS.register(modBus);
        BloodMagicEntityTypes.ENTITY_TYPES.register(modBus);
        BloodMagicTileEntities.TILE_ENTITIES.register(modBus);
        GlobalLootModifier.GLM.register(modBus);
        BloodMagicLootTypeManager.ENTRY_TYPES.register(modBus);
        BloodMagicLootFunctionManager.LOOT_FUNCTIONS.register(modBus);
        BloodMagicRecipeSerializers.RECIPE_SERIALIZERS.register(modBus);
        BloodMagicRecipeType.RECIPE_TYPES.register(modBus);
        modBus.addListener(this::setup);
        modBus.addListener(this::enqueueIMC);
        modBus.addListener(this::processIMC);
        modBus.addListener(this::doClientStuff);
        modBus.addListener(this::initRenderLayer);
        modBus.addListener(this::loadModels);
        modBus.addListener(this::gatherData);
        modBus.addListener(this::onRegisterCapabilities);
        modBus.addGenericListener(Fluid.class, this::registerFluids);
        modBus.addGenericListener(BlockEntityType.class, this::registerTileEntityTypes);
        modBus.addGenericListener(RecipeSerializer.class, this::registerRecipes);
        modBus.addGenericListener(MobEffect.class, BloodMagicPotions::registerPotions);
        modBus.addListener(ConfigManager::onCommonReload);
        MinecraftForge.EVENT_BUS.register((Object)new GenericHandler());
        modBus.addListener(this::registerColors);
        MinecraftForge.EVENT_BUS.register((Object)new WillHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigManager.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigManager.COMMON_SPEC);
        ModDungeons.init();
        ModRoomPools.init();
    }

    private void registerRecipes(RegistryEvent.Register<RecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)IngredientBloodOrb.NAME, IngredientBloodOrb.Serializer.INSTANCE);
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(CapabilityRuneType.class);
    }

    public static ResourceLocation rl(String name) {
        return new ResourceLocation(MODID, name);
    }

    public void registerFluids(RegistryEvent.Register<Fluid> event) {
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_WEAK.get())).getTier(), (Object)new ItemStack((ItemLike)BloodMagicItems.WEAK_BLOOD_ORB.get()));
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_APPRENTICE.get())).getTier(), (Object)new ItemStack((ItemLike)BloodMagicItems.APPRENTICE_BLOOD_ORB.get()));
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_MAGICIAN.get())).getTier(), (Object)new ItemStack((ItemLike)BloodMagicItems.MAGICIAN_BLOOD_ORB.get()));
        OrbRegistry.tierMap.put((Object)((BloodOrb)((Object)BloodMagicItems.ORB_MASTER.get())).getTier(), (Object)new ItemStack((ItemLike)BloodMagicItems.MASTER_BLOOD_ORB.get()));
        BloodMagicCorePlugin.INSTANCE.register(BloodMagicAPI.INSTANCE);
        RITUAL_MANAGER.discover();
        ModRituals.initHarvestHandlers();
        LivingArmorRegistrar.register();
        AnointmentRegistrar.register();
        AlchemyArrayRegistry.registerBaseArrays();
        BloodMagic.handleConfigValues(BloodMagicAPI.INSTANCE);
        ModRoomPools.registerSpecialRooms();
        if (ModList.get().isLoaded("patchouli")) {
            new RegisterPatchouliMultiblocks();
        }
    }

    public static void handleConfigValues(BloodMagicAPI api) {
        for (String value : (List)ConfigManager.COMMON.sacrificialValues.get()) {
            String[] split = value.split(";");
            if (split.length != 2) continue;
            api.getValueManager().setSacrificialValue(new ResourceLocation(split[0]), Integer.parseInt(split[1]));
        }
        for (String value : (List)ConfigManager.COMMON.wellOfSuffering.get()) {
            api.getBlacklist().addWellOfSuffering(new ResourceLocation(value));
        }
    }

    public void registerTileEntityTypes(RegistryEvent.Register<BlockEntityType<?>> event) {
        LOGGER.info("Attempting to register Tile Entities");
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        GeneratorItemModels itemModels = new GeneratorItemModels(gen, event.getExistingFileHelper());
        gen.m_123914_((DataProvider)itemModels);
        gen.m_123914_((DataProvider)new GeneratorBlockStates(gen, itemModels.existingFileHelper));
        gen.m_123914_((DataProvider)new GeneratorLanguage(gen));
        gen.m_123914_((DataProvider)new BloodMagicRecipeProvider(gen));
        gen.m_123914_((DataProvider)new GeneratorBaseRecipes(gen));
        gen.m_123914_((DataProvider)new GeneratorLootTable(gen));
        gen.m_123914_((DataProvider)new DungeonRoomProvider(gen));
        GeneratorBlockTags bmBlockTags = new GeneratorBlockTags(gen, event.getExistingFileHelper());
        gen.m_123914_((DataProvider)bmBlockTags);
        gen.m_123914_((DataProvider)new GeneratorItemTags(gen, bmBlockTags, event.getExistingFileHelper()));
        gen.m_123914_((DataProvider)new GeneratorFluidTags(gen, event.getExistingFileHelper()));
    }

    private void loadModels(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)BloodMagic.rl("mimicloader"), (IModelLoader)new MimicModelLoader(BloodMagic.rl("block/solidopaquemimic")));
        ModelLoaderRegistry.registerLoader((ResourceLocation)BloodMagic.rl("mimicloader_ethereal"), (IModelLoader)new MimicModelLoader(BloodMagic.rl("block/etherealopaquemimic")));
    }

    private void setup(FMLCommonSetupEvent event) {
        packetHandler.initialize();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientEvents.initClientEvents(event);
        Elements.registerElements();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        KeyBindings.initializeKeys();
        new BloodMagicKeyHandler();
    }

    private void initRenderLayer(EntityRenderersEvent.AddLayers event) {
        ClientEvents.initRenderLayer(event);
    }

    private void registerColors(ColorHandlerEvent event) {
        if (event instanceof ColorHandlerEvent.Item) {
            ClientEvents.colorHandlerEvent((ColorHandlerEvent.Item)event);
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }

        public static void onRecipeTypeRegister() {
        }
    }
}

