/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    public static final String LEGACY_ENERGY_KEY = "ifluxEnergy";
    public static final String ENERGY_KEY = "energy";
    static HashMap<Item, Boolean> reverseInsertion = new HashMap();

    public static void deserializeFrom(EnergyStorage storage, CompoundTag mainTag) {
        Object subtag = mainTag.m_128425_(LEGACY_ENERGY_KEY, 3) ? mainTag.m_128423_(LEGACY_ENERGY_KEY) : (mainTag.m_128425_(ENERGY_KEY, 3) ? mainTag.m_128423_(ENERGY_KEY) : IntTag.m_128679_((int)0));
        storage.deserializeNBT(subtag);
    }

    public static void serializeTo(EnergyStorage storage, CompoundTag mainTag) {
        mainTag.m_128365_(ENERGY_KEY, storage.serializeNBT());
    }

    public static int forceExtractFlux(ItemStack stack, int energy, boolean simulate) {
        if (stack.m_41619_()) {
            return 0;
        }
        Boolean b = reverseInsertion.get(stack.m_41720_());
        if (b == Boolean.TRUE) {
            int stored = EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
            EnergyHelper.insertFlux((ICapabilityProvider)stack, -energy, simulate);
            return stored - EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
        }
        int drawn = EnergyHelper.extractFlux((ICapabilityProvider)stack, energy, simulate);
        if (b == null) {
            int stored = EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
            EnergyHelper.insertFlux((ICapabilityProvider)stack, -energy, simulate);
            drawn = stored - EnergyHelper.getEnergyStored((ICapabilityProvider)stack);
            reverseInsertion.put(stack.m_41720_(), drawn > 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return drawn;
    }

    public static int getEnergyStored(ICapabilityProvider stack) {
        return EnergyHelper.getEnergyStored(stack, null);
    }

    public static int getEnergyStored(ICapabilityProvider stack, @Nullable Direction side) {
        if (stack == null) {
            return 0;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public static int getMaxEnergyStored(ICapabilityProvider stack) {
        return EnergyHelper.getMaxEnergyStored(stack, null);
    }

    public static int getMaxEnergyStored(ICapabilityProvider stack, @Nullable Direction side) {
        if (stack == null) {
            return 0;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY, side).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public static boolean isFluxReceiver(ICapabilityProvider tile) {
        return EnergyHelper.isFluxReceiver(tile, null);
    }

    public static boolean isFluxReceiver(ICapabilityProvider tile, @Nullable Direction facing) {
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).map(IEnergyStorage::canReceive).orElse(false);
    }

    public static boolean isFluxRelated(ICapabilityProvider tile) {
        return EnergyHelper.isFluxRelated(tile, null);
    }

    public static boolean isFluxRelated(ICapabilityProvider tile, @Nullable Direction facing) {
        if (tile == null) {
            return false;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).isPresent();
    }

    public static int insertFlux(ICapabilityProvider tile, int energy, boolean simulate) {
        return EnergyHelper.insertFlux(tile, null, energy, simulate);
    }

    public static int insertFlux(ICapabilityProvider tile, @Nullable Direction facing, int energy, boolean simulate) {
        if (tile == null) {
            return 0;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).map(storage -> storage.receiveEnergy(energy, simulate)).orElse(0);
    }

    public static int extractFlux(ICapabilityProvider tile, int energy, boolean simulate) {
        return EnergyHelper.extractFlux(tile, null, energy, simulate);
    }

    public static int extractFlux(ICapabilityProvider tile, @Nullable Direction facing, int energy, boolean simulate) {
        if (tile == null) {
            return 0;
        }
        return tile.getCapability(CapabilityEnergy.ENERGY, facing).map(storage -> storage.extractEnergy(energy, simulate)).orElse(0);
    }

    public static int distributeFlux(Collection<IEnergyStorage> storages, int amount, boolean simulate) {
        int finalAmount = amount;
        storages = storages.stream().filter(Objects::nonNull).map(storage -> Pair.of((Object)storage, (Object)storage.receiveEnergy(finalAmount, true))).sorted(Comparator.comparingInt(Pair::getSecond)).map(Pair::getFirst).collect(Collectors.toList());
        int remainingOutputs = storages.size();
        for (IEnergyStorage storage2 : storages) {
            int possibleOutput = (int)Math.ceil((float)amount / (float)remainingOutputs);
            int inserted = storage2.receiveEnergy(possibleOutput, simulate);
            amount -= inserted;
            --remainingOutputs;
        }
        return amount;
    }

    public static class ItemEnergyStorage
    implements IEnergyStorage {
        private final ItemStack stack;
        private final ToIntFunction<ItemStack> getCapacity;

        public ItemEnergyStorage(ItemStack item, ToIntFunction<ItemStack> getCapacity) {
            this.stack = item;
            this.getCapacity = getCapacity;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int stored = this.getEnergyStored();
            int accepted = Math.min(maxReceive, this.getMaxEnergyStored() - stored);
            if (!simulate) {
                ItemNBTHelper.putInt(this.stack, EnergyHelper.ENERGY_KEY, stored += accepted);
            }
            return accepted;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int stored = this.getEnergyStored();
            int extracted = Math.min(maxExtract, stored);
            if (!simulate) {
                ItemNBTHelper.putInt(this.stack, EnergyHelper.ENERGY_KEY, stored -= extracted);
            }
            return extracted;
        }

        public int getEnergyStored() {
            return ItemNBTHelper.getInt(this.stack, EnergyHelper.ENERGY_KEY);
        }

        public int getMaxEnergyStored() {
            return this.getCapacity.applyAsInt(this.stack);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

