/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui.info;

import blusunrize.immersiveengineering.client.gui.info.FluidInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.fluids.FluidStack;

public class MultitankArea
extends InfoArea {
    private final MultiFluidTank tank;

    public MultitankArea(Rect2i area, MultiFluidTank tank) {
        super(area);
        this.tank = tank;
    }

    @Override
    protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        if (this.tank.getFluidTypes() == 0) {
            tooltip.add((Component)new TranslatableComponent("gui.immersiveengineering.empty"));
        } else {
            float capacity = this.tank.getCapacity();
            int myRelative = this.area.m_110086_() + this.area.m_110091_() - mouseY;
            this.forEachFluid((fluid, lastY, newY) -> {
                if (myRelative >= lastY && myRelative < newY) {
                    FluidInfoArea.fillTooltip(fluid, (int)capacity, tooltip::add);
                }
            });
        }
    }

    @Override
    public void draw(PoseStack transform) {
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.forEachFluid((fluid, lastY, newY) -> GuiHelper.drawRepeatedFluidSpriteGui((MultiBufferSource)buffers, transform, fluid, this.area.m_110085_(), this.area.m_110086_() + this.area.m_110091_() - newY, this.area.m_110090_(), newY - lastY));
        buffers.m_109911_();
    }

    private void forEachFluid(TankVisitor visitor) {
        float capacity = this.tank.getCapacity();
        int fluidUpToNow = 0;
        int lastY = 0;
        for (int i = this.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = this.tank.fluids.get(i);
            if (fs.isEmpty()) continue;
            int newY = (int)((float)this.area.m_110091_() * ((float)(fluidUpToNow += fs.getAmount()) / capacity));
            visitor.visit(fs, lastY, newY);
            lastY = newY;
        }
    }

    private static interface TankVisitor {
        public void visit(FluidStack var1, int var2, int var3);
    }
}

