/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.conveyor;

import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.utils.PlayerUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IConveyorBelt {
    public static final VoxelShape conveyorBounds = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0);
    public static final VoxelShape highConveyorBounds = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0);
    public static final VoxelShape FULL_BLOCK = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public BlockEntity getBlockEntity();

    public Direction getFacing();

    default public ConveyorHandler.ConveyorDirection getConveyorDirection() {
        return ConveyorHandler.ConveyorDirection.HORIZONTAL;
    }

    public boolean changeConveyorDirection();

    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection var1);

    default public void afterRotation(Direction oldDir, Direction newDir) {
    }

    public boolean isActive();

    public boolean setDyeColour(DyeColor var1);

    @Nullable
    public DyeColor getDyeColour();

    default public boolean playerInteraction(Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        return false;
    }

    default public Direction[] sigTransportDirections() {
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.UP) {
            return new Direction[]{this.getFacing(), Direction.UP};
        }
        if (this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.DOWN) {
            return new Direction[]{this.getFacing(), Direction.DOWN};
        }
        return new Direction[]{this.getFacing()};
    }

    default public Vec3 getDirection(Entity entity, boolean outputBlocked) {
        ConveyorHandler.ConveyorDirection conveyorDirection = this.getConveyorDirection();
        BlockPos pos = this.getBlockEntity().m_58899_();
        Direction facing = this.getFacing();
        double vBase = 1.15;
        double vX = 0.1 * vBase * (double)facing.m_122429_();
        double vY = entity.m_20184_().f_82480_;
        double vZ = 0.1 * vBase * (double)facing.m_122431_();
        if (facing == Direction.WEST || facing == Direction.EAST) {
            if (entity.m_20189_() > (double)pos.m_123343_() + 0.55) {
                vZ = -0.1 * vBase;
            } else if (entity.m_20189_() < (double)pos.m_123343_() + 0.45) {
                vZ = 0.1 * vBase;
            }
        } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            if (entity.m_20185_() > (double)pos.m_123341_() + 0.55) {
                vX = -0.1 * vBase;
            } else if (entity.m_20185_() < (double)pos.m_123341_() + 0.45) {
                vX = 0.1 * vBase;
            }
        }
        if (conveyorDirection != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            Vec3 centerRelative = entity.m_20182_().m_82546_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_82492_(0.5 + vX, 0.5, 0.5 + vZ);
            double conveyorHeight = 0.125;
            Vec3i directionVector = facing.m_122436_();
            double centerOffsetInDirection = centerRelative.m_82526_(new Vec3((double)directionVector.m_123341_(), (double)directionVector.m_123342_(), (double)directionVector.m_123343_()));
            double radius = entity.m_6972_((Pose)entity.m_20089_()).f_20377_ / 2.0f;
            double maxEntityPos = centerOffsetInDirection + radius;
            double maxCenterHeightUnderEntity = maxEntityPos + 0.125;
            if (conveyorDirection == ConveyorHandler.ConveyorDirection.DOWN) {
                maxCenterHeightUnderEntity = -maxCenterHeightUnderEntity;
            }
            if (conveyorDirection == ConveyorHandler.ConveyorDirection.UP) {
                if (maxCenterHeightUnderEntity > centerRelative.f_82480_ || !outputBlocked) {
                    vY = 0.17 * vBase;
                }
            } else {
                vY = Math.signum(maxCenterHeightUnderEntity - centerRelative.f_82480_) * 0.07 * vBase;
            }
            entity.m_6853_(false);
        }
        return new Vec3(vX, vY, vZ);
    }

    default public void onEntityCollision(@Nonnull Entity entity) {
        if (!this.isActive() || !entity.m_6084_()) {
            return;
        }
        if (entity instanceof Player && entity.m_6144_()) {
            return;
        }
        PlayerUtils.resetFloatingState(entity);
        ConveyorHandler.ConveyorDirection conveyorDirection = this.getConveyorDirection();
        float heightLimit = conveyorDirection == ConveyorHandler.ConveyorDirection.HORIZONTAL ? 0.25f : 1.0f;
        BlockPos pos = this.getBlockEntity().m_58899_();
        double relativeHeight = entity.m_20186_() - (double)pos.m_123342_();
        if (relativeHeight >= 0.0 && relativeHeight < (double)heightLimit) {
            boolean hasBeenHandled = !ConveyorHandler.markEntityAsHandled(entity);
            boolean outputBlocked = this.isOutputBlocked();
            Vec3 vec = this.getDirection(entity, outputBlocked);
            if (entity.f_19789_ < 3.0f) {
                entity.f_19789_ = 0.0f;
            }
            if (outputBlocked) {
                double replacementZ;
                double replacementX;
                if (hasBeenHandled) {
                    replacementX = entity.m_20184_().f_82479_;
                    replacementZ = entity.m_20184_().f_82481_;
                } else {
                    replacementX = 0.0;
                    replacementZ = 0.0;
                }
                vec = new Vec3(replacementX, vec.f_82480_, replacementZ);
            }
            entity.m_20256_(vec);
            double distX = Math.abs((double)pos.m_142300_(this.getFacing()).m_123341_() + 0.5 - entity.m_20185_());
            double distZ = Math.abs((double)pos.m_142300_(this.getFacing()).m_123343_() + 0.5 - entity.m_20189_());
            double threshold = 0.9;
            boolean contact = this.getFacing().m_122434_() == Direction.Axis.Z ? distZ < threshold : distX < threshold;
            Level w = (Level)Preconditions.checkNotNull((Object)this.getBlockEntity().m_58904_());
            BlockPos upPos = pos.m_142300_(this.getFacing()).m_7494_();
            if (contact && conveyorDirection == ConveyorHandler.ConveyorDirection.UP && !Block.m_49918_((VoxelShape)w.m_8055_(upPos).m_60808_((BlockGetter)w, upPos), (Direction)Direction.DOWN)) {
                double move = 0.4;
                entity.m_6034_(entity.m_20185_() + move * (double)this.getFacing().m_122429_(), entity.m_20186_() + 1.0 * move, entity.m_20189_() + move * (double)this.getFacing().m_122431_());
            }
            if (!contact) {
                ConveyorHandler.applyMagnetSuppression(entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
            } else {
                BlockPos nextPos = this.getBlockEntity().m_58899_().m_142300_(this.getFacing());
                if (!(SafeChunkUtils.getSafeBE((LevelAccessor)this.getBlockEntity().m_58904_(), nextPos) instanceof ConveyorHandler.IConveyorBlockEntity)) {
                    ConveyorHandler.revertMagnetSuppression(entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
                }
            }
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                if (entity.f_19797_ > 1) {
                    if (!contact) {
                        ConveyorHandler.ItemAgeAccessor access = ConveyorHandler.ITEM_AGE_ACCESS.getValue();
                        if (item.m_32059_() > item.lifespan - 1200 && !outputBlocked) {
                            access.setAge(item, item.lifespan - 1200);
                        }
                    } else if (!w.f_46443_) {
                        this.handleInsertion(item, conveyorDirection, distX, distZ);
                    }
                }
            }
        }
    }

    default public boolean isBlocked() {
        return false;
    }

    default public boolean isOutputBlocked() {
        Level level = Objects.requireNonNull(this.getBlockEntity().m_58904_());
        for (BlockPos pos : this.getNextConveyorCandidates()) {
            LevelChunk chunk = SafeChunkUtils.getSafeChunk((LevelAccessor)level, pos);
            if (chunk == null || !level.f_46443_ && !chunk.m_6708_().m_140114_(ChunkHolder.FullChunkStatus.ENTITY_TICKING)) {
                return true;
            }
            BlockEntity outputTile = chunk.m_7702_(pos);
            if (!(outputTile instanceof ConveyorHandler.IConveyorBlockEntity)) continue;
            ConveyorHandler.IConveyorBlockEntity convOut = (ConveyorHandler.IConveyorBlockEntity)outputTile;
            return convOut.getConveyorInstance().isBlocked();
        }
        return false;
    }

    default public void onItemDeployed(ItemEntity entity) {
        ConveyorHandler.applyMagnetSuppression((Entity)entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
    }

    default public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        BlockPos invPos = this.getOutputInventory();
        Level world = this.getBlockEntity().m_58904_();
        boolean contact = this.getFacing().m_122434_() == Direction.Axis.Z ? distZ < 0.7 : distX < 0.7;
        BlockEntity inventoryTile = SafeChunkUtils.getSafeBE((LevelAccessor)world, invPos);
        if (!contact || inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity) {
            return;
        }
        ItemUtils.tryInsertEntity(world, invPos, this.getFacing().m_122424_(), entity);
    }

    default public BlockPos getOutputInventory() {
        ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
        return this.getBlockEntity().m_58899_().m_142300_(this.getFacing()).m_142082_(0, conDir == ConveyorHandler.ConveyorDirection.UP ? 1 : (conDir == ConveyorHandler.ConveyorDirection.DOWN ? -1 : 0), 0);
    }

    default public List<BlockPos> getNextConveyorCandidates() {
        ConveyorHandler.ConveyorDirection conDir = this.getConveyorDirection();
        BlockPos basePos = this.getOutputInventory();
        BlockPos alternative = conDir == ConveyorHandler.ConveyorDirection.DOWN ? basePos.m_7494_() : basePos.m_7495_();
        return ImmutableList.of((Object)basePos, (Object)alternative);
    }

    @Nullable
    default public IConveyorBelt getOutputConveyor() {
        for (BlockPos pos : this.getNextConveyorCandidates()) {
            BlockEntity outputTile = SafeChunkUtils.getSafeBE((LevelAccessor)this.getBlockEntity().m_58904_(), pos);
            if (!(outputTile instanceof ConveyorHandler.IConveyorBlockEntity)) continue;
            ConveyorHandler.IConveyorBlockEntity convOut = (ConveyorHandler.IConveyorBlockEntity)outputTile;
            return convOut.getConveyorInstance();
        }
        return null;
    }

    default public void tickServer() {
    }

    default public VoxelShape getSelectionShape() {
        return this.getConveyorDirection() == ConveyorHandler.ConveyorDirection.HORIZONTAL ? conveyorBounds : highConveyorBounds;
    }

    default public VoxelShape getCollisionShape() {
        return conveyorBounds;
    }

    public CompoundTag writeConveyorNBT();

    public void readConveyorNBT(CompoundTag var1);

    public IConveyorType<?> getType();

    public Block getCover();

    public static Block getCoverOrDefault(@Nullable IConveyorBelt belt, Block fallback) {
        return belt != null ? belt.getCover() : fallback;
    }

    public static boolean isCovered(@Nullable IConveyorBelt belt, Block fallback) {
        return IConveyorBelt.getCoverOrDefault(belt, fallback) != Blocks.f_50016_;
    }

    public void setCover(Block var1);
}

