/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.events;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.fml.LogicalSide;

@Cancelable
public class ItemUseEvent
extends PlayerEvent {
    private final InteractionHand hand;
    private final BlockPos pos;
    @Nullable
    private final Direction face;
    private InteractionResult cancellationResult = InteractionResult.PASS;
    private final UseOnContext ctx;

    public ItemUseEvent(UseOnContext ctx) {
        super((Player)Preconditions.checkNotNull((Object)ctx.m_43723_(), (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (InteractionHand)Preconditions.checkNotNull((Object)ctx.m_43724_(), (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (BlockPos)Preconditions.checkNotNull((Object)ctx.m_8083_(), (Object)"Null position in PlayerInteractEvent!");
        this.face = ctx.m_43719_();
        this.ctx = ctx;
    }

    public UseOnContext getContext() {
        return this.ctx;
    }

    @Nonnull
    public InteractionHand getHand() {
        return this.hand;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getPlayer().m_21120_(this.hand);
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    public Direction getFace() {
        return this.face;
    }

    public Level getWorld() {
        return this.getPlayer().m_20193_();
    }

    public LogicalSide getSide() {
        return this.getWorld().f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER;
    }

    public InteractionResult getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(InteractionResult result) {
        this.cancellationResult = result;
    }
}

