/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.container;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkHooks;
import shadows.placebo.cap.ModifiableEnergyStorage;
import shadows.placebo.container.SimplerMenuProvider;

public class ContainerUtil {
    public static void deserializeEnergy(ModifiableEnergyStorage energy, int value, boolean upper) {
        energy.setEnergy(ContainerUtil.merge(energy.getEnergyStored(), value, upper));
    }

    public static int split(int value, boolean upper) {
        return upper ? value >> 16 : value & 0xFFFF;
    }

    public static int merge(int current, int value, boolean upper) {
        if (upper) {
            return current & 0xFFFF | value << 16;
        }
        return current & 0xFFFF0000 | value & 0xFFFF;
    }

    public static <T extends AbstractContainerMenu> MenuType<T> makeType(PosFactory<T> fac) {
        return new MenuType(ContainerUtil.factory(fac));
    }

    public static <T extends AbstractContainerMenu> IContainerFactory<T> factory(PosFactory<T> fac) {
        return (id, inv, buf) -> (AbstractContainerMenu)fac.create(id, inv, buf.m_130135_());
    }

    public static <M extends AbstractContainerMenu> InteractionResult openGui(Player player, BlockPos pos, PosFactory<M> factory) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), new SimplerMenuProvider<M>(player.f_19853_, pos, factory), (BlockPos)pos);
        return InteractionResult.CONSUME;
    }

    public static interface PosFactory<T> {
        public T create(int var1, Inventory var2, BlockPos var3);
    }
}

