/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.ArmorModelHelper;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class PlateArmorModel
extends Model {
    private static final Map<ResourceLocation, PlateArmorModel> MODELS = new HashMap<ResourceLocation, PlateArmorModel>();
    private static final Function<ResourceLocation, PlateArmorModel> CONSTRUCTOR = PlateArmorModel::new;
    private static final ResourceLocation PLATE = TConstruct.getResource("plate");
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> MODELS.clear();
    private final Map<String, RenderType> ARMOR_RENDER_CACHE = new HashMap<String, RenderType>();
    private final Map<String, RenderType> LEG_RENDER_CACHE = new HashMap<String, RenderType>();
    private final Function<String, RenderType> ARMOR_GETTER = mat -> RenderType.m_110464_((ResourceLocation)this.getArmorTexture((String)mat, 1));
    private final Function<String, RenderType> LEG_GETTER = mat -> RenderType.m_110464_((ResourceLocation)this.getArmorTexture((String)mat, 2));
    private final ResourceLocation name;
    @Nullable
    private HumanoidModel<?> base;
    private String material = "";
    private boolean isLegs = false;
    private boolean hasGlint = false;

    public static Model getModel(ItemStack stack, EquipmentSlot slot, HumanoidModel<?> baseModel, ResourceLocation name) {
        PlateArmorModel model = MODELS.computeIfAbsent(name, CONSTRUCTOR);
        model.setup(baseModel, stack, slot);
        return model;
    }

    public static Model getModel(ItemStack stack, EquipmentSlot slot, HumanoidModel<?> baseModel) {
        return PlateArmorModel.getModel(stack, slot, baseModel, PLATE);
    }

    public PlateArmorModel(ResourceLocation name) {
        super(RenderType::m_110458_);
        this.name = name;
    }

    public void m_7695_(PoseStack matrices, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            this.base.m_7695_(matrices, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (!this.material.isEmpty() && ArmorModelHelper.buffer != null) {
                VertexConsumer overlayBuffer = ItemRenderer.m_115184_((MultiBufferSource)ArmorModelHelper.buffer, (RenderType)(this.isLegs ? this.LEG_RENDER_CACHE.computeIfAbsent(this.material, this.LEG_GETTER) : this.ARMOR_RENDER_CACHE.computeIfAbsent(this.material, this.ARMOR_GETTER)), (boolean)false, (boolean)this.hasGlint);
                this.base.m_7695_(matrices, overlayBuffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }

    private ResourceLocation getArmorTexture(String material, int variant) {
        MaterialVariantId variantId = MaterialVariantId.tryParse(material);
        if (variantId == null) {
            variantId = MaterialIds.cobalt;
        }
        ResourceLocation location = variantId.getLocation('_');
        return new ResourceLocation(this.name.m_135827_(), String.format("textures/models/armor/%s/layer_%d_%s_%s.png", this.name.m_135815_(), variant, location.m_135827_(), location.m_135815_()));
    }

    private void setup(HumanoidModel<?> base, ItemStack stack, EquipmentSlot slot) {
        this.base = base;
        this.material = ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0 ? MaterialIds.gold.toString() : ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        this.isLegs = slot == EquipmentSlot.LEGS;
        this.hasGlint = stack.m_41790_();
    }
}

