/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.shared.block.entity.TableBlockEntity;

public abstract class RetexturedTableBlockEntity
extends TableBlockEntity
implements IRetexturedBlockEntity {
    private static final String TAG_TEXTURE = "texture";
    private final Lazy<IModelData> data = Lazy.of(() -> ((RetexturedTableBlockEntity)this).getRetexturedModelData());
    @Nonnull
    private Block texture = Blocks.f_50016_;

    public RetexturedTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Component name, int size) {
        super(type, pos, state, name, size);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 2, 1));
    }

    @Nonnull
    public IModelData getModelData() {
        return (IModelData)this.data.get();
    }

    public String getTextureName() {
        if (this.texture == Blocks.f_50016_) {
            return "";
        }
        return Objects.requireNonNull(this.texture.getRegistryName()).toString();
    }

    private void textureUpdated() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            Block normalizedTexture = this.texture == Blocks.f_50016_ ? null : this.texture;
            IModelData data = this.getModelData();
            if (data.getData(RetexturedHelper.BLOCK_PROPERTY) != normalizedTexture) {
                data.setData(RetexturedHelper.BLOCK_PROPERTY, (Object)normalizedTexture);
                this.requestModelDataUpdate();
                BlockState state = this.m_58900_();
                this.f_58857_.m_7260_(this.f_58858_, state, state, 0);
            }
        }
    }

    public void updateTexture(String name) {
        Block oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock((String)name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            this.textureUpdated();
        }
    }

    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.texture != Blocks.f_50016_) {
            tags.m_128359_(TAG_TEXTURE, Objects.requireNonNull(this.texture.getRegistryName()).toString());
        }
    }

    public void m_142466_(CompoundTag tags) {
        CompoundTag forgeData;
        super.m_142466_(tags);
        if (tags.m_128425_(TAG_TEXTURE, 8)) {
            this.texture = RetexturedHelper.getBlock((String)tags.m_128461_(TAG_TEXTURE));
            this.textureUpdated();
        } else if (tags.m_128425_("ForgeData", 10) && (forgeData = tags.m_128469_("ForgeData")).m_128425_(TAG_TEXTURE, 8)) {
            this.texture = RetexturedHelper.getBlock((String)forgeData.m_128461_(TAG_TEXTURE));
            this.textureUpdated();
            forgeData.m_128473_(TAG_TEXTURE);
        }
    }

    @Nonnull
    public Block getTexture() {
        return this.texture;
    }
}

