/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public abstract class SmelteryInputOutputBlockEntity<T>
extends SmelteryComponentBlockEntity
implements IRetexturedBlockEntity {
    private final Capability<T> capability;
    protected final T emptyInstance;
    protected final NonNullConsumer<LazyOptional<T>> listener = new WeakConsumerWrapper((Object)this, (te, cap) -> te.clearHandler());
    @Nullable
    private LazyOptional<T> capabilityHolder = null;
    private final IModelData modelData = this.getRetexturedModelData();
    @Nonnull
    private Block texture = Blocks.f_50016_;

    protected SmelteryInputOutputBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Capability<T> capability, T emptyInstance) {
        super(type, pos, state);
        this.capability = capability;
        this.emptyInstance = emptyInstance;
    }

    private void clearHandler() {
        if (this.capabilityHolder != null) {
            this.capabilityHolder.invalidate();
            this.capabilityHolder = null;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.clearHandler();
    }

    @Override
    protected void setMaster(@Nullable BlockPos master, @Nullable Block block) {
        assert (this.f_58857_ != null);
        boolean masterChanged = false;
        if (!Objects.equals(this.getMasterPos(), master)) {
            this.clearHandler();
            masterChanged = true;
        }
        super.setMaster(master, block);
        if (masterChanged) {
            this.f_58857_.m_6289_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    protected LazyOptional<T> getCapability(BlockEntity parent) {
        LazyOptional handler = parent.getCapability(this.capability);
        if (handler.isPresent()) {
            handler.addListener(this.listener);
            return LazyOptional.of(() -> handler.orElse(this.emptyInstance));
        }
        return LazyOptional.empty();
    }

    private LazyOptional<T> getCachedCapability() {
        if (this.capabilityHolder == null) {
            BlockEntity te;
            BlockPos master;
            if (this.validateMaster() && (master = this.getMasterPos()) != null && this.f_58857_ != null && (te = this.f_58857_.m_7702_(master)) != null) {
                this.capabilityHolder = this.getCapability(te);
                return this.capabilityHolder;
            }
            this.capabilityHolder = LazyOptional.empty();
        }
        return this.capabilityHolder;
    }

    @Nonnull
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == this.capability) {
            return this.getCachedCapability().cast();
        }
        return super.getCapability(capability, facing);
    }

    public IModelData getRetexturedModelData() {
        return new SinglePropertyData(RetexturedHelper.BLOCK_PROPERTY);
    }

    public String getTextureName() {
        return RetexturedHelper.getTextureName((Block)this.texture);
    }

    public void updateTexture(String name) {
        Block oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock((String)name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            RetexturedHelper.onTextureUpdated((BlockEntity)this);
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.texture != Blocks.f_50016_) {
            tags.m_128359_("texture", this.getTextureName());
        }
    }

    @Override
    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_("texture", 8)) {
            this.texture = RetexturedHelper.getBlock((String)tags.m_128461_("texture"));
            RetexturedHelper.onTextureUpdated((BlockEntity)this);
        }
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    @Nonnull
    public Block getTexture() {
        return this.texture;
    }

    public static class ChuteBlockEntity
    extends SmelteryInputOutputBlockEntity<IItemHandler> {
        public ChuteBlockEntity(BlockPos pos, BlockState state) {
            this((BlockEntityType)TinkerSmeltery.chute.get(), pos, state);
        }

        protected ChuteBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EmptyItemHandler.INSTANCE);
        }
    }

    public static abstract class SmelteryFluidIO
    extends SmelteryInputOutputBlockEntity<IFluidHandler> {
        protected SmelteryFluidIO(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EmptyFluidHandler.INSTANCE);
        }

        protected LazyOptional<IFluidHandler> makeWrapper(LazyOptional<IFluidHandler> capability) {
            return LazyOptional.of(() -> (IFluidHandler)capability.orElse((Object)((IFluidHandler)this.emptyInstance)));
        }

        @Override
        protected LazyOptional<IFluidHandler> getCapability(BlockEntity parent) {
            LazyOptional<IFluidHandler> capability;
            if (parent instanceof ISmelteryTankHandler && (capability = ((ISmelteryTankHandler)parent).getFluidCapability()).isPresent()) {
                capability.addListener(this.listener);
                return this.makeWrapper(capability);
            }
            return LazyOptional.empty();
        }

        @Override
        public IModelData getRetexturedModelData() {
            return new ModelDataMap.Builder().withProperty(RetexturedHelper.BLOCK_PROPERTY).withProperty(IDisplayFluidListener.PROPERTY).build();
        }
    }
}

