/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.capability.FluidModifierHookIterator;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ToolFluidCapability
extends FluidModifierHookIterator<ModifierEntry>
implements IFluidHandlerItem {
    public static final ResourceLocation TOTAL_TANKS = TConstruct.getResource("total_tanks");
    public static final ModifierHook<FluidModifierHook> HOOK = ModifierHooks.register(TConstruct.getResource("fluid"), FluidModifierHook.class, new FluidModifierHook(){

        @Override
        public int getTanks(IToolContext tool, Modifier modifier) {
            IFluidModifier hook = modifier.getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getTanks(tool.getVolatileData());
            }
            return 0;
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getFluidInTank(tool, modifier.getLevel(), tank);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.getTankCapacity(tool, modifier.getLevel(), tank);
            }
            return 0;
        }

        @Override
        public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.isFluidValid(tool, modifier.getLevel(), tank, fluid);
            }
            return false;
        }

        @Override
        public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.fill(tool, modifier.getLevel(), resource, action);
            }
            return 0;
        }

        @Override
        public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.drain(tool, modifier.getLevel(), resource, action);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
            IFluidModifier hook = modifier.getModifier().getModule(IFluidModifier.class);
            if (hook != null) {
                return hook.drain(tool, modifier.getLevel(), maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }, FluidModifierHookMerger::new);
    private final ItemStack container;
    private final Supplier<? extends IToolStackView> tool;

    public int getTanks() {
        return this.tool.get().getVolatileData().getInt(TOTAL_TANKS);
    }

    @Override
    protected Iterator<ModifierEntry> getIterator(IToolStackView tool) {
        return tool.getModifierList().iterator();
    }

    @Override
    protected FluidModifierHook getHook(ModifierEntry entry) {
        this.indexEntry = entry;
        return entry.getHook(HOOK);
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, tank);
        if (hook != null) {
            return hook.getFluidInTank(tool, this.indexEntry, tank - this.startIndex);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, tank);
        if (hook != null) {
            return hook.getTankCapacity(tool, this.indexEntry, tank - this.startIndex);
        }
        return 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        IToolStackView tool = this.tool.get();
        FluidModifierHook hook = (FluidModifierHook)this.findHook(tool, tank);
        if (hook != null) {
            return hook.isFluidValid(tool, this.indexEntry, tank - this.startIndex, stack);
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fill(this.tool.get(), resource, action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(this.tool.get(), resource, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(this.tool.get(), maxDrain, action);
    }

    @Deprecated
    public static void addTanks(ModDataNBT volatileData, IFluidModifier modifier) {
        volatileData.putInt(TOTAL_TANKS, modifier.getTanks(volatileData) + volatileData.getInt(TOTAL_TANKS));
    }

    public static void addTanks(IToolContext tool, Modifier modifier, ModDataNBT volatileData, FluidModifierHook hook) {
        volatileData.putInt(TOTAL_TANKS, hook.getTanks(tool, modifier) + volatileData.getInt(TOTAL_TANKS));
    }

    public ToolFluidCapability(ItemStack container, Supplier<? extends IToolStackView> tool) {
        this.container = container;
        this.tool = tool;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public static interface FluidModifierHook {
        default public int getTanks(IToolContext tool, Modifier modifier) {
            return 1;
        }

        default public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            return FluidStack.EMPTY;
        }

        default public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            return 0;
        }

        default public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            return true;
        }

        public int fill(IToolStackView var1, ModifierEntry var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IToolStackView var1, ModifierEntry var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IToolStackView var1, ModifierEntry var2, int var3, IFluidHandler.FluidAction var4);
    }

    @Deprecated
    public static interface IFluidModifier {
        default public int getTanks(IModDataView volatileData) {
            return 0;
        }

        default public FluidStack getFluidInTank(IToolStackView tool, int level, int tank) {
            return FluidStack.EMPTY;
        }

        default public int getTankCapacity(IToolStackView tool, int level, int tank) {
            return 0;
        }

        default public boolean isFluidValid(IToolStackView tool, int level, int tank, FluidStack fluid) {
            return true;
        }

        public int fill(IToolStackView var1, int var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IToolStackView var1, int var2, FluidStack var3, IFluidHandler.FluidAction var4);

        public FluidStack drain(IToolStackView var1, int var2, int var3, IFluidHandler.FluidAction var4);
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<IFluidHandlerItem> fluidCap = LazyOptional.of(() -> new ToolFluidCapability(stack, toolStack));

        public Provider(ItemStack stack, Supplier<? extends IToolStackView> toolStack) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY && tool.getVolatileData().getInt(TOTAL_TANKS) > 0) {
                return this.fluidCap.cast();
            }
            return LazyOptional.empty();
        }
    }

    private static class FluidModifierHookMerger
    extends FluidModifierHookIterator<FluidModifierHook>
    implements FluidModifierHook {
        private final Collection<FluidModifierHook> modules;

        @Override
        protected Iterator<FluidModifierHook> getIterator(IToolStackView tool) {
            return this.modules.iterator();
        }

        @Override
        protected FluidModifierHook getHook(FluidModifierHook entry) {
            return entry;
        }

        @Nullable
        private FluidModifierHook findHook(IToolStackView tool, ModifierEntry modifier, int tank) {
            this.indexEntry = modifier;
            return (FluidModifierHook)this.findHook(tool, tank);
        }

        @Override
        public int getTanks(IToolContext tool, Modifier modifier) {
            int sum = 0;
            for (FluidModifierHook module : this.modules) {
                sum += module.getTanks(tool, modifier);
            }
            return sum;
        }

        @Override
        public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
            FluidModifierHook hook = this.findHook(tool, modifier, tank);
            if (hook != null) {
                return hook.getFluidInTank(tool, modifier, tank - this.startIndex);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
            FluidModifierHook hook = this.findHook(tool, modifier, tank);
            if (hook != null) {
                return hook.getTankCapacity(tool, modifier, tank - this.startIndex);
            }
            return 0;
        }

        @Override
        public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
            FluidModifierHook hook = this.findHook(tool, modifier, tank);
            if (hook != null) {
                return hook.isFluidValid(tool, modifier, tank - this.startIndex, fluid);
            }
            return false;
        }

        @Override
        public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
            this.indexEntry = modifier;
            return this.fill(tool, resource, action);
        }

        @Override
        public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
            this.indexEntry = modifier;
            return this.drain(tool, resource, action);
        }

        @Override
        public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
            this.indexEntry = modifier;
            return this.drain(tool, maxDrain, action);
        }

        public FluidModifierHookMerger(Collection<FluidModifierHook> modules) {
            this.modules = modules;
        }
    }
}

