/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifierAttribute {
    private final String name;
    private final Attribute attribute;
    private final AttributeModifier.Operation operation;
    private final float amount;
    private final UUID[] slotUUIDs;

    public ModifierAttribute(String name, Attribute attribute, AttributeModifier.Operation operation, float amount, List<EquipmentSlot> slots) {
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
        this.slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : slots) {
            this.slotUUIDs[slot.m_20750_()] = ModifierAttribute.getUUID(name, slot);
        }
    }

    public ModifierAttribute(String name, Attribute attribute, AttributeModifier.Operation operation, float amount, EquipmentSlot ... slots) {
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
        this.slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : slots) {
            this.slotUUIDs[slot.m_20750_()] = ModifierAttribute.getUUID(name, slot);
        }
    }

    public void apply(IToolStackView tool, float level, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        UUID uuid = this.slotUUIDs[slot.m_20750_()];
        if (uuid != null) {
            consumer.accept(this.attribute, new AttributeModifier(uuid, this.name + "." + slot.m_20751_(), (double)(this.amount * level), this.operation));
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("unique", this.name);
        json.addProperty("attribute", Objects.requireNonNull(this.attribute.getRegistryName()).toString());
        json.addProperty("operation", this.operation.name().toLowerCase(Locale.ROOT));
        json.addProperty("amount", (Number)Float.valueOf(this.amount));
        JsonArray array = new JsonArray();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (this.slotUUIDs[slot.m_20750_()] == null) continue;
            array.add(slot.m_20751_());
        }
        json.add("slots", (JsonElement)array);
        return json;
    }

    public static ModifierAttribute fromJson(JsonObject json) {
        String unique = GsonHelper.m_13906_((JsonObject)json, (String)"unique");
        Attribute attribute = (Attribute)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (JsonObject)json, (String)"attribute");
        AttributeModifier.Operation op = (AttributeModifier.Operation)JsonHelper.getAsEnum((JsonObject)json, (String)"operation", AttributeModifier.Operation.class);
        float amount = GsonHelper.m_13915_((JsonObject)json, (String)"amount");
        List slots = JsonHelper.parseList((JsonObject)json, (String)"slots", (element, string) -> EquipmentSlot.m_20747_((String)GsonHelper.m_13805_((JsonElement)element, (String)string)));
        return new ModifierAttribute(unique, attribute, op, amount, slots);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.writeRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES, (IForgeRegistryEntry)this.attribute);
        buffer.m_130068_((Enum)this.operation);
        buffer.writeFloat(this.amount);
        int packed = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (this.slotUUIDs[slot.m_20750_()] == null) continue;
            packed |= 1 << slot.m_20750_();
        }
        buffer.writeInt(packed);
    }

    public static ModifierAttribute fromNetwork(FriendlyByteBuf buffer) {
        String name = buffer.m_130136_(Short.MAX_VALUE);
        Attribute attribute = (Attribute)buffer.readRegistryIdUnsafe(ForgeRegistries.ATTRIBUTES);
        AttributeModifier.Operation operation = (AttributeModifier.Operation)buffer.m_130066_(AttributeModifier.Operation.class);
        float amount = buffer.readFloat();
        int packed = buffer.readInt();
        UUID[] slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if ((packed & 1 << slot.m_20750_()) <= 0) continue;
            slotUUIDs[slot.m_20750_()] = ModifierAttribute.getUUID(name, slot);
        }
        return new ModifierAttribute(name, attribute, operation, amount, slotUUIDs);
    }

    public static UUID getUUID(String name, EquipmentSlot slot) {
        return UUID.nameUUIDFromBytes((name + "." + slot.m_20751_()).getBytes());
    }

    private ModifierAttribute(String name, Attribute attribute, AttributeModifier.Operation operation, float amount, UUID[] slotUUIDs) {
        this.name = name;
        this.attribute = attribute;
        this.operation = operation;
        this.amount = amount;
        this.slotUUIDs = slotUUIDs;
    }
}

