/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.events.MaterialsLoadedEvent;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistryImpl;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.materials.definition.UpdateMaterialsPacket;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsManager;
import slimeknights.tconstruct.library.materials.stats.UpdateMaterialStatsPacket;
import slimeknights.tconstruct.library.materials.traits.MaterialTraitsManager;
import slimeknights.tconstruct.library.materials.traits.UpdateMaterialTraitsPacket;
import slimeknights.tconstruct.tools.stats.BowstringMaterialStats;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.RepairKitStats;
import slimeknights.tconstruct.tools.stats.SkullStats;

public final class MaterialRegistry {
    public static final MaterialStatsId MELEE_HARVEST = new MaterialStatsId(TConstruct.getResource("melee_harvest"));
    public static final MaterialStatsId RANGED = new MaterialStatsId(TConstruct.getResource("ranged"));
    static MaterialRegistry INSTANCE;
    private static final Map<MaterialStatsId, IMaterial> FIRST_MATERIALS;
    private final MaterialManager materialManager;
    private final MaterialStatsManager materialStatsManager;
    private final MaterialTraitsManager materialTraitsManager;
    private final IMaterialRegistry registry;
    private static boolean materialsLoaded;
    private static boolean statsLoaded;
    private static boolean traitsLoaded;
    @VisibleForTesting
    static boolean fullyLoaded;
    private static final Function<MaterialStatsId, IMaterial> FIRST_LOADER;

    public static IMaterialRegistry getInstance() {
        return MaterialRegistry.INSTANCE.registry;
    }

    public static void init() {
        INSTANCE = new MaterialRegistry();
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::onDatapackSync);
    }

    public static boolean isFullyLoaded() {
        return INSTANCE != null && fullyLoaded;
    }

    public MaterialRegistry() {
        this.materialManager = new MaterialManager(() -> {
            materialsLoaded = true;
            MaterialRegistry.checkAllLoaded();
        });
        this.materialStatsManager = new MaterialStatsManager(() -> {
            statsLoaded = true;
            MaterialRegistry.checkAllLoaded();
        });
        this.materialTraitsManager = new MaterialTraitsManager(() -> {
            traitsLoaded = true;
            MaterialRegistry.checkAllLoaded();
        });
        this.registry = new MaterialRegistryImpl(this.materialManager, this.materialStatsManager, this.materialTraitsManager);
        this.registry.registerStatType(HeadMaterialStats.DEFAULT, HeadMaterialStats.class, HeadMaterialStats::new, MELEE_HARVEST);
        this.registry.registerStatType(HandleMaterialStats.DEFAULT, HandleMaterialStats.class, HandleMaterialStats::new, MELEE_HARVEST);
        this.registry.registerStatType(ExtraMaterialStats.DEFAULT, ExtraMaterialStats.class, buffer -> ExtraMaterialStats.DEFAULT, MELEE_HARVEST);
        this.registry.registerStatType(LimbMaterialStats.DEFAULT, LimbMaterialStats.class, LimbMaterialStats::new, RANGED);
        this.registry.registerStatType(GripMaterialStats.DEFAULT, GripMaterialStats.class, GripMaterialStats::new, RANGED);
        this.registry.registerStatType(BowstringMaterialStats.DEFAULT, BowstringMaterialStats.class, buffer -> BowstringMaterialStats.DEFAULT, RANGED);
        this.registry.registerStatType(RepairKitStats.DEFAULT, RepairKitStats.class, RepairKitStats::new);
        this.registry.registerStatType(SkullStats.DEFAULT, SkullStats.class, SkullStats::new);
    }

    @VisibleForTesting
    MaterialRegistry(IMaterialRegistry registry) {
        this.registry = registry;
        this.materialManager = null;
        this.materialStatsManager = null;
        this.materialTraitsManager = null;
    }

    public static void updateMaterialsFromServer(UpdateMaterialsPacket packet) {
        MaterialRegistry.INSTANCE.materialManager.updateMaterialsFromServer(packet.getMaterials(), packet.getRedirects(), packet.getTags());
    }

    public static void updateMaterialStatsFromServer(UpdateMaterialStatsPacket packet) {
        MaterialRegistry.INSTANCE.materialStatsManager.updateMaterialStatsFromServer(packet.getMaterialToStats());
    }

    public static void updateMaterialTraitsFromServer(UpdateMaterialTraitsPacket packet) {
        MaterialRegistry.INSTANCE.materialTraitsManager.updateFromServer(packet.getMaterialToTraits());
    }

    public static IMaterial getMaterial(MaterialId id) {
        return MaterialRegistry.getInstance().getMaterial(id);
    }

    public static Collection<IMaterial> getMaterials() {
        return MaterialRegistry.INSTANCE.registry.getVisibleMaterials();
    }

    @Nullable
    public static Class<? extends IMaterialStats> getClassForStat(MaterialStatsId id) {
        return MaterialRegistry.INSTANCE.materialStatsManager.getClassForStat(id);
    }

    @Nullable
    public static Function<FriendlyByteBuf, ? extends IMaterialStats> getStatDecoder(MaterialStatsId id) {
        return MaterialRegistry.INSTANCE.materialStatsManager.getStatDecoder(id);
    }

    public static IMaterial firstWithStatType(MaterialStatsId id) {
        return FIRST_MATERIALS.computeIfAbsent(id, FIRST_LOADER);
    }

    private static void checkAllLoaded() {
        if (materialsLoaded && statsLoaded && traitsLoaded) {
            materialsLoaded = false;
            statsLoaded = false;
            traitsLoaded = false;
            fullyLoaded = true;
            FIRST_MATERIALS.clear();
            MinecraftForge.EVENT_BUS.post((Event)new MaterialsLoadedEvent());
        } else {
            fullyLoaded = false;
        }
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.materialManager);
        this.materialManager.setConditionContext(event.getConditionContext());
        event.addListener((PreparableReloadListener)this.materialStatsManager);
        event.addListener((PreparableReloadListener)this.materialTraitsManager);
    }

    private void sendPackets(ServerPlayer player, ISimplePacket[] packets) {
        if (player.f_8906_.m_6198_().m_129531_()) {
            fullyLoaded = true;
            MinecraftForge.EVENT_BUS.post((Event)new MaterialsLoadedEvent());
        } else {
            TinkerNetwork network = TinkerNetwork.getInstance();
            PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
            for (ISimplePacket packet : packets) {
                network.send(target, packet);
            }
        }
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        ISimplePacket[] packets = new ISimplePacket[]{this.materialManager.getUpdatePacket(), this.materialStatsManager.getUpdatePacket(), this.materialTraitsManager.getUpdatePacket()};
        ServerPlayer targetedPlayer = event.getPlayer();
        if (targetedPlayer != null) {
            this.sendPackets(targetedPlayer, packets);
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                this.sendPackets(player, packets);
            }
        }
    }

    static {
        FIRST_MATERIALS = new HashMap<MaterialStatsId, IMaterial>();
        materialsLoaded = false;
        statsLoaded = false;
        traitsLoaded = false;
        fullyLoaded = false;
        FIRST_LOADER = statsId -> {
            IMaterialRegistry instance = MaterialRegistry.getInstance();
            for (IMaterial material : instance.getVisibleMaterials()) {
                if (!instance.getMaterialStats(material.getIdentifier(), (MaterialStatsId)((Object)statsId)).isPresent()) continue;
                return material;
            }
            return IMaterial.UNKNOWN;
        };
    }
}

