/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.IRegistryDelegate;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.deferred.BlockDeferredRegister;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.registration.GeodeItemObject;

public class BlockDeferredRegisterExtension
extends BlockDeferredRegister {
    private static final BlockBehaviour.Properties POTTED_PROPS = BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_();

    public BlockDeferredRegisterExtension(String modID) {
        super(modID);
    }

    public GeodeItemObject registerGeode(String name, MaterialColor color, SoundType blockSound, SoundEvent chimeSound, Map<GeodeItemObject.BudSize, SoundType> clusterSounds, int baseLight, Item.Properties props) {
        RegistryObject shard = this.itemRegister.register(name, () -> new Item(props));
        return new GeodeItemObject((RegistryObject<? extends Item>)shard, this, color, blockSound, chimeSound, clusterSounds, baseLight, props);
    }

    public RegistryObject<FlowerPotBlock> registerPotted(String name, Supplier<? extends Block> block) {
        Supplier flowerPot = RegistrationHelper.castDelegate((IRegistryDelegate)Blocks.f_50276_.delegate);
        RegistryObject potted = this.registerNoItem("potted_" + name, () -> BlockDeferredRegisterExtension.lambda$registerPotted$1((Supplier)flowerPot, block));
        ((FlowerPotBlock)flowerPot.get()).addPlant(this.resource(name), (Supplier)potted);
        return potted;
    }

    public RegistryObject<FlowerPotBlock> registerPotted(RegistryObject<? extends Block> block) {
        return this.registerPotted(block.getId().m_135815_(), (Supplier<? extends Block>)block);
    }

    public RegistryObject<FlowerPotBlock> registerPotted(ItemObject<? extends Block> block) {
        return this.registerPotted(block.getRegistryName().m_135815_(), (Supplier<? extends Block>)block);
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, FlowerPotBlock> registerPottedEnum(T[] values, String name, EnumObject<T, B> block) {
        EnumObject.Builder builder = new EnumObject.Builder(((Enum)values[0]).getDeclaringClass());
        for (T value : values) {
            Supplier supplier = block.getSupplier(value);
            if (supplier == null) continue;
            builder.put(value, this.registerPotted(((StringRepresentable)value).m_7912_() + "_" + name, supplier));
        }
        return builder.build();
    }

    private static /* synthetic */ FlowerPotBlock lambda$registerPotted$1(Supplier flowerPot, Supplier block) {
        return new FlowerPotBlock(flowerPot, block, POTTED_PROPS);
    }
}

