/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

public class HarvestGoddess
extends PEToggleItem
implements IPedestalItem {
    public HarvestGoddess(Item.Properties props) {
        super(props);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean held) {
        if (level.f_46443_ || slot >= Inventory.m_36059_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        super.m_6883_(stack, level, entity, slot, held);
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("Active")) {
            long storedEmc = HarvestGoddess.getEmc(stack);
            if (storedEmc == 0L && !HarvestGoddess.consumeFuel(player, stack, 64L, true)) {
                nbt.m_128379_("Active", false);
            } else {
                WorldHelper.growNearbyRandomly(true, level, player.m_142538_(), player);
                HarvestGoddess.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.growNearbyRandomly(false, level, player.m_142538_(), player);
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        Direction side = ctx.m_43719_();
        if (level.f_46443_ || player == null || !player.m_36204_(pos, side, ctx.m_43722_())) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_()) {
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (stack.m_41619_() || stack.m_41613_() < 4 || stack.m_41720_() != Items.f_42499_) continue;
                if (this.useBoneMeal(level, pos, side)) {
                    player.m_150109_().m_7407_(i, 4);
                    player.f_36095_.m_38946_();
                    return InteractionResult.CONSUME;
                }
                break;
            }
        } else if (this.plantSeeds(level, player, pos)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private boolean useBoneMeal(Level level, BlockPos pos, Direction side) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean result = false;
            for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-15, 0, -15), (BlockPos)pos.m_142082_(15, 0, 15))) {
                BonemealableBlock growable;
                BlockState state = serverLevel.m_8055_(currentPos = currentPos.m_7949_());
                Block block = state.m_60734_();
                if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).m_7370_((BlockGetter)serverLevel, currentPos, state, false) && growable.m_5491_((Level)serverLevel, serverLevel.f_46441_, currentPos, state)) {
                    growable.m_7719_(serverLevel, serverLevel.f_46441_, currentPos, state);
                    level.m_46796_(1505, currentPos, 0);
                    result = true;
                    continue;
                }
                if (!WorldHelper.growWaterPlant(serverLevel, currentPos, state, side)) continue;
                level.m_46796_(1505, currentPos, 0);
                result = true;
            }
            return result;
        }
        return false;
    }

    private boolean plantSeeds(Level level, Player player, BlockPos pos) {
        List<StackWithSlot> seeds = this.getAllSeeds((NonNullList<ItemStack>)player.m_150109_().f_35974_);
        if (seeds.isEmpty()) {
            return false;
        }
        boolean result = false;
        block0: for (BlockPos currentPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-8, 0, -8), (BlockPos)pos.m_142082_(8, 0, 8))) {
            if (level.m_46859_(currentPos)) continue;
            BlockState state = level.m_8055_(currentPos);
            currentPos = currentPos.m_7949_();
            for (int i = 0; i < seeds.size(); ++i) {
                StackWithSlot s = seeds.get(i);
                if (!state.canSustainPlant((BlockGetter)level, currentPos, Direction.UP, s.plantable) || !level.m_46859_(currentPos.m_7494_())) continue;
                level.m_46597_(currentPos.m_7494_(), s.plantable.getPlant((BlockGetter)level, currentPos.m_7494_()));
                player.m_150109_().m_7407_(s.slot, 1);
                player.f_36095_.m_38946_();
                --s.count;
                if (s.count == 0) {
                    seeds.remove(i);
                    if (seeds.isEmpty()) {
                        return true;
                    }
                }
                if (result) continue block0;
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private List<StackWithSlot> getAllSeeds(NonNullList<ItemStack> inv) {
        ArrayList<StackWithSlot> result = new ArrayList<StackWithSlot>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof IPlantable) {
                result.add(new StackWithSlot(stack, i, (IPlantable)item));
                continue;
            }
            Block block = Block.m_49814_((Item)item);
            if (!(block instanceof IPlantable)) continue;
            result.add(new StackWithSlot(stack, i, (IPlantable)block));
        }
        return result;
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                WorldHelper.growNearbyRandomly(true, level, pos, null);
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.harvest.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.harvest.get() != -1) {
            list.add((Component)PELang.PEDESTAL_HARVEST_GODDESS_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_HARVEST_GODDESS_2.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_HARVEST_GODDESS_3.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.harvest.get())));
        }
        return list;
    }

    private static class StackWithSlot {
        public final IPlantable plantable;
        public final int slot;
        public int count;

        public StackWithSlot(ItemStack stack, int slot, IPlantable plantable) {
            this.slot = slot;
            this.count = stack.m_41613_();
            this.plantable = plantable;
        }
    }
}

