/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.capability.ExtraFunctionItemCapabilityWrapper;
import moze_intel.projecte.capability.IItemCapabilitySerializable;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.gameObjs.container.MercurialEyeContainer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MercurialEye
extends ItemMode
implements IExtraFunction {
    private static final int CREATION_MODE = 0;
    private static final int EXTENSION_MODE = 1;
    private static final int EXTENSION_MODE_CLASSIC = 2;
    private static final int TRANSMUTATION_MODE = 3;
    private static final int TRANSMUTATION_MODE_CLASSIC = 4;
    private static final int PILLAR_MODE = 5;

    public MercurialEye(Item.Properties props) {
        super(props, 4, PELang.MODE_MERCURIAL_EYE_1, PELang.MODE_MERCURIAL_EYE_2, PELang.MODE_MERCURIAL_EYE_3, PELang.MODE_MERCURIAL_EYE_4, PELang.MODE_MERCURIAL_EYE_5, PELang.MODE_MERCURIAL_EYE_6);
        this.addItemCapability(ExtraFunctionItemCapabilityWrapper::new);
        this.addItemCapability(EyeInventoryHandler::new);
    }

    @Override
    public boolean doExtraFunction(@NotNull ItemStack stack, @NotNull Player player, InteractionHand hand) {
        int selected = player.m_150109_().f_35977_;
        SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, pl) -> new MercurialEyeContainer(id, inv, hand, selected), stack.m_41786_());
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, b -> {
            b.m_130068_((Enum)hand);
            b.writeByte(selected);
        });
        return true;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        return ctx.m_43725_().f_46443_ ? InteractionResult.SUCCESS : this.formBlocks(stack, ctx.m_43723_(), ctx.m_43724_(), ctx.m_8083_(), ctx.m_43719_());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getMode(stack) == 0) {
            if (level.f_46443_) {
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            Vec3 eyeVec = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
            Vec3 lookVec = player.m_20154_();
            Vec3 targVec = eyeVec.m_82520_(lookVec.f_82479_ * 2.0, lookVec.f_82480_ * 2.0, lookVec.f_82481_ * 2.0);
            return ItemHelper.actionResultFromType(this.formBlocks(stack, player, hand, new BlockPos(targVec), null), stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void playNoEMCSound(Player player) {
        player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.UNCHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private InteractionResult formBlocks(ItemStack eye, Player player, InteractionHand hand, BlockPos startingPos, @Nullable Direction facing) {
        long newBlockEmc;
        BlockState newState;
        Optional inventoryCapability = eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (inventoryCapability.isEmpty()) {
            return InteractionResult.FAIL;
        }
        IItemHandler inventory = (IItemHandler)inventoryCapability.get();
        ItemStack klein = inventory.getStackInSlot(0);
        if (klein.m_41619_() || !klein.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).isPresent()) {
            this.playNoEMCSound(player);
            return InteractionResult.FAIL;
        }
        Level level = player.m_20193_();
        BlockState startingState = level.m_8055_(startingPos);
        long startingBlockEmc = EMCHelper.getEmcValue(new ItemStack((ItemLike)startingState.m_60734_()));
        ItemStack target = inventory.getStackInSlot(1);
        byte mode = this.getMode(eye);
        if (!target.m_41619_()) {
            BlockHitResult hitResult = facing == null ? new BlockHitResult(Vec3.m_82512_((Vec3i)startingPos), Direction.UP, startingPos, true) : new BlockHitResult(new Vec3((double)startingPos.m_123341_() + 0.5 + (double)facing.m_122429_(), (double)startingPos.m_123342_() + 0.5 + (double)facing.m_122430_(), (double)startingPos.m_123343_() + 0.5 + (double)facing.m_122431_()), facing, startingPos, false);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(level, player, hand, target.m_41777_(), hitResult));
            newState = ItemHelper.stackToState(target, context);
            newBlockEmc = EMCHelper.getEmcValue(target);
            if (newBlockEmc == 0L) {
                return InteractionResult.FAIL;
            }
        } else if (startingBlockEmc != 0L && (mode == 1 || mode == 2)) {
            newState = startingState;
            newBlockEmc = startingBlockEmc;
        } else {
            return InteractionResult.FAIL;
        }
        if (newState == null || newState.m_60795_()) {
            return InteractionResult.FAIL;
        }
        NonNullList drops = NonNullList.m_122779_();
        int charge = this.getCharge(eye);
        int hitTargets = 0;
        if (mode == 0) {
            if (facing != null && (!startingState.m_60767_().m_76336_() || player.m_6144_() && !startingState.m_60795_())) {
                BlockPos offsetPos = startingPos.m_142300_(facing);
                BlockState offsetState = level.m_8055_(offsetPos);
                if (!offsetState.m_60767_().m_76336_()) {
                    return InteractionResult.FAIL;
                }
                long offsetBlockEmc = EMCHelper.getEmcValue(new ItemStack((ItemLike)offsetState.m_60734_()));
                if (this.doBlockPlace(player, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) {
                    ++hitTargets;
                }
            } else if (this.doBlockPlace(player, startingState, startingPos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) {
                ++hitTargets;
            }
        } else if (mode == 5) {
            hitTargets += this.fillGaps(eye, player, level, startingState, newState, newBlockEmc, this.getCorners(startingPos, facing, 1, 3 * charge + 2), (NonNullList<ItemStack>)drops);
        } else if (mode == 2) {
            hitTargets += this.fillGaps(eye, player, level, startingState, newState, newBlockEmc, this.getCorners(startingPos, facing, charge, 0), (NonNullList<ItemStack>)drops);
        } else if (mode == 4) {
            Pair<BlockPos, BlockPos> corners = this.getCorners(startingPos, facing, charge, 0);
            for (BlockPos pos : WorldHelper.getPositionsFromBox(new AABB((BlockPos)corners.getLeft(), (BlockPos)corners.getRight()))) {
                BlockState placedState = level.m_8055_(pos);
                if (placedState != startingState || !this.doBlockPlace(player, placedState, pos.m_7949_(), newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) continue;
                ++hitTargets;
            }
        } else {
            if (startingState.m_60795_() || facing == null) {
                return InteractionResult.FAIL;
            }
            LinkedList<BlockPos> possibleBlocks = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            possibleBlocks.add(startingPos);
            visited.add(startingPos);
            int side = 2 * charge + 1;
            int size = side * side;
            int totalTries = size * 4;
            for (int attemptedTargets = 0; attemptedTargets < totalTries && !possibleBlocks.isEmpty(); ++attemptedTargets) {
                BlockPos offsetPos;
                BlockState offsetState;
                BlockPos pos = (BlockPos)possibleBlocks.poll();
                BlockState checkState = level.m_8055_(pos);
                if (startingState != checkState || (offsetState = level.m_8055_(offsetPos = pos.m_142300_(facing))).m_60783_((BlockGetter)level, offsetPos, facing)) continue;
                boolean hit = false;
                if (mode == 1) {
                    VoxelShape cbBox = startingState.m_60812_((BlockGetter)level, offsetPos);
                    if (level.m_5450_(null, cbBox)) {
                        long offsetBlockEmc = EMCHelper.getEmcValue((ItemLike)offsetState.m_60734_());
                        hit = this.doBlockPlace(player, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops);
                    }
                } else if (mode == 3) {
                    hit = this.doBlockPlace(player, checkState, pos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops);
                }
                if (!hit) continue;
                if (++hitTargets < size) {
                    for (Direction e : Direction.values()) {
                        BlockPos offsetOpposite;
                        if (facing.m_122434_() == e.m_122434_()) continue;
                        BlockPos offset = pos.m_142300_(e);
                        if (visited.add(offset)) {
                            possibleBlocks.offer(offset);
                        }
                        if (!visited.add(offsetOpposite = pos.m_142300_(e.m_122424_()))) continue;
                        possibleBlocks.offer(offsetOpposite);
                    }
                    continue;
                }
                break;
            }
        }
        if (hitTargets > 0) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 0.8f, 2.0f / ((float)charge / (float)this.getNumCharges(eye) + 2.0f));
            if (!drops.isEmpty()) {
                WorldHelper.createLootDrop((List<ItemStack>)drops, player.m_20193_(), startingPos);
            }
        }
        return InteractionResult.CONSUME;
    }

    private boolean doBlockPlace(Player player, BlockState oldState, BlockPos placePos, BlockState newState, ItemStack eye, long oldEMC, long newEMC, NonNullList<ItemStack> drops) {
        Optional inventoryCapability = eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (inventoryCapability.isEmpty()) {
            return false;
        }
        IItemHandler inventory = (IItemHandler)inventoryCapability.get();
        ItemStack klein = inventory.getStackInSlot(0);
        if (klein.m_41619_()) {
            this.playNoEMCSound(player);
            return false;
        }
        Optional holderCapability = klein.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (holderCapability.isEmpty()) {
            this.playNoEMCSound(player);
            return false;
        }
        if (oldState == newState) {
            return false;
        }
        if (ItemPE.getEmc(klein) < newEMC - oldEMC) {
            this.playNoEMCSound(player);
            return false;
        }
        if (WorldHelper.getBlockEntity((BlockGetter)player.m_20193_(), placePos) != null) {
            return false;
        }
        if (oldEMC == 0L && oldState.m_60800_((BlockGetter)player.f_19853_, placePos) == -1.0f) {
            return false;
        }
        if (PlayerHelper.checkedReplaceBlock((ServerPlayer)player, placePos, newState)) {
            IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
            if (oldEMC == 0L) {
                drops.addAll((Collection)Block.m_49874_((BlockState)oldState, (ServerLevel)((ServerPlayer)player).m_183503_(), (BlockPos)placePos, null, (Entity)player, (ItemStack)eye));
                emcHolder.extractEmc(klein, newEMC, IEmcStorage.EmcAction.EXECUTE);
            } else if (oldEMC > newEMC) {
                emcHolder.insertEmc(klein, oldEMC - newEMC, IEmcStorage.EmcAction.EXECUTE);
            } else if (oldEMC < newEMC) {
                emcHolder.extractEmc(klein, newEMC - oldEMC, IEmcStorage.EmcAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    private int fillGaps(ItemStack eye, Player player, Level level, BlockState startingState, BlockState newState, long newBlockEmc, Pair<BlockPos, BlockPos> corners, NonNullList<ItemStack> drops) {
        int hitTargets = 0;
        for (BlockPos pos : WorldHelper.getPositionsFromBox(new AABB((BlockPos)corners.getLeft(), (BlockPos)corners.getRight()))) {
            BlockState placeState;
            VoxelShape bb = startingState.m_60812_((BlockGetter)level, pos);
            if (!level.m_5450_(null, bb) || !(placeState = level.m_8055_(pos)).m_60767_().m_76336_()) continue;
            long placeBlockEmc = EMCHelper.getEmcValue((ItemLike)placeState.m_60734_());
            if (!this.doBlockPlace(player, placeState, pos.m_7949_(), newState, eye, placeBlockEmc, newBlockEmc, drops)) continue;
            ++hitTargets;
        }
        return hitTargets;
    }

    private Pair<BlockPos, BlockPos> getCorners(BlockPos startingPos, Direction facing, int strength, int depth) {
        if (facing == null) {
            return new ImmutablePair((Object)startingPos, (Object)startingPos);
        }
        BlockPos start = startingPos;
        BlockPos end = startingPos;
        switch (facing) {
            case UP: {
                start = start.m_142082_(-strength, -depth, -strength);
                end = end.m_142082_(strength, 0, strength);
                break;
            }
            case DOWN: {
                start = start.m_142082_(-strength, 0, -strength);
                end = end.m_142082_(strength, depth, strength);
                break;
            }
            case SOUTH: {
                start = start.m_142082_(-strength, -strength, -depth);
                end = end.m_142082_(strength, strength, 0);
                break;
            }
            case NORTH: {
                start = start.m_142082_(-strength, -strength, 0);
                end = end.m_142082_(strength, strength, depth);
                break;
            }
            case EAST: {
                start = start.m_142082_(-depth, -strength, -strength);
                end = end.m_142082_(0, strength, strength);
                break;
            }
            case WEST: {
                start = start.m_142082_(0, -strength, -strength);
                end = end.m_142082_(depth, strength, strength);
            }
        }
        return new ImmutablePair((Object)start, (Object)end);
    }

    private static class EyeInventoryHandler
    extends ItemCapability<IItemHandler>
    implements IItemCapabilitySerializable {
        private final ItemStackHandler inv = new ItemStackHandler(2);
        private final LazyOptional<IItemHandler> invInst = LazyOptional.of(() -> this.inv);

        private EyeInventoryHandler() {
        }

        public Tag serializeNBT() {
            return this.inv.serializeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            if (nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                this.inv.deserializeNBT(tag);
            }
        }

        @Override
        public Capability<IItemHandler> getCapability() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        @Override
        public LazyOptional<IItemHandler> getLazyCapability() {
            return this.invInst;
        }

        @Override
        public String getStorageKey() {
            return "EyeInventory";
        }
    }
}

