/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.container.PEHandContainer;
import moze_intel.projecte.gameObjs.container.inventory.TransmutationInventory;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotConsume;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotInput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotLock;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotOutput;
import moze_intel.projecte.gameObjs.container.slots.transmutation.SlotUnlearn;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.SearchUpdatePKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class TransmutationContainer
extends PEHandContainer {
    private final List<SlotInput> inputSlots = new ArrayList<SlotInput>();
    public final TransmutationInventory transmutationInventory;
    private SlotUnlearn unlearn;

    public static TransmutationContainer fromNetwork(int windowId, Inventory playerInv, FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return new TransmutationContainer(windowId, playerInv, (InteractionHand)buf.m_130066_(InteractionHand.class), buf.readByte());
        }
        return new TransmutationContainer(windowId, playerInv);
    }

    public TransmutationContainer(int windowId, Inventory playerInv) {
        super(PEContainerTypes.TRANSMUTATION_CONTAINER, windowId, playerInv, null, 0);
        this.transmutationInventory = new TransmutationInventory(this.playerInv.f_35978_);
        this.initSlots();
    }

    public TransmutationContainer(int windowId, Inventory playerInv, InteractionHand hand, int selected) {
        super(PEContainerTypes.TRANSMUTATION_CONTAINER, windowId, playerInv, hand, selected);
        this.transmutationInventory = new TransmutationInventory(this.playerInv.f_35978_);
        this.initSlots();
    }

    private void initSlots() {
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 0, 43, 23));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 1, 34, 41));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 2, 52, 41));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 3, 16, 50));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 4, 70, 50));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 5, 34, 59));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 6, 52, 59));
        this.m_38897_((Slot)new SlotInput(this.transmutationInventory, 7, 43, 77));
        this.m_38897_((Slot)new SlotLock(this.transmutationInventory, 8, 158, 50));
        this.m_38897_((Slot)new SlotConsume(this.transmutationInventory, 9, 107, 97));
        this.unlearn = new SlotUnlearn(this.transmutationInventory, 10, 89, 97);
        this.m_38897_((Slot)this.unlearn);
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 11, 158, 9));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 12, 176, 13));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 13, 193, 30));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 14, 199, 50));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 15, 193, 70));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 16, 176, 87));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 17, 158, 91));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 18, 140, 87));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 19, 123, 70));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 20, 116, 50));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 21, 123, 30));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 22, 140, 13));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 23, 158, 31));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 24, 177, 50));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 25, 158, 69));
        this.m_38897_((Slot)new SlotOutput(this.transmutationInventory, 26, 139, 50));
        this.addPlayerInventory(35, 117);
    }

    @Override
    @NotNull
    protected Slot m_38897_(@NotNull Slot slot) {
        if (slot instanceof SlotInput) {
            SlotInput input = (SlotInput)slot;
            this.inputSlots.add(input);
        }
        return super.m_38897_(slot);
    }

    public void m_6877_(@NotNull Player player) {
        ServerPlayer serverPlayer;
        super.m_6877_(player);
        if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
            player.m_36176_(this.unlearn.m_7993_(), false);
        } else {
            player.m_150109_().m_150079_(this.unlearn.m_7993_());
        }
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        if (slotIndex < 9 || slotIndex == 10) {
            return super.m_7648_(player, slotIndex);
        }
        Slot currentSlot = this.tryGetSlot(slotIndex);
        if (currentSlot == null || !currentSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        if (slotIndex >= 11 && slotIndex <= 26) {
            ItemStack stack = currentSlot.m_7993_().m_41777_();
            long itemEmc = EMCHelper.getEmcValue(stack);
            if (itemEmc > 0L) {
                stack.m_41764_(stack.m_41741_());
                int stackSize = stack.m_41613_() - ItemHelper.simulateFit((NonNullList<ItemStack>)player.m_150109_().f_35974_, stack);
                if (stackSize > 0) {
                    BigInteger availableEMC = this.transmutationInventory.getAvailableEmc();
                    BigInteger emc = BigInteger.valueOf(itemEmc);
                    BigInteger totalEmc = emc.multiply(BigInteger.valueOf(stackSize));
                    if (totalEmc.compareTo(availableEMC) > 0) {
                        BigInteger numOperations = availableEMC.divide(emc);
                        stackSize = numOperations.intValueExact();
                        totalEmc = emc.multiply(numOperations);
                        if (stackSize <= 0) {
                            return ItemStack.f_41583_;
                        }
                    }
                    stack.m_41764_(stackSize);
                    IItemHandler inv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(NullPointerException::new);
                    if (this.transmutationInventory.isServer()) {
                        this.transmutationInventory.removeEmc(totalEmc);
                    }
                    ItemHandlerHelper.insertItemStacked((IItemHandler)inv, (ItemStack)stack, (boolean)false);
                }
            }
        } else if (slotIndex > 26) {
            long emc;
            ItemStack slotStack = currentSlot.m_7993_();
            ItemStack stackToInsert = slotStack;
            if (stackToInsert.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).isPresent()) {
                stackToInsert = TransmutationContainer.insertItem(this.inputSlots, stackToInsert, true);
                if (slotStack.m_41613_() == stackToInsert.m_41613_()) {
                    stackToInsert = TransmutationContainer.insertItem(this.inputSlots, stackToInsert, false);
                }
                if (slotStack.m_41613_() != stackToInsert.m_41613_()) {
                    return this.transferSuccess(currentSlot, player, slotStack, stackToInsert);
                }
            }
            if ((emc = EMCHelper.getEmcSellValue(stackToInsert)) > 0L || stackToInsert.m_41720_() instanceof Tome) {
                if (this.transmutationInventory.isServer()) {
                    BigInteger emcBigInt = BigInteger.valueOf(emc);
                    this.transmutationInventory.handleKnowledge(stackToInsert);
                    this.transmutationInventory.addEmc(emcBigInt.multiply(BigInteger.valueOf(stackToInsert.m_41613_())));
                }
                currentSlot.m_5852_(ItemStack.f_41583_);
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void clickPostValidate(int slotIndex, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        Slot slot;
        if (player.m_20193_().f_46443_ && this.transmutationInventory.getHandlerForSlot(slotIndex) == this.transmutationInventory.outputs && (slot = this.tryGetSlot(slotIndex)) != null) {
            PacketHandler.sendToServer(new SearchUpdatePKT(this.transmutationInventory.getIndexFromSlot(slotIndex), slot.m_7993_()));
        }
        super.clickPostValidate(slotIndex, dragType, clickType, player);
    }

    public boolean m_5622_(@NotNull Slot slot) {
        return !(slot instanceof SlotConsume) && !(slot instanceof SlotUnlearn) && !(slot instanceof SlotInput) && !(slot instanceof SlotLock) && !(slot instanceof SlotOutput);
    }
}

