/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import moze_intel.projecte.gameObjs.EnumRelayTier;
import moze_intel.projecte.gameObjs.block_entities.RelayMK1BlockEntity;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relay
extends BlockDirection
implements PEEntityBlock<RelayMK1BlockEntity> {
    private final EnumRelayTier tier;

    public Relay(EnumRelayTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
    }

    public EnumRelayTier getTier() {
        return this.tier;
    }

    @Deprecated
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult rtr) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        RelayMK1BlockEntity relay = WorldHelper.getBlockEntity(RelayMK1BlockEntity.class, (BlockGetter)level, pos, true);
        if (relay != null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)relay, (BlockPos)pos);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<? extends RelayMK1BlockEntity> getType() {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case EnumRelayTier.MK1 -> PEBlockEntityTypes.RELAY;
            case EnumRelayTier.MK2 -> PEBlockEntityTypes.RELAY_MK2;
            case EnumRelayTier.MK3 -> PEBlockEntityTypes.RELAY_MK3;
        };
    }

    @Deprecated
    public boolean m_8133_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int id, int param) {
        super.m_8133_(state, level, pos, id, param);
        return this.triggerBlockEntityEvent(state, level, pos, id, param);
    }

    @Deprecated
    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        RelayMK1BlockEntity relay = WorldHelper.getBlockEntity(RelayMK1BlockEntity.class, (BlockGetter)level, pos, true);
        if (relay == null) {
            return 0;
        }
        return MathUtils.scaleToRedstone(relay.getStoredEmc(), relay.getMaximumEmc());
    }
}

