/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.events;

import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.events.TickEvents;
import moze_intel.projecte.gameObjs.items.AlchemicalBag;
import moze_intel.projecte.gameObjs.items.armor.PEArmor;
import moze_intel.projecte.handlers.CommonInternalAbilities;
import moze_intel.projecte.handlers.InternalAbilities;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.impl.TransmutationOffline;
import moze_intel.projecte.impl.capability.AlchBagImpl;
import moze_intel.projecte.impl.capability.KnowledgeImpl;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="projecte")
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        original.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).ifPresent(old -> {
            CompoundTag bags = (CompoundTag)old.serializeNBT();
            event.getPlayer().getCapability(PECapabilities.ALCH_BAG_CAPABILITY).ifPresent(c -> c.deserializeNBT((Tag)bags));
        });
        original.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(old -> {
            CompoundTag knowledge = (CompoundTag)old.serializeNBT();
            event.getPlayer().getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(c -> c.deserializeNBT((Tag)knowledge));
        });
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(c -> c.sync(player2));
            player2.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).ifPresent(c -> c.sync(null, player2));
        }
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(c -> c.sync(player2));
            player2.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).ifPresent(c -> c.sync(null, player2));
        }
        event.getPlayer().getCapability(InternalAbilities.CAPABILITY).ifPresent(InternalAbilities::onDimensionChange);
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
        Object object = evt.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            PlayerEvents.attachCapability(evt, AlchBagImpl.Provider.NAME, new AlchBagImpl.Provider());
            PlayerEvents.attachCapability(evt, KnowledgeImpl.Provider.NAME, new KnowledgeImpl.Provider(player));
            PlayerEvents.attachCapability(evt, CommonInternalAbilities.NAME, new CommonInternalAbilities.Provider(player));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerEvents.attachCapability(evt, InternalTimers.NAME, new InternalTimers.Provider());
                PlayerEvents.attachCapability(evt, InternalAbilities.NAME, new InternalAbilities.Provider(serverPlayer));
            }
        }
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> evt, ResourceLocation name, BasicCapabilityResolver<?> cap) {
        evt.addCapability(name, cap);
        evt.addListener(cap::invalidateAll);
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        PacketHandler.sendFragmentedEmcPacket(player);
        player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(knowledge -> {
            knowledge.sync(player);
            PlayerHelper.updateScore(player, PlayerHelper.SCOREBOARD_EMC, knowledge.getEmc());
        });
        player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).ifPresent(c -> c.sync(null, player));
        PECore.debugLog("Sent knowledge and bag data to {}", player.m_7755_());
    }

    @SubscribeEvent
    public static void onConstruct(EntityEvent.EntityConstructing evt) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && evt.getEntity() instanceof Player && !(evt.getEntity() instanceof FakePlayer)) {
            TransmutationOffline.clear(evt.getEntity().m_142081_());
            PECore.debugLog("Clearing offline data cache in preparation to load online data", new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onHighAlchemistJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (PECore.uuids.contains(evt.getPlayer().m_142081_().toString())) {
            MutableComponent joinMessage = PELang.HIGH_ALCHEMIST.translateColored(ChatFormatting.BLUE, ChatFormatting.GOLD, evt.getPlayer().m_5446_());
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_11264_((Component)joinMessage, ChatType.SYSTEM, Util.f_137441_);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void pickupItem(EntityItemPickupEvent event) {
        Player player = event.getPlayer();
        Level level = player.m_20193_();
        if (level.f_46443_) {
            return;
        }
        ItemStack bag = AlchemicalBag.getFirstBagWithSuctionItem(player, (NonNullList<ItemStack>)player.m_150109_().f_35974_);
        if (bag.m_41619_()) {
            return;
        }
        Optional cap = player.getCapability(PECapabilities.ALCH_BAG_CAPABILITY).resolve();
        if (cap.isEmpty()) {
            return;
        }
        IItemHandler handler = ((IAlchBagProvider)cap.get()).getBag(((AlchemicalBag)bag.m_41720_()).color);
        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)event.getItem().m_32055_(), (boolean)false);
        if (remainder.m_41619_()) {
            event.getItem().m_146870_();
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundTakeItemEntityPacket(event.getItem().m_142049_(), player.m_142049_(), 1));
        } else {
            event.getItem().m_32045_(remainder);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onAttacked(LivingAttackEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (evt.getSource().m_19384_() && TickEvents.shouldPlayerResistFire(player)) {
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent evt) {
        float damage = evt.getAmount();
        if (damage > 0.0f) {
            float damageAfter;
            DamageSource source;
            LivingEntity entityLiving = evt.getEntityLiving();
            float totalPercentReduced = PlayerEvents.getReductionForSlot(entityLiving, source = evt.getSource(), EquipmentSlot.HEAD, damage) + PlayerEvents.getReductionForSlot(entityLiving, source, EquipmentSlot.CHEST, damage) + PlayerEvents.getReductionForSlot(entityLiving, source, EquipmentSlot.LEGS, damage) + PlayerEvents.getReductionForSlot(entityLiving, source, EquipmentSlot.FEET, damage);
            float f = damageAfter = totalPercentReduced >= 1.0f ? 0.0f : damage - damage * totalPercentReduced;
            if (damageAfter <= 0.0f) {
                evt.setCanceled(true);
            } else if (damage != damageAfter) {
                evt.setAmount(damageAfter);
            }
        }
    }

    private static float getReductionForSlot(LivingEntity entityLiving, DamageSource source, EquipmentSlot slot, float damage) {
        ItemStack armorStack = entityLiving.m_6844_(slot);
        Item item = armorStack.m_41720_();
        if (item instanceof PEArmor) {
            PEArmor armorItem = (PEArmor)item;
            EquipmentSlot type = armorItem.m_40402_();
            if (type != slot) {
                return 0.0f;
            }
            return Math.max(armorItem.getFullSetBaseReduction(), armorItem.getMaxDamageAbsorb(type, source) / damage) * armorItem.getPieceEffectiveness(type);
        }
        return 0.0f;
    }
}

