/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.lib.api.item.IXpContainerItem;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class XpHelper {
    private XpHelper() {
    }

    public static int getPlayerXP(Player player) {
        return XpHelper.getTotalXpForLevel(player.f_36078_) + XpHelper.getExtraPlayerXp(player);
    }

    public static int getLevelPlayerXP(Player player) {
        return XpHelper.getTotalXpForLevel(player.f_36078_);
    }

    public static int getExtraPlayerXp(Player player) {
        return Math.round(player.f_36080_ * (float)player.m_36323_());
    }

    public static void setPlayerXP(Player player, int exp) {
        player.f_36078_ = 0;
        player.f_36080_ = 0.0f;
        player.f_36079_ = 0;
        XpHelper.addXPToPlayer(player, exp);
    }

    public static void setPlayerLevel(Player player, int level) {
        player.f_36078_ = level;
        player.f_36080_ = 0.0f;
    }

    public static void addXPToPlayer(Player player, int exp) {
        int i = Integer.MAX_VALUE - player.f_36079_;
        if (exp > i) {
            exp = i;
        }
        player.f_36080_ += (float)exp / (float)player.m_36323_();
        player.f_36079_ += exp;
        while (player.f_36080_ >= 1.0f) {
            player.f_36080_ = (player.f_36080_ - 1.0f) * (float)player.m_36323_();
            XpHelper.addXPLevelToPlayer(player, 1);
            player.f_36080_ /= (float)player.m_36323_();
        }
    }

    public static void addXPLevelToPlayer(Player player, int levels) {
        player.f_36078_ += levels;
        if (player.f_36078_ < 0) {
            player.f_36078_ = 0;
            player.f_36080_ = 0.0f;
            player.f_36079_ = 0;
        }
    }

    public static void attemptStoreXP(Player player, ExperienceOrb orb) {
        if (player.f_19853_.m_46467_() - player.getPersistentData().m_128454_("XpTimer") <= 40L) {
            ItemStack stack;
            Inventory inventory = player.m_150109_();
            for (int i = 0; !(i >= inventory.m_6643_() || (stack = inventory.m_8020_(i)).m_41720_() instanceof IXpContainerItem && IXpContainerItem.storeXpOrb(player, orb, stack)); ++i) {
            }
        }
    }

    public static int getTotalXpForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }
}

