/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.ItemHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.tags.FluidTagsCoFH;
import cofh.lib.util.helpers.BlockHelper;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidHelper {
    public static final Predicate<FluidStack> IS_WATER = e -> e.getFluid().equals(Fluids.f_76193_);
    public static final Predicate<FluidStack> IS_LAVA = e -> e.getFluid().equals(Fluids.f_76195_);
    public static final Predicate<FluidStack> IS_XP = e -> e.getFluid().m_205067_(FluidTagsCoFH.EXPERIENCE);
    public static final Map<Item, Function<ItemStack, FluidStack>> BOTTLE_DRAIN_MAP = new Object2ObjectOpenHashMap();
    public static final Map<Predicate<FluidStack>, Function<FluidStack, ItemStack>> BOTTLE_FILL_MAP = new Object2ObjectOpenHashMap();
    public static final MutableComponent EMPTY_POTION = new TranslatableComponent("effect.none").m_130940_(ChatFormatting.GRAY);

    private FluidHelper() {
    }

    public static int fluidHashcodeNoTag(FluidStack stack) {
        return stack.getFluid().hashCode();
    }

    public static int fluidHashcode(FluidStack stack) {
        return stack.getTag() != null ? stack.getFluid().hashCode() + 31 * stack.getTag().hashCode() : stack.getFluid().hashCode();
    }

    public static boolean fluidsEqualWithTags(FluidStack resourceA, FluidStack resourceB) {
        return FluidHelper.fluidsEqual(resourceA, resourceB) && FluidStack.areFluidStackTagsEqual((FluidStack)resourceA, (FluidStack)resourceB);
    }

    public static boolean fluidsEqual(FluidStack resourceA, FluidStack resourceB) {
        return resourceA != null && resourceA.isFluidEqual(resourceB) || resourceA == null && resourceB == null;
    }

    public static boolean fluidsEqual(Fluid fluidA, FluidStack resourceB) {
        return fluidA != null && resourceB != null && fluidA == resourceB.getFluid();
    }

    public static boolean fluidsEqual(FluidStack resourceA, Fluid fluidB) {
        return fluidB != null && resourceA != null && fluidB == resourceA.getFluid();
    }

    public static boolean fluidsEqual(Fluid fluidA, Fluid fluidB) {
        return fluidA != null && fluidA.equals(fluidB);
    }

    public static boolean isWater(BlockState state) {
        return state.m_60734_() == Blocks.f_49990_;
    }

    public static boolean extractFromAdjacent(BlockEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        amount = Math.min(amount, tank.getSpace());
        if (!tank.getFluidStack().isEmpty()) {
            return FluidHelper.extractFromAdjacent(tile, tank, new FluidStack(tank.getFluidStack(), amount), side);
        }
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.m_122424_());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        FluidStack drainStack = handler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        int drainAmount = tank.fill(drainStack, IFluidHandler.FluidAction.EXECUTE);
        if (drainAmount > 0) {
            handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean extractFromAdjacent(BlockEntity tile, FluidStorageCoFH tank, FluidStack resource, Direction side) {
        Direction opposite;
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.m_122424_());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        FluidStack drainStack = handler.drain(resource, IFluidHandler.FluidAction.SIMULATE);
        int drainAmount = tank.fill(drainStack, IFluidHandler.FluidAction.EXECUTE);
        if (drainAmount > 0) {
            handler.drain(new FluidStack(resource, drainAmount), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean insertIntoAdjacent(BlockEntity tile, FluidStorageCoFH tank, int amount, Direction side) {
        Direction opposite;
        if (tank.isEmpty()) {
            return false;
        }
        amount = Math.min(amount, tank.getAmount());
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        IFluidHandler handler = FluidHelper.getFluidHandlerCap(adjTile, opposite = side.m_122424_());
        if (handler == EmptyFluidHandler.INSTANCE) {
            return false;
        }
        int fillAmount = handler.fill(new FluidStack(tank.getFluidStack(), amount), IFluidHandler.FluidAction.EXECUTE);
        if (fillAmount > 0) {
            tank.drain(fillAmount, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static boolean hasFluidHandlerCap(BlockEntity tile, Direction face) {
        return tile != null && tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).isPresent();
    }

    public static IFluidHandler getFluidHandlerCap(BlockEntity tile, Direction face) {
        return tile == null ? EmptyFluidHandler.INSTANCE : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face).orElse((Object)EmptyFluidHandler.INSTANCE);
    }

    public static boolean hasFluidHandlerCap(ItemStack item) {
        return !item.m_41619_() && item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    public static LazyOptional<IFluidHandlerItem> getFluidHandlerCap(@Nonnull ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
    }

    public static Optional<FluidStack> getFluidContainedInItem(@Nonnull ItemStack container) {
        Optional fluidContained;
        if (!container.m_41619_() && (fluidContained = FluidHelper.getFluidHandlerCap(container).map(c -> c.getFluidInTank(0))).isPresent() && !((FluidStack)fluidContained.get()).isEmpty()) {
            return fluidContained;
        }
        return Optional.empty();
    }

    public static int getCapacityForItem(@Nonnull ItemStack container) {
        if (!container.m_41619_()) {
            return FluidHelper.getFluidHandlerCap(container).map(c -> c.getTankCapacity(0)).orElse(0);
        }
        return 0;
    }

    public static boolean drainBottleToHandler(ItemStack stack, IFluidHandler handler, Player player, InteractionHand hand) {
        FluidStack fluid = BOTTLE_DRAIN_MAP.containsKey(stack.m_41720_()) ? BOTTLE_DRAIN_MAP.get(stack.m_41720_()).apply(stack) : FluidStack.EMPTY;
        return !fluid.isEmpty() && FluidHelper.addEmptyBottleToPlayer(stack, fluid, handler, player, hand);
    }

    private static boolean addEmptyBottleToPlayer(ItemStack stack, FluidStack fluid, IFluidHandler handler, Player player, InteractionHand hand) {
        if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 250) {
            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_150110_().f_35937_) {
                ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
                player.m_21008_(hand, ItemHelper.consumeItem(stack, 1));
                if (!player.m_36356_(bottle)) {
                    player.m_36176_(bottle, false);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillBottleFromHandler(ItemStack stack, IFluidHandler handler, Player player, InteractionHand hand) {
        if (stack.m_41720_() != Items.f_42590_) {
            return false;
        }
        FluidStack fluid = handler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (fluid.getAmount() != 250) {
            return false;
        }
        ItemStack bottle = ItemStack.f_41583_;
        for (Map.Entry<Predicate<FluidStack>, Function<FluidStack, ItemStack>> entry : BOTTLE_FILL_MAP.entrySet()) {
            if (!entry.getKey().test(fluid)) continue;
            bottle = entry.getValue().apply(fluid);
            break;
        }
        return !bottle.m_41619_() && FluidHelper.addFilledBottleToPlayer(stack, bottle, handler, player, hand);
    }

    public static boolean bucketFillTest(ItemStack stack, IFluidHandler handler) {
        if (stack.m_41720_() != Items.f_42446_) {
            return true;
        }
        FluidStack fluid = handler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (fluid.getAmount() != 1000) {
            return false;
        }
        return fluid.getFluid().m_6859_() != Items.f_41852_;
    }

    private static boolean addFilledBottleToPlayer(ItemStack stack, ItemStack bottle, IFluidHandler handler, Player player, InteractionHand hand) {
        if (handler.drain(250, IFluidHandler.FluidAction.EXECUTE).getAmount() == 250) {
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, ItemHelper.consumeItem(stack, 1));
                if (!player.m_36356_(bottle)) {
                    player.m_36176_(bottle, false);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean drainItemToHandler(ItemStack stack, IFluidHandler handler, Player player, InteractionHand hand) {
        if (stack.m_41619_() || handler == null || player == null) {
            return false;
        }
        if (FluidHelper.drainBottleToHandler(stack, handler, player, hand)) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        InvWrapper playerInv = new InvWrapper((Container)player.m_150109_());
        FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)playerInv, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (result.isSuccess()) {
            player.m_21008_(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean fillItemFromHandler(ItemStack stack, IFluidHandler handler, Player player, InteractionHand hand) {
        InvWrapper playerInv;
        FluidActionResult result;
        if (stack.m_41619_() || handler == null || player == null || !FluidHelper.bucketFillTest(stack, handler)) {
            return false;
        }
        if (FluidHelper.fillBottleFromHandler(stack, handler, player, hand)) {
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (stack.m_41613_() == 1) {
            FluidStack containedFluid = FluidHelper.getFluidContainedInItem(stack).orElse(FluidStack.EMPTY);
            int tankSpace = FluidHelper.getCapacityForItem(stack) - containedFluid.getAmount();
            if (!containedFluid.isEmpty() && tankSpace > 0) {
                stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(e -> {
                    if (player.m_150110_().f_35937_) {
                        handler.drain(new FluidStack(containedFluid, tankSpace), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        FluidUtil.tryFluidTransfer((IFluidHandler)e, (IFluidHandler)handler, (FluidStack)new FluidStack(containedFluid, tankSpace), (boolean)true);
                    }
                });
                return true;
            }
        }
        if ((result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)(playerInv = new InvWrapper((Container)player.m_150109_())), (int)Integer.MAX_VALUE, (Player)player, (boolean)true)).isSuccess()) {
            player.m_21008_(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean interactWithHandler(ItemStack stack, IFluidHandler handler, Player player, InteractionHand hand) {
        return FluidHelper.drainItemToHandler(stack, handler, player, hand) || FluidHelper.fillItemFromHandler(stack, handler, player, hand);
    }

    public static boolean hasPotionTag(FluidStack stack) {
        return !stack.isEmpty() && stack.getTag() != null && stack.getTag().m_128441_("Potion");
    }

    public static Potion getPotionFromFluid(FluidStack fluid) {
        return fluid.getFluid() == Fluids.f_76193_ ? Potions.f_43599_ : FluidHelper.getPotionFromFluidTag(fluid.getTag());
    }

    public static Potion getPotionFromFluidTag(@Nullable CompoundTag tag) {
        return tag == null || !tag.m_128441_("Potion") ? Potions.f_43598_ : Potion.m_43489_((String)tag.m_128461_("Potion"));
    }

    public static void addPotionTooltipStrings(FluidStack stack, List<Component> list) {
        ArrayList<Component> lores = new ArrayList<Component>();
        FluidHelper.addPotionTooltip(stack, lores, 1.0f);
        list.addAll(lores);
    }

    public static void addPotionTooltip(FluidStack stack, List<Component> list) {
        FluidHelper.addPotionTooltip(stack, list, 1.0f);
    }

    public static void addPotionTooltip(FluidStack stack, List<Component> lores, float durationFactor) {
        if (stack.isEmpty()) {
            return;
        }
        FluidHelper.addPotionTooltip(PotionUtils.m_43566_((CompoundTag)stack.getTag()), lores, durationFactor);
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> lores, float durationFactor) {
        ArrayList<Pair> list1 = new ArrayList<Pair>();
        if (list.isEmpty()) {
            lores.add((Component)EMPTY_POTION);
        } else {
            for (MobEffectInstance effectinstance : list) {
                TranslatableComponent mutableComponent = new TranslatableComponent(effectinstance.m_19576_());
                MobEffect effect = effectinstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectinstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.m_19564_() > 0) {
                    mutableComponent = new TranslatableComponent("potion.withAmplifier", new Object[]{mutableComponent, new TranslatableComponent("potion.potency." + effectinstance.m_19564_())});
                }
                if (effectinstance.m_19557_() > 20) {
                    mutableComponent = new TranslatableComponent("potion.withDuration", new Object[]{mutableComponent, MobEffectUtil.m_19581_((MobEffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((Component)mutableComponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add(TextComponent.f_131282_);
            lores.add((Component)new TranslatableComponent("potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)new TranslatableComponent("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_(), new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), new TranslatableComponent(((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static int color(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getColor(stack) : 0;
    }

    public static int luminosity(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getLuminosity(stack) : 0;
    }

    public static int density(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getDensity(stack) : 0;
    }

    public static boolean gaseous(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null && stack.getFluid().getAttributes().isGaseous();
    }

    public static int temperature(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getTemperature(stack) : 0;
    }

    public static int viscosity(FluidStack stack) {
        return !stack.isEmpty() && stack.getFluid() != null ? stack.getFluid().getAttributes().getViscosity(stack) : 0;
    }
}

