/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.capability.CapabilityShieldItem;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ShieldEvents {
    private ShieldEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        DamageSource source;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (!ShieldEvents.canBlockDamageSource(entity, source = event.getSource())) {
            return;
        }
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).m_19403_()) {
            return;
        }
        ItemStack shield = entity.m_21211_();
        shield.getCapability(CapabilityShieldItem.SHIELD_ITEM_CAPABILITY).ifPresent(cap -> cap.onBlock(entity, source, event.getAmount()));
    }

    public static boolean canBlockDamageSource(LivingEntity living, DamageSource source) {
        AbstractArrow arrow;
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_36796_() > 0) {
            return false;
        }
        if (!source.m_19376_() && living.m_21254_()) {
            return ShieldEvents.canBlockDamagePosition(living, source.m_7270_());
        }
        return false;
    }

    public static boolean canBlockDamagePosition(LivingEntity living, Vec3 sourcePos) {
        if (sourcePos != null) {
            return new Vec3(living.m_20185_() - sourcePos.m_7096_(), 0.0, living.m_20189_() - sourcePos.m_7094_()).m_82526_(living.m_20252_(1.0f)) < 0.0;
        }
        return false;
    }
}

