/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.capability.SimpleCapProvider;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.RandomTickPart;
import codechicken.multipart.util.WorldTickScheduler;
import net.covers1624.quack.util.CrashLock;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TickScheduler {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final Capability<WorldTickScheduler> WORLD_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<WorldTickScheduler>(){});
    private static final Capability<WorldTickScheduler.ChunkScheduler> CHUNK_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<WorldTickScheduler.ChunkScheduler>(){});
    private static final ResourceLocation WORLD_KEY = new ResourceLocation("cb_multipart", "world_scheduled_ticks");
    private static final ResourceLocation CHUNK_KEY = new ResourceLocation("cb_multipart", "chunk_scheduled_ticks");

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(TickScheduler::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, TickScheduler::attachLevelCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(LevelChunk.class, TickScheduler::attachChunkCapabilities);
        MinecraftForge.EVENT_BUS.addListener(TickScheduler::onChunkLoad);
        MinecraftForge.EVENT_BUS.addListener(TickScheduler::onChunkUnload);
        MinecraftForge.EVENT_BUS.addListener(TickScheduler::onWorldTick);
    }

    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(WorldTickScheduler.class);
        event.register(WorldTickScheduler.ChunkScheduler.class);
    }

    private static void attachLevelCapabilities(AttachCapabilitiesEvent<Level> event) {
        Object object = event.getObject();
        if (!(object instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)object;
        WorldTickScheduler scheduler = new WorldTickScheduler(world);
        event.addCapability(WORLD_KEY, (ICapabilityProvider)new SimpleCapProvider(WORLD_CAPABILITY, (Object)scheduler));
    }

    private static void attachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        Level level = ((LevelChunk)event.getObject()).m_62953_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance(level2);
        final WorldTickScheduler.ChunkScheduler scheduler = new WorldTickScheduler.ChunkScheduler(worldScheduler, (LevelChunk)event.getObject());
        final LazyOptional opt = LazyOptional.of(() -> scheduler);
        event.addCapability(CHUNK_KEY, (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

            public Tag serializeNBT() {
                return WorldTickScheduler.CHUNK_STORAGE.writeNBT(scheduler);
            }

            public void deserializeNBT(Tag nbt) {
                WorldTickScheduler.CHUNK_STORAGE.readNBT(scheduler, nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == CHUNK_CAPABILITY) {
                    return (LazyOptional)SneakyUtils.unsafeCast((Object)opt);
                }
                return LazyOptional.empty();
            }
        });
    }

    private static void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunkAccess;
        if (!(event.getWorld() instanceof ServerLevel) || !((chunkAccess = event.getChunk()) instanceof LevelChunk)) {
            return;
        }
        LevelChunk chunk = (LevelChunk)chunkAccess;
        WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(chunk);
        chunkScheduler.onChunkLoad();
    }

    private static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance(level);
        worldScheduler.onChunkUnload(event.getChunk().m_7697_());
    }

    private static void onWorldTick(TickEvent.WorldTickEvent event) {
        ServerLevel level;
        block3: {
            block2: {
                Level level2 = event.world;
                if (!(level2 instanceof ServerLevel)) break block2;
                level = (ServerLevel)level2;
                if (event.phase == TickEvent.Phase.END) break block3;
            }
            return;
        }
        WorldTickScheduler worldScheduler = WorldTickScheduler.getInstance(level);
        worldScheduler.tick();
    }

    public static void scheduleTick(MultiPart part, int ticks) {
        ServerLevel level;
        ChunkAccess chunk;
        Level level2 = part.level();
        if (level2 instanceof ServerLevel && (chunk = (level = (ServerLevel)level2).m_46865_(part.pos())) instanceof LevelChunk) {
            LevelChunk lc = (LevelChunk)chunk;
            WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(lc);
            chunkScheduler.addScheduledTick(part, ticks);
        }
    }

    public static void loadRandomTick(RandomTickPart part) {
        ServerLevel level;
        ChunkAccess chunk;
        Level level2 = part.level();
        if (level2 instanceof ServerLevel && (chunk = (level = (ServerLevel)level2).m_46865_(part.pos())) instanceof LevelChunk) {
            TickScheduler.loadRandomTick(part, (LevelChunk)chunk);
        }
    }

    public static void loadRandomTick(RandomTickPart part, LevelChunk chunk) {
        if (chunk.m_62953_() instanceof ServerLevel) {
            WorldTickScheduler.ChunkScheduler chunkScheduler = WorldTickScheduler.getInstance(chunk);
            chunkScheduler.loadRandomTick(part);
        }
    }
}

