/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.lib.packet.PacketCustom;
import codechicken.mixin.api.MixinFactory;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartSPH;
import codechicken.multipart.util.MultipartGenerator;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MultipartHelper {
    @Nullable
    public static TileMultipart getOrConvertTile(Level world, BlockPos pos) {
        return (TileMultipart)((Object)MultipartHelper.getOrConvertTile2(world, pos).getLeft());
    }

    public static Pair<@Nullable TileMultipart, Boolean> getOrConvertTile2(Level world, BlockPos pos) {
        BlockEntity t = world.m_7702_(pos);
        if (t instanceof TileMultipart) {
            return Pair.of((Object)((Object)((TileMultipart)t)), (Object)false);
        }
        Collection<MultiPart> parts = MultiPartRegistries.convertBlock((LevelAccessor)world, pos, world.m_8055_(pos));
        if (!parts.isEmpty()) {
            TileMultipart tile = MultipartGenerator.INSTANCE.generateCompositeTile(null, pos, parts, world.f_46443_);
            tile.m_142339_(world);
            parts.forEach(tile::addPart_do);
            return Pair.of((Object)((Object)tile), (Object)true);
        }
        return Pair.of(null, (Object)false);
    }

    public static TileMultipart partRemoved(TileMultipart tile) {
        TileMultipart newTile = MultipartGenerator.INSTANCE.generateCompositeTile(tile, tile.m_58899_(), tile.getPartList(), tile.m_58904_().f_46443_);
        if (tile != newTile) {
            tile.setValid(false);
            MultipartHelper.silentAddTile(tile.m_58904_(), tile.m_58899_(), newTile);
            newTile.from(tile);
            newTile.notifyTileChange();
            newTile.notifyShapeChange();
        }
        return newTile;
    }

    public static TileMultipart addPart(Level world, BlockPos pos, MultiPart part) {
        Pair<TileMultipart, Boolean> pair = MultipartHelper.getOrConvertTile2(world, pos);
        TileMultipart tile = (TileMultipart)((Object)pair.getLeft());
        boolean converted = (Boolean)pair.getRight();
        ImmutableSet<MixinFactory.TraitKey> traits = MultipartGenerator.INSTANCE.getTraits(part, world.f_46443_);
        TileMultipart newTile = tile;
        if (newTile != null) {
            ImmutableSet<MixinFactory.TraitKey> tileTraits;
            if (converted) {
                for (MultiPart cPart : newTile.getPartList()) {
                    cPart.invalidateConvertedTile();
                }
                world.m_7731_(pos, ((BlockMultipart)CBMultipartModContent.MULTIPART_BLOCK.get()).m_49966_(), 0);
                MultipartHelper.silentAddTile(world, pos, newTile);
                PacketCustom.sendToChunk((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos), (Level)world, (BlockPos)pos);
                for (MultiPart cPart : newTile.getPartList()) {
                    cPart.onConverted();
                    MultiPartSPH.sendAddPart(newTile, cPart);
                }
            }
            if (!(tileTraits = MultipartGenerator.INSTANCE.getTraitsForClass(((Object)((Object)tile)).getClass())).containsAll(traits)) {
                ImmutableSet newTraits = ImmutableSet.builder().addAll(tileTraits).addAll(traits).build();
                newTile = ((MultipartGenerator.Factory)MultipartGenerator.INSTANCE.construct((ImmutableSet<MixinFactory.TraitKey>)newTraits)).newInstance(pos, ((BlockMultipart)CBMultipartModContent.MULTIPART_BLOCK.get()).m_49966_());
                newTile.setValid(false);
                MultipartHelper.silentAddTile(world, pos, newTile);
                newTile.from(tile);
            }
        } else {
            world.m_7731_(pos, ((BlockMultipart)CBMultipartModContent.MULTIPART_BLOCK.get()).m_49966_(), 0);
            newTile = ((MultipartGenerator.Factory)MultipartGenerator.INSTANCE.construct(traits)).newInstance(pos, ((BlockMultipart)CBMultipartModContent.MULTIPART_BLOCK.get()).m_49966_());
            MultipartHelper.silentAddTile(world, pos, newTile);
        }
        newTile.addPart_impl(part);
        return newTile;
    }

    public static void silentAddTile(Level world, BlockPos pos, BlockEntity tile) {
        LevelChunk chunk = world.m_46745_(pos);
        chunk.m_142169_(tile);
        chunk.m_156406_(tile);
    }
}

