/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.multipart.api.annotation.MultiPartTrait;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.PartialOcclusionPart;
import codechicken.multipart.block.TileMultipart;
import java.util.LinkedList;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

@MultiPartTrait(value=PartialOcclusionPart.class)
public class TPartialOcclusionTile
extends TileMultipart {
    @Nullable
    private static TPartialOcclusionTile lastOcclusionTestedTile;
    @Nullable
    private static VoxelShape lastOcclusionTestedShape;
    private static boolean lastOcclusionTestedResult;

    @Override
    public void bindPart(MultiPart newPart) {
        super.bindPart(newPart);
        if (newPart instanceof PartialOcclusionPart && lastOcclusionTestedTile == this) {
            lastOcclusionTestedTile = null;
        }
    }

    @Override
    public void partRemoved(MultiPart remPart, int p) {
        super.partRemoved(remPart, p);
        if (remPart instanceof PartialOcclusionPart && lastOcclusionTestedTile == this) {
            lastOcclusionTestedTile = null;
        }
    }

    @Override
    public boolean occlusionTest(Iterable<MultiPart> parts, MultiPart npart) {
        if (npart instanceof PartialOcclusionPart) {
            PartialOcclusionPart newPart = (PartialOcclusionPart)npart;
            VoxelShape newShape = newPart.getPartialOcclusionShape();
            if (lastOcclusionTestedTile != this || lastOcclusionTestedShape != newShape) {
                lastOcclusionTestedTile = this;
                lastOcclusionTestedShape = newShape;
                lastOcclusionTestedResult = TPartialOcclusionTile.partialOcclusionTest(parts, newPart);
            }
            if (!lastOcclusionTestedResult) {
                return false;
            }
        }
        return super.occlusionTest(parts, npart);
    }

    private static boolean partialOcclusionTest(Iterable<MultiPart> allParts, PartialOcclusionPart newPart) {
        LinkedList<PartialOcclusionPart> parts = new LinkedList<PartialOcclusionPart>();
        for (MultiPart part : allParts) {
            if (!(part instanceof PartialOcclusionPart)) continue;
            parts.add((PartialOcclusionPart)part);
        }
        parts.add(newPart);
        for (PartialOcclusionPart part1 : parts) {
            if (part1.allowCompleteOcclusion()) continue;
            VoxelShape uniqueShape = part1.getPartialOcclusionShape();
            for (PartialOcclusionPart part2 : parts) {
                if (part1 == part2) continue;
                uniqueShape = Shapes.m_83113_((VoxelShape)uniqueShape, (VoxelShape)part2.getPartialOcclusionShape(), (BooleanOp)BooleanOp.f_82685_);
            }
            if (!uniqueShape.m_83281_()) continue;
            return false;
        }
        return true;
    }
}

