/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.ModContent;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LeverPart
extends McSidedStatePart
implements FaceRedstonePart {
    public LeverPart() {
    }

    public LeverPart(BlockState state) {
        super(state);
    }

    @Override
    public MultipartType<?> getType() {
        return ModContent.leverPartType;
    }

    @Override
    public BlockState defaultBlockState() {
        return Blocks.f_50164_.m_49966_();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)Blocks.f_50164_);
    }

    public boolean active() {
        return (Boolean)this.state.m_61143_((Property)LeverBlock.f_54622_);
    }

    @Override
    public Direction getSide() {
        return FaceAttachedHorizontalDirectionalBlock.m_53200_((BlockState)this.state).m_122424_();
    }

    @Override
    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state;
        Direction face = context.m_43719_();
        switch (face) {
            case DOWN: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.CEILING)).m_61124_((Property)LeverBlock.f_54117_, (Comparable)context.m_8125_());
                break;
            }
            case UP: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)LeverBlock.f_54117_, (Comparable)context.m_8125_());
                break;
            }
            default: {
                BlockState blockState = state = (BlockState)((BlockState)this.defaultBlockState().m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)LeverBlock.f_54117_, (Comparable)face);
            }
        }
        if (state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            this.state = state;
            return this;
        }
        return null;
    }

    @Override
    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack item, InteractionHand hand) {
        if (this.level().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.state = (BlockState)this.state.m_61122_((Property)LeverBlock.f_54622_);
        this.level().m_5594_(null, this.pos(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, this.active() ? 0.6f : 0.5f);
        this.sendUpdate(this::writeDesc);
        this.tile().m_6596_();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSide().ordinal());
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public void onConverted() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.active() && side == this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    @Override
    public void readUpdate(MCDataInput packet) {
        super.readUpdate(packet);
        if (this.active()) {
            LeverBlock.m_54657_((BlockState)this.state, (LevelAccessor)this.level(), (BlockPos)this.pos(), (float)1.0f);
        }
    }
}

