/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.init;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.covers1624.quack.util.CrashLock;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MultiPartRegistries {
    private static final Logger logger = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    public static IForgeRegistry<MultipartType<?>> MULTIPART_TYPES;
    private static IForgeRegistry<PartConverter> PART_CONVERTERS;

    public static void init() {
        LOCK.lock();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(MultiPartRegistries::createRegistries);
    }

    private static void createRegistries(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(MultipartType.MULTIPART_TYPES).setType((Class)SneakyUtils.unsafeCast(MultipartType.class)).disableSaving(), e -> {
            MULTIPART_TYPES = (ForgeRegistry)e;
        });
        event.create(new RegistryBuilder().setName(PartConverter.PART_CONVERTERS).setType(PartConverter.class).disableOverrides().disableSaving().disableSync(), e -> {
            PART_CONVERTERS = e;
        });
    }

    public static void writePart(MCDataOutput data, MultiPart part) {
        MultipartType<?> type = Objects.requireNonNull(part.getType());
        ResourceLocation name = Objects.requireNonNull(type.getRegistryName());
        if (!MULTIPART_TYPES.containsKey(name)) {
            throw new RuntimeException("MultiPartType with name '" + name + "' is not registered.");
        }
        data.writeRegistryIdUnsafe(MULTIPART_TYPES, type);
        part.writeDesc(data);
    }

    public static MultiPart readPart(MCDataInput data) {
        MultipartType type = (MultipartType)data.readRegistryIdUnsafe(MULTIPART_TYPES);
        Object part = type.createPartClient(data);
        part.readDesc(data);
        return part;
    }

    public static CompoundTag savePart(CompoundTag nbt, MultiPart part) {
        MultipartType<?> type = Objects.requireNonNull(part.getType());
        ResourceLocation name = Objects.requireNonNull(type.getRegistryName());
        nbt.m_128359_("id", name.toString());
        part.save(nbt);
        return nbt;
    }

    @Nullable
    public static MultiPart loadPart(CompoundTag nbt) {
        ResourceLocation name = new ResourceLocation(nbt.m_128461_("id"));
        MultipartType type = (MultipartType)MULTIPART_TYPES.getValue(name);
        if (type == null) {
            logger.error("Missing mapping for MultiPartType with ID: {}", (Object)name);
            return null;
        }
        Object part = type.createPartServer(nbt);
        if (part != null) {
            part.load(nbt);
        }
        return part;
    }

    public static Collection<MultiPart> convertBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        for (PartConverter conv : PART_CONVERTERS.getValues()) {
            PartConverter.ConversionResult<Collection<MultiPart>> result = conv.convert(level, pos, state);
            if (!result.success()) continue;
            assert (result.result() != null);
            return result.result();
        }
        return List.of();
    }

    @Nullable
    public static MultiPart convertItem(MultipartPlaceContext context) {
        for (PartConverter conv : PART_CONVERTERS.getValues()) {
            PartConverter.ConversionResult<MultiPart> result = conv.convert(context);
            if (!result.success()) continue;
            assert (result.result() != null);
            return result.result();
        }
        return null;
    }
}

