/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.util.PartRayTraceResult;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;

public class MultipartBlockRenderer
implements ICCBlockRenderer {
    public boolean canHandleBlock(BlockAndTintGetter world, BlockPos pos, BlockState blockState) {
        return blockState.m_60734_() == CBMultipartModContent.MULTIPART_BLOCK.get();
    }

    public boolean renderBlock(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, Random random, IModelData data) {
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)world, pos);
        if (tile != null) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((VertexConsumer)new TransformingVertexConsumer(builder, mStack), DefaultVertexFormat.f_85811_);
            ccrs.lightMatrix.locate(world, pos);
            return this.renderStatic(tile, MinecraftForgeClient.getRenderType(), ccrs);
        }
        return false;
    }

    public void renderBreaking(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, IModelData data) {
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)world, pos);
        if (tile != null) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            mStack.m_85836_();
            ccrs.bind((VertexConsumer)new TransformingVertexConsumer(builder, mStack), DefaultVertexFormat.f_85811_);
            ccrs.overlay = OverlayTexture.f_118083_;
            ccrs.brightness = LevelRenderer.m_109537_((BlockAndTintGetter)world, (BlockState)state, (BlockPos)pos);
            ccrs.lightMatrix.locate(world, pos);
            this.renderBreaking(tile, ccrs);
            mStack.m_85849_();
        }
    }

    private boolean renderStatic(TileMultipart tile, RenderType type, CCRenderState ccrs) {
        boolean ret = false;
        for (MultiPart part : tile.getPartList()) {
            PartRenderer<MultiPart> renderer = MultipartClientRegistry.getRenderer(part.getType());
            if (renderer == null) continue;
            ret |= renderer.renderStatic((MultiPart)SneakyUtils.unsafeCast((Object)part), type, ccrs);
        }
        return ret;
    }

    private void renderBreaking(TileMultipart tile, CCRenderState ccrs) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof PartRayTraceResult) {
            PartRayTraceResult hit = (PartRayTraceResult)hitResult;
            PartRenderer<MultiPart> renderer = MultipartClientRegistry.getRenderer(hit.part.getType());
            if (renderer != null) {
                renderer.renderBreaking((MultiPart)SneakyUtils.unsafeCast((Object)hit.part), ccrs);
            }
        }
    }
}

