/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.block;

import codechicken.lib.capability.CapabilityCache;
import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.world.IChunkLoadTile;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.init.CBMultipartModContent;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartSPH;
import codechicken.multipart.util.MergedVoxelShapeHolder;
import codechicken.multipart.util.MultipartGenerator;
import codechicken.multipart.util.MultipartHelper;
import codechicken.multipart.util.MultipartVoxelShape;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class TileMultipart
extends BlockEntity
implements IChunkLoadTile {
    private List<MultiPart> partList = new CopyOnWriteArrayList<MultiPart>();
    private final CapabilityCache capabilityCache = new CapabilityCache();
    private final MergedVoxelShapeHolder<MultiPart> outlineShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> collisionShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> occlusionShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> interactionShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> supportShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));
    private final MergedVoxelShapeHolder<MultiPart> visualShapeHolder = new MergedVoxelShapeHolder(e -> new MultipartVoxelShape((VoxelShape)e, this));

    public TileMultipart(BlockPos pos, BlockState state) {
        super((BlockEntityType)CBMultipartModContent.MULTIPART_TILE_TYPE.get(), pos, state);
    }

    protected TileMultipart() {
        this(null, null);
        throw new UnsupportedOperationException("Exists for traits.");
    }

    public List<MultiPart> getPartList() {
        return this.partList;
    }

    public void from(TileMultipart that) {
        this.copyFrom(that);
        this.loadFrom(that);
        that.loadTo(this);
    }

    public void copyFrom(TileMultipart that) {
        this.partList = that.partList;
        this.markShapeChange();
    }

    public void loadFrom(TileMultipart that) {
        this.partList.forEach(e -> ((BaseMultipart)e).bind(this));
    }

    public void loadTo(TileMultipart that) {
    }

    public void clearParts() {
        this.partList = new CopyOnWriteArrayList<MultiPart>();
        this.markShapeChange();
    }

    public void bindPart(MultiPart part) {
    }

    public void partAdded(MultiPart part) {
    }

    public void partRemoved(MultiPart part, int p) {
    }

    public boolean getWeakChanges() {
        return false;
    }

    public void onNeighborTileChange(BlockPos neighborPos) {
    }

    @Nullable
    public MultiPart getSlottedPart(int slot) {
        return null;
    }

    public void onRemoved() {
    }

    public void operate(Consumer<MultiPart> cons) {
        for (MultiPart part : this.partList) {
            if (!part.hasTile()) continue;
            cons.accept(part);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag parts = new ListTag();
        for (MultiPart part : this.partList) {
            parts.add((Object)MultiPartRegistries.savePart(new CompoundTag(), part));
        }
        tag.m_128365_("parts", (Tag)parts);
    }

    public final CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        MCDataByteBuf desc = new MCDataByteBuf();
        this.writeDesc((MCDataOutput)desc);
        desc.writeToNBT(tag, "data");
        return tag;
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeByte(this.partList.size());
        for (MultiPart part : this.partList) {
            MultiPartRegistries.writePart(packet, part);
        }
    }

    public boolean canAddPart(MultiPart part) {
        return !this.partList.contains(part) && this.occlusionTest(this.partList, part);
    }

    public boolean canReplacePart(MultiPart oPart, MultiPart nPart) {
        if (oPart != nPart && this.partList.contains(nPart)) {
            return false;
        }
        return this.occlusionTest((Iterable<MultiPart>)FastStream.of(this.partList).filter(e -> e != oPart), nPart);
    }

    public boolean occlusionTest(Iterable<MultiPart> parts, MultiPart nPart) {
        return ColUtils.allMatch(parts, part -> part.occlusionTest(nPart) && nPart.occlusionTest((MultiPart)part));
    }

    public void addPart_impl(MultiPart part) {
        if (!this.f_58857_.f_46443_) {
            MultiPartSPH.sendAddPart(this, part);
        }
        this.addPart_do(part);
        part.onAdded();
        this.partAdded(part);
        this.notifyPartChange(part);
        this.notifyTileChange();
        this.m_6596_();
        this.markRender();
    }

    public void addPart_do(MultiPart part) {
        this.partList.add(part);
        this.bindPart(part);
        this.markShapeChange();
        ((BaseMultipart)part).bind(this);
    }

    @Nullable
    public TileMultipart remPart(MultiPart part) {
        Preconditions.checkArgument((!this.f_58857_.f_46443_ ? 1 : 0) != 0, (Object)"Cannot remove MultiParts from a client tile.");
        return this.remPart_impl(part);
    }

    @Nullable
    public TileMultipart remPart_impl(MultiPart part) {
        this.remPart_do(part, !this.f_58857_.f_46443_);
        if (!this.m_58901_()) {
            TileMultipart tile = TileMultipart.partRemoved(this);
            tile.notifyPartChange(part);
            tile.notifyShapeChange();
            tile.m_6596_();
            tile.markRender();
            return tile;
        }
        return null;
    }

    private int remPart_do(MultiPart part, boolean sendPacket) {
        int idx = this.partList.indexOf(part);
        if (idx < 0) {
            throw new IllegalArgumentException("Tried to remove a non-existent part");
        }
        part.preRemove();
        this.partList.removeIf(e -> e == part);
        if (sendPacket) {
            MultiPartSPH.sendRemPart(this, idx);
        }
        this.partRemoved(part, idx);
        part.onRemoved();
        ((BaseMultipart)part).bind(null);
        this.markShapeChange();
        this.recalcLight(false, true);
        if (this.partList.isEmpty()) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
        return idx;
    }

    private void loadParts(Iterable<MultiPart> parts) {
        this.clearParts();
        parts.forEach(this::addPart_do);
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.operate(MultiPart::onWorldJoin);
            }
            this.notifyPartChange(null);
        }
    }

    public final void setValid(boolean b) {
        if (b) {
            this.m_6339_();
        } else {
            this.m_7651_();
        }
    }

    public void m_7651_() {
        if (!this.m_58901_()) {
            super.m_7651_();
            this.onRemoved();
            if (this.f_58857_ != null) {
                this.partList.forEach(MultiPart::onWorldSeparate);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return super.getCapability(cap, side);
    }

    public VoxelShape getShape(CollisionContext context) {
        return this.outlineShapeHolder.update(this.partList, part -> part.getShape(context));
    }

    public VoxelShape getCollisionShape(CollisionContext context) {
        return this.collisionShapeHolder.update(this.partList, part -> part.getCollisionShape(context));
    }

    public VoxelShape getRenderOcclusionShape() {
        return this.occlusionShapeHolder.update(this.partList, MultiPart::getRenderOcclusionShape);
    }

    public VoxelShape getInteractionShape() {
        return this.interactionShapeHolder.update(this.partList, MultiPart::getInteractionShape);
    }

    public VoxelShape getBlockSupportShape() {
        return this.supportShapeHolder.update(this.partList, MultiPart::getBlockSupportShape);
    }

    public VoxelShape getVisualShape(CollisionContext context) {
        return this.visualShapeHolder.update(this.partList, part -> part.getVisualShape(context));
    }

    public void harvestPart(PartRayTraceResult hit, Player player) {
        hit.part.harvest(player, hit);
    }

    public List<ItemStack> getDrops() {
        return this.partList.stream().map(MultiPart::getDrops).flatMap(e -> StreamSupport.stream(e.spliterator(), false)).collect(Collectors.toList());
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return hit.part.getCloneStack(hit);
    }

    public float getExplosionResistance(Explosion explosion) {
        return (float)this.partList.stream().mapToDouble(e -> e.getExplosionResistance(explosion)).max().orElse(0.0);
    }

    public int getLightEmission() {
        return this.partList.stream().mapToInt(MultiPart::getLightEmission).max().orElse(0);
    }

    public float getDestroyProgress(Player player, PartRayTraceResult hit) {
        return hit.part.getStrength(player, hit);
    }

    public void onChunkUnloaded() {
        this.operate(MultiPart::onChunkUnload);
    }

    public void onChunkLoad(LevelChunk chunk) {
        this.operate(e -> e.onChunkLoad(chunk));
    }

    public void onMoved() {
        this.capabilityCache.setWorldPos(this.f_58857_, this.f_58858_);
        this.operate(MultiPart::onMoved);
    }

    public InteractionResult use(Player player, PartRayTraceResult hit, InteractionHand hand) {
        return hit.part.activate(player, hit, player.m_21120_(hand), hand);
    }

    public void attack(Player player, PartRayTraceResult hit) {
        hit.part.click(player, hit, player.m_21205_());
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.capabilityCache.setWorldPos(level, this.m_58899_());
    }

    public void entityInside(Entity entity) {
        this.operate(e -> e.onEntityCollision(entity));
    }

    public void stepOn(Entity entity) {
        this.operate(e -> e.onEntityStanding(entity));
    }

    public void onNeighborBlockChanged(BlockPos pos) {
        this.capabilityCache.onNeighborChanged(pos);
        this.operate(e -> e.onNeighborBlockChanged(pos));
    }

    public boolean canConnectRedstone(int side) {
        return false;
    }

    public int getDirectSignal(int side) {
        return 0;
    }

    public int getSignal(int side) {
        return 0;
    }

    public AABB getRenderBoundingBox() {
        Cuboid6 c = Cuboid6.full.copy();
        this.operate(e -> c.enclose(e.getRenderBounds()));
        return c.add(this.f_58858_).aabb();
    }

    public void animateTick(Random random) {
    }

    public boolean isClientTile() {
        return false;
    }

    public void addLandingEffects(Vector3 entity, int numberOfParticles) {
        PartRayTraceResult hit = this.hitFeet(entity);
        if (hit == null) {
            return;
        }
        hit.part.addLandingEffects(hit, entity, numberOfParticles);
    }

    public void addRunningEffects(Entity entity) {
        PartRayTraceResult hit = this.hitFeet(Vector3.fromEntity((Entity)entity));
        if (hit == null) {
            return;
        }
        hit.part.addRunningEffects(hit, entity);
    }

    @Nullable
    private PartRayTraceResult hitFeet(Vector3 entityPos) {
        BlockHitResult hit = this.getCollisionShape(CollisionContext.m_82749_()).m_83220_(entityPos.copy().add(0.0, 0.01, 0.0).vec3(), entityPos.copy().add(0.0, -0.01, 0.0).vec3(), this.m_58899_());
        if (!(hit instanceof PartRayTraceResult)) {
            return null;
        }
        PartRayTraceResult pHit = (PartRayTraceResult)hit;
        double dist = entityPos.copy().subtract(hit.m_82450_()).mag();
        if (!MathHelper.between((double)-0.01, (double)dist, (double)0.01)) {
            return null;
        }
        return pHit;
    }

    public void notifyTileChange() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.f_58858_, (Block)CBMultipartModContent.MULTIPART_BLOCK.get());
        }
    }

    public void notifyShapeChange() {
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            state.m_60705_((LevelAccessor)this.f_58857_, this.m_58899_(), 19, 512);
            state.m_60762_((LevelAccessor)this.f_58857_, this.m_58899_(), 19, 512);
        }
    }

    public void notifyPartChange(@Nullable MultiPart part) {
        this.internalPartChange(part);
        BlockState state = ((BlockMultipart)CBMultipartModContent.MULTIPART_BLOCK.get()).m_49966_();
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, (Block)CBMultipartModContent.MULTIPART_BLOCK.get());
        this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
    }

    public void internalPartChange(@Nullable MultiPart part) {
        this.operate(e -> {
            if (e != part) {
                e.onPartChanged(part);
            }
        });
    }

    public void multiPartChange(Collection<MultiPart> parts) {
        this.operate(p -> {
            if (!parts.contains(p)) {
                parts.forEach(p::onPartChanged);
            }
        });
    }

    public void m_6596_() {
        super.m_6596_();
    }

    public void markRender() {
    }

    public void recalcLight(boolean sky, boolean block) {
        LevelLightEngine lm = this.f_58857_.m_5518_();
        if (sky && lm.f_75803_ != null) {
            lm.f_75803_.m_142202_(this.f_58858_);
        }
        if (block && lm.f_75802_ != null) {
            lm.f_75802_.m_142202_(this.f_58858_);
        }
    }

    public void markShapeChange() {
        this.outlineShapeHolder.clear();
        this.collisionShapeHolder.clear();
        this.occlusionShapeHolder.clear();
        this.interactionShapeHolder.clear();
    }

    public void notifyNeighborChange(Direction side) {
        this.f_58857_.m_46672_(this.f_58858_.m_142300_(side), (Block)CBMultipartModContent.MULTIPART_BLOCK.get());
    }

    public void notifyNeighborChange(int side) {
        this.notifyNeighborChange(Direction.m_122376_((int)side));
    }

    public void dropItems(Iterable<ItemStack> items) {
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this);
        items.forEach(e -> TileMultipart.dropItem(e, this.f_58857_, pos));
    }

    public CapabilityCache getCapCache() {
        return this.capabilityCache;
    }

    public static boolean canPlacePart(UseOnContext context, MultiPart part) {
        BlockPos pos;
        Level level = context.m_43725_();
        if (!TileMultipart.isUnobstructed(level, pos = context.m_8083_(), part)) {
            return false;
        }
        TileMultipart tile = MultipartHelper.getOrConvertTile(level, pos);
        if (tile != null) {
            return tile.canAddPart(part);
        }
        return TileMultipart.replaceable(level, pos, context);
    }

    public static boolean isUnobstructed(Level world, BlockPos pos, MultiPart part) {
        return world.m_5450_(null, part.getCollisionShape(CollisionContext.m_82749_()).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public static boolean replaceable(Level world, BlockPos pos, UseOnContext context) {
        BlockState state = world.m_8055_(pos);
        return state.m_60795_() || state.m_60629_(new BlockPlaceContext(context));
    }

    public static TileMultipart addPart(Level world, BlockPos pos, MultiPart part) {
        return MultipartHelper.addPart(world, pos, part);
    }

    public static void handleDescPacket(Level world, BlockPos pos, MCDataInput packet) {
        ArrayList<MultiPart> parts = new ArrayList<MultiPart>();
        int nParts = packet.readUByte();
        for (int i = 0; i < nParts; ++i) {
            parts.add(MultiPartRegistries.readPart(packet));
        }
        if (parts.isEmpty()) {
            return;
        }
        BlockEntity t = world.m_7702_(pos);
        TileMultipart tile = MultipartGenerator.INSTANCE.generateCompositeTile(t, pos, parts, true);
        if (tile != t) {
            world.m_46597_(pos, ((BlockMultipart)CBMultipartModContent.MULTIPART_BLOCK.get()).m_49966_());
            MultipartHelper.silentAddTile(world, pos, tile);
        }
        tile.loadParts(parts);
        tile.notifyTileChange();
        tile.notifyShapeChange();
        tile.markRender();
    }

    @Nullable
    public static TileMultipart fromNBT(CompoundTag tag, BlockPos pos) {
        ListTag partList = tag.m_128437_("parts", 10);
        ArrayList<MultiPart> parts = new ArrayList<MultiPart>();
        for (int i = 0; i < partList.size(); ++i) {
            MultiPart part = MultiPartRegistries.loadPart(partList.m_128728_(i));
            if (part == null) continue;
            parts.add(part);
        }
        if (parts.isEmpty()) {
            return null;
        }
        TileMultipart tile = MultipartGenerator.INSTANCE.generateCompositeTile(null, pos, parts, false);
        tile.m_142466_(tag);
        tile.loadParts(parts);
        return tile;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 pos) {
        ItemEntity item = new ItemEntity(level, pos.x, pos.y, pos.z, stack);
        item.m_20334_(level.f_46441_.nextGaussian() * 0.05, level.f_46441_.nextGaussian() * 0.05 + 0.2, level.f_46441_.nextGaussian() * 0.05);
        item.m_32010_(10);
        level.m_7967_((Entity)item);
    }

    private static TileMultipart partRemoved(TileMultipart tile) {
        TileMultipart newTile = MultipartGenerator.INSTANCE.generateCompositeTile(tile, tile.m_58899_(), tile.getPartList(), tile.f_58857_.f_46443_);
        if (tile != newTile) {
            tile.setValid(false);
            MultipartHelper.silentAddTile(tile.f_58857_, tile.m_58899_(), newTile);
            newTile.from(tile);
            newTile.notifyTileChange();
            newTile.notifyShapeChange();
        }
        return newTile;
    }
}

