/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.MixinCompilerImpl;
import codechicken.mixin.api.MixinDebugger;
import codechicken.mixin.util.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class SimpleDebugger
implements MixinDebugger {
    private static final Logger logger = LogManager.getLogger();
    private final Path root;
    private final DumpType type;

    public SimpleDebugger(Path root, DumpType type) {
        this.root = root;
        this.type = type;
        try {
            if (Files.exists(root, new LinkOption[0])) {
                if (!Files.isDirectory(root, new LinkOption[0])) {
                    logger.warn("Expected '{}' to be a directory. Overwriting..", (Object)root);
                    Files.delete(root);
                } else {
                    logger.log(MixinCompilerImpl.LOG_LEVEL, "Clearing debugger output. '{}'", (Object)root.toAbsolutePath());
                    Utils.deleteFolder(root);
                }
            }
            Files.createDirectories(root, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error("Encountered an error setting up SimpleDebugger.", (Throwable)e);
        }
    }

    @Override
    public void defineInternal(String name, byte[] bytes) {
        this.dump("internal_define", name, bytes);
    }

    @Override
    public void defineClass(String name, byte[] bytes) {
        this.dump("define", name, bytes);
    }

    /*
     * Unable to fully structure code
     */
    public void dump(String from, String name, byte[] bytes) {
        name = name.replace("/", ".");
        try {
            folder = this.root.resolve(from);
            if (!Files.exists(folder, new LinkOption[0])) {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            switch (1.$SwitchMap$codechicken$mixin$util$SimpleDebugger$DumpType[this.type.ordinal()]) {
                case 1: {
                    try {
                        SimpleDebugger.logger.log(MixinCompilerImpl.LOG_LEVEL, "Dumping '{}' from {} as text", (Object)name, (Object)from);
                        path = folder.resolve(name + ".txt");
                        writer = Files.newBufferedWriter(path, new OpenOption[0]);
                        var7_12 = null;
                        cv = new TraceClassVisitor(null, (Printer)new Textifier(), new PrintWriter(writer));
                        reader = new ClassReader(bytes);
                        reader.accept((ClassVisitor)cv, 8);
                        if (writer == null) break;
                        if (var7_12 == null) ** GOTO lbl26
                        try {
                            writer.close();
                        }
                        catch (Throwable var8_15) {
                            var7_12.addSuppressed(var8_15);
                        }
                        break;
lbl26:
                        // 1 sources

                        writer.close();
                        break;
                        catch (Throwable var8_16) {
                            try {
                                var7_12 = var8_16;
                                throw var8_16;
                            }
                            catch (Throwable var10_20) {
                                if (writer != null) {
                                    if (var7_12 != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (Throwable var11_21) {
                                            var7_12.addSuppressed(var11_21);
                                        }
                                    } else {
                                        writer.close();
                                    }
                                }
                                throw var10_20;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        SimpleDebugger.logger.warn("Fatal exception dumping as text. Dumping as binary.", (Throwable)e);
                    }
                }
                case 2: {
                    SimpleDebugger.logger.log(MixinCompilerImpl.LOG_LEVEL, "Dumping '{}' from {} as binary.", (Object)name, (Object)from);
                    path = folder.resolve(name + ".class");
                    os = Files.newOutputStream(path, new OpenOption[0]);
                    var7_13 = null;
                    os.write(bytes);
                    if (os == null) break;
                    if (var7_13 == null) ** GOTO lbl62
                    try {
                        os.close();
                    }
                    catch (Throwable var8_17) {
                        var7_13.addSuppressed(var8_17);
                    }
                    break;
lbl62:
                    // 1 sources

                    os.close();
                    break;
                    catch (Throwable var8_18) {
                        try {
                            var7_13 = var8_18;
                            throw var8_18;
                        }
                        catch (Throwable var12_22) {
                            if (os != null) {
                                if (var7_13 != null) {
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable var13_23) {
                                        var7_13.addSuppressed(var13_23);
                                    }
                                } else {
                                    os.close();
                                }
                            }
                            throw var12_22;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            SimpleDebugger.logger.error("Unable to dump '{}' to disk.", (Object)name, (Object)e);
        }
    }

    public static enum DumpType {
        TEXT,
        BINARY;

    }
}

