/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.api;

import codechicken.mixin.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.covers1624.quack.reflect.PrivateLookups;

public interface MixinBackend {
    @Nullable
    public byte[] getBytes(String var1);

    @Nonnull
    public <T> Class<T> defineClass(String var1, byte[] var2);

    public Class<?> loadClass(String var1);

    default public boolean filterMethodAnnotations(String annType, String value) {
        return true;
    }

    public static class SimpleMixinBackend
    implements MixinBackend {
        protected static final MethodHandle m_defineClass;
        private final ClassLoader classLoader;

        public SimpleMixinBackend() {
            this(SimpleMixinBackend.class.getClassLoader());
        }

        public SimpleMixinBackend(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] getBytes(String name) {
            try (InputStream is = this.classLoader.getResourceAsStream(name + ".class");){
                int len;
                if (is == null) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                while ((len = is.read(buff)) != -1) {
                    bos.write(buff, 0, len);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                Utils.throwUnchecked(new ClassNotFoundException("Could not load bytes for '" + name + "'.", e));
                return null;
            }
        }

        @Override
        public <T> Class<T> defineClass(String name, byte[] bytes) {
            try {
                return m_defineClass.invokeExact(this.classLoader, bytes, 0, bytes.length);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to define class '" + name + "'.", e);
            }
        }

        @Override
        public Class<?> loadClass(String name) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        static {
            try {
                m_defineClass = PrivateLookups.getTrustedLookup().findVirtual(ClassLoader.class, "defineClass", MethodType.methodType(Class.class, byte[].class, Integer.TYPE, Integer.TYPE));
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to retrieve methods via reflection.", e);
            }
        }
    }
}

