/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.item;

import codechicken.lib.raytracer.RayTracer;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.part.ExecutablePlacement;
import codechicken.microblock.part.MicroblockPlacement;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.util.MicroMaterialRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ItemMicroBlock
extends Item {
    private static final String SIZE_TAG = "size";
    private static final String MATERIAL_TAG = "mat";
    private static final String FACTORY_ID_TAG = "factory_id";

    public ItemMicroBlock(Item.Properties properties) {
        super(properties);
    }

    public Component m_7626_(ItemStack stack) {
        MicroMaterial material = ItemMicroBlock.getMaterialFromStack(stack);
        StandardMicroFactory factory = ItemMicroBlock.getFactory(stack);
        int size = ItemMicroBlock.getSize(stack);
        if (material == null || factory == null) {
            return new TextComponent("Unnamed");
        }
        return new TranslatableComponent("item." + factory.getRegistryName().toString().replace(':', '.') + "." + size, new Object[]{material.getLocalizedName()});
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (!this.m_41389_(tab)) {
            return;
        }
        for (StandardMicroFactory factory : StandardMicroFactory.FACTORIES.values()) {
            for (int size : new int[]{1, 2, 4}) {
                for (MicroMaterial microMaterial : MicroMaterialRegistry.MICRO_MATERIALS) {
                    items.add((Object)ItemMicroBlock.create(factory.factoryId, size, microMaterial));
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        Level level = ctx.m_43725_();
        ItemStack stack = player.m_21120_(ctx.m_43724_());
        MicroMaterial material = ItemMicroBlock.getMaterialFromStack(stack);
        StandardMicroFactory factory = ItemMicroBlock.getFactory(stack);
        int size = ItemMicroBlock.getSize(stack);
        if (material == null || factory == null) {
            return InteractionResult.FAIL;
        }
        BlockHitResult hit = RayTracer.retraceBlock((LevelReader)level, (Player)player, (BlockPos)ctx.m_8083_());
        if (hit != null) {
            ExecutablePlacement placement = new MicroblockPlacement(player, ctx.m_43724_(), hit, size, material, !player.m_150110_().f_35937_, factory.placementProperties()).calculate();
            if (placement == null) {
                return InteractionResult.FAIL;
            }
            if (!level.f_46443_) {
                SoundType sound;
                placement.place(level, player, stack);
                if (!player.m_150110_().f_35937_) {
                    placement.consume(level, player, stack);
                }
                if ((sound = material.getSound()) != null) {
                    level.m_6263_(null, (double)placement.pos.m_123341_() + 0.5, (double)placement.pos.m_123342_() + 0.5, (double)placement.pos.m_123343_() + 0.5, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public static StandardMicroFactory getFactory(ItemStack stack) {
        int factoryId = ItemMicroBlock.getFactoryID(stack);
        if (factoryId == -1 || factoryId > StandardMicroFactory.FACTORIES.size()) {
            return null;
        }
        return (StandardMicroFactory)((Object)StandardMicroFactory.FACTORIES.get(factoryId));
    }

    public static int getFactoryID(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(FACTORY_ID_TAG)) {
            return -1;
        }
        return stack.m_41784_().m_128451_(FACTORY_ID_TAG);
    }

    public static int getSize(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(SIZE_TAG)) {
            return -1;
        }
        return stack.m_41784_().m_128451_(SIZE_TAG);
    }

    @Nullable
    public static MicroMaterial getMaterialFromStack(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(MATERIAL_TAG)) {
            return null;
        }
        return MicroMaterialRegistry.getMaterial(stack.m_41784_().m_128461_(MATERIAL_TAG));
    }

    public static ItemStack create(int factoryId, int size, MicroMaterial material) {
        return ItemMicroBlock.create(factoryId, size, material.getRegistryName());
    }

    public static ItemStack create(int factoryId, int size, ResourceLocation material) {
        return ItemMicroBlock.createStack(1, factoryId, size, material);
    }

    public static ItemStack createStack(int amount, int factoryId, int size, MicroMaterial material) {
        return ItemMicroBlock.createStack(amount, factoryId, size, material.getRegistryName());
    }

    public static ItemStack createStack(int amount, int factoryId, int size, ResourceLocation material) {
        ItemStack stack = new ItemStack((ItemLike)CBMicroblockModContent.MICRO_BLOCK_ITEM.get(), amount);
        stack.m_41784_().m_128405_(FACTORY_ID_TAG, factoryId);
        stack.m_41784_().m_128405_(SIZE_TAG, size);
        stack.m_41784_().m_128359_(MATERIAL_TAG, material.toString());
        return stack;
    }
}

