/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.init.MicroMaterialConfig;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.item.SawItem;
import codechicken.microblock.part.corner.CornerMicroFactory;
import codechicken.microblock.part.edge.EdgeMicroFactory;
import codechicken.microblock.part.edge.PostMicroblockFactory;
import codechicken.microblock.part.face.FaceMicroFactory;
import codechicken.microblock.part.hollow.HollowMicroFactory;
import codechicken.microblock.recipe.MicroRecipe;
import codechicken.microblock.util.MicroMaterialRegistry;
import codechicken.multipart.api.MultipartType;
import java.nio.file.Paths;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CBMicroblockModContent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registry.f_122904_, (String)"cb_microblock");
    private static final DeferredRegister<MultipartType<?>> MULTIPART_TYPES = DeferredRegister.create((ResourceLocation)new ResourceLocation("cb_multipart", "multipart_types"), (String)"cb_microblock");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registry.f_122915_, (String)"cb_microblock");
    public static final SimpleCreativeTab MICRO_TAB = new SimpleCreativeTab("cb_microblock", () -> ItemMicroBlock.create(1, 2, MicroMaterialRegistry.getMaterial(BlockMicroMaterial.makeMaterialKey(Blocks.f_50440_.m_49966_())))){

        public boolean hasSearchBar() {
            return true;
        }
    };
    public static final RegistryObject<ItemMicroBlock> MICRO_BLOCK_ITEM = ITEMS.register("microblock", () -> new ItemMicroBlock(new Item.Properties().m_41491_((CreativeModeTab)MICRO_TAB)));
    public static final RegistryObject<Item> STONE_ROD_ITEM = ITEMS.register("stone_rod", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
    public static final RegistryObject<SawItem> STONE_SAW = ITEMS.register("stone_saw", () -> new SawItem((Tier)Tiers.STONE, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).setNoRepair()));
    public static final RegistryObject<SawItem> IRON_SAW = ITEMS.register("iron_saw", () -> new SawItem((Tier)Tiers.IRON, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).setNoRepair()));
    public static final RegistryObject<SawItem> DIAMOND_SAW = ITEMS.register("diamond_saw", () -> new SawItem((Tier)Tiers.DIAMOND, new Item.Properties().m_41491_(CreativeModeTab.f_40756_).setNoRepair()));
    public static final RegistryObject<FaceMicroFactory> FACE_MICROBLOCK_PART = MULTIPART_TYPES.register("face", FaceMicroFactory::new);
    public static final RegistryObject<HollowMicroFactory> HOLLOW_MICROBLOCK_PART = MULTIPART_TYPES.register("hollow", HollowMicroFactory::new);
    public static final RegistryObject<CornerMicroFactory> CORNER_MICROBLOCK_PART = MULTIPART_TYPES.register("corner", CornerMicroFactory::new);
    public static final RegistryObject<EdgeMicroFactory> EDGE_MICROBLOCK_PART = MULTIPART_TYPES.register("edge", EdgeMicroFactory::new);
    public static final RegistryObject<PostMicroblockFactory> POST_MICROBLOCK_PART = MULTIPART_TYPES.register("post", PostMicroblockFactory::new);
    public static final RegistryObject<SimpleRecipeSerializer<?>> MICRO_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("microblock", () -> new SimpleRecipeSerializer(MicroRecipe::new));
    @Nullable
    public static Tier MAX_SAW_TIER;

    public static void init() {
        LOCK.lock();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        MULTIPART_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        bus.addGenericListener(MicroMaterial.class, CBMicroblockModContent::onRegisterMicroMaterials);
        bus.addListener(CBMicroblockModContent::onCommonSetup);
        bus.addListener(CBMicroblockModContent::onProcessIMC);
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        Tier tier = null;
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            Tier found = SawItem.getSawTier(item);
            if (found == null || tier != null && !SawItem.isTierGTEQ(found, tier)) continue;
            tier = found;
        }
        MAX_SAW_TIER = tier;
    }

    private static void onProcessIMC(InterModProcessEvent event) {
        CBMicroblockModContent.processIMC(event);
        MicroMaterialConfig.parse(Paths.get("config", "custom-micromaterials.cfg"));
    }

    private static void onRegisterMicroMaterials(RegistryEvent.Register<MicroMaterial> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50069_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50122_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50175_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50228_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50281_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50334_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50387_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50440_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50493_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50546_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50599_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50652_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50705_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50741_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50742_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50743_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50744_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50745_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49992_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49993_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49994_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49995_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152467_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49996_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152468_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49997_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152469_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49998_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_49999_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50000_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50001_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50002_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50003_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50004_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50005_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50006_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50007_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50008_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50009_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50010_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50011_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50012_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50013_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50014_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50015_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50043_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50044_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50045_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50046_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50047_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50048_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50049_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50050_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50051_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50052_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50053_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50054_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50055_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152470_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152471_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50056_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50057_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50058_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50059_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152472_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50060_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50062_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50063_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50064_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50041_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50042_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50096_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50097_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50098_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50099_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50100_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50101_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50102_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50103_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50104_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50105_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50106_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50107_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50108_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50109_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50074_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50075_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50076_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50077_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50078_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50079_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50080_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50089_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152474_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50090_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50091_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50173_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152473_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50126_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50127_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50129_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50133_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50134_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50135_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50136_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50137_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50138_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50141_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50143_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50144_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50147_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50148_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50202_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50203_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50204_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50205_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50206_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50207_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50208_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50209_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50210_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50211_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50212_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50213_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50214_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50215_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50222_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50223_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50224_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50225_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50180_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50181_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50182_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50186_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50195_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50197_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50259_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial((BlockState)Blocks.f_50261_.m_49966_().m_61124_((Property)RedstoneLampBlock.f_55654_, (Comparable)Boolean.valueOf(true))));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50264_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152479_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50268_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50330_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50331_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50333_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50282_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50283_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50287_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50288_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50289_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50290_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50291_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50292_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50293_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50294_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50295_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50296_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50297_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50298_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50299_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50300_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50301_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50302_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50374_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50377_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50378_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50379_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50386_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50335_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50352_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50353_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50354_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50394_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50395_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50396_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50470_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50471_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50472_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50473_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50492_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50441_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50443_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152481_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50450_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50451_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50452_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50453_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50526_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50527_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50528_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50529_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50530_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50531_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50532_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50533_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50534_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50535_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50536_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50537_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50538_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50539_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50540_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50541_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50542_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50543_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50544_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50545_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50494_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50495_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50496_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50497_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50498_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50499_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50500_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50501_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50502_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50503_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50504_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50505_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50506_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50507_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50508_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50509_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50510_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50511_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50512_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50513_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50514_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50515_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50516_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50517_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50518_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50519_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50573_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50574_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50577_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50579_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50580_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50581_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50582_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50583_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50584_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50585_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50586_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50587_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50588_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50568_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50690_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50692_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50699_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50655_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50656_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50719_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50720_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50721_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50722_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50723_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50729_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50730_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50734_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50735_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50736_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50737_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50706_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50712_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50713_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_50714_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152490_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152496_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152497_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152498_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152501_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152502_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152503_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152504_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152505_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152506_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152507_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152508_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152509_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152510_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152571_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152572_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152573_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152574_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152575_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152576_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152577_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152578_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152537_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152549_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152550_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152551_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152555_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152559_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152589_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152593_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152594_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152595_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152597_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152598_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152599_));
        r.register((IForgeRegistryEntry)new BlockMicroMaterial(Blocks.f_152600_));
    }

    private static void processIMC(InterModProcessEvent event) {
        ForgeRegistry registry = (ForgeRegistry)MicroMaterialRegistry.MICRO_MATERIALS;
        registry.unfreeze();
        event.getIMCStream().forEach(e -> {
            BlockMicroMaterial material;
            if (!e.method().equals("micro_material")) {
                return;
            }
            String sender = e.senderModId();
            Object sent = e.messageSupplier().get();
            if (sent instanceof Block) {
                Block b = (Block)sent;
                material = new BlockMicroMaterial(b);
            } else if (sent instanceof BlockState) {
                BlockState s = (BlockState)sent;
                material = new BlockMicroMaterial(s);
            } else {
                LOGGER.error("Mod {} tried to register a MicroMaterial with an invalid message. Object: '{}', Class: '{}'. IMC only supports Block or BlockState messages.", (Object)sender, sent, sent != null ? sent.getClass().getName() : null);
                return;
            }
            if (registry.containsKey(material.getRegistryName())) {
                LOGGER.warn("Mod '{}' tried to register a duplicate MicroMaterial. '{}'. Ignoring.", (Object)sender, (Object)material.getRegistryName());
                return;
            }
            registry.register((IForgeRegistryEntry)material);
        });
        registry.freeze();
    }
}

