/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.MicroMaterialClient;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.part.MicroblockPart;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.part.StandardMicroblockPart;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.world.item.ItemStack;

public class MicroblockItemRenderer
implements IItemRenderer {
    public void renderItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay) {
        MicroMaterial material = ItemMicroBlock.getMaterialFromStack(stack);
        StandardMicroFactory factory = ItemMicroBlock.getFactory(stack);
        int size = ItemMicroBlock.getSize(stack);
        if (material == null || factory == null) {
            return;
        }
        MicroMaterialClient clientMaterial = MicroMaterialClient.get(material);
        if (clientMaterial == null) {
            return;
        }
        StandardMicroblockPart part = factory.create(true, material);
        part.setShape(size, factory.getItemSlot());
        mStack.m_85836_();
        Vector3 offset = Vector3.CENTER.copy().subtract(part.getBounds().center());
        mStack.m_85837_(offset.x, offset.y, offset.z);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        RenderType layer = clientMaterial.getItemRenderLayer();
        ccrs.bind(layer, buffers, mStack);
        clientMaterial.renderCuboids(ccrs, null, ((MicroblockPart)part).getRenderCuboids(true));
        clientMaterial.renderDynamic(part, transformType, mStack, buffers, packedLight, packedOverlay, 0.0f);
        mStack.m_85849_();
    }

    public ModelState getModelTransform() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }
}

