/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.core.definitions.AEBlocks;
import appeng.server.ISubCommand;
import com.google.common.math.StatsAccumulator;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public class TestOreGenCommand
implements ISubCommand {
    private final BlockState quartzOre = AEBlocks.QUARTZ_ORE.block().m_49966_();
    private final BlockState deepslateQuartzOre = AEBlocks.DEEPSLATE_QUARTZ_ORE.block().m_49966_();

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> data, CommandSourceStack sender) {
        BlockPos center;
        ServerLevel level;
        int radius = 1000;
        try {
            ServerPlayer player = sender.m_81375_();
            level = player.m_183503_();
            center = new BlockPos(player.m_20185_(), 0.0, player.m_20189_());
        }
        catch (CommandSyntaxException e) {
            level = srv.m_129880_(Level.f_46428_);
            center = level.m_8900_();
        }
        ChunkPos tl = new ChunkPos(center.m_142082_(-radius, 0, -radius));
        ChunkPos br = new ChunkPos(center.m_142082_(radius, 0, radius));
        Stats stats = new Stats();
        for (int cx = tl.f_45578_; cx <= br.f_45578_; ++cx) {
            for (int cz = tl.f_45579_; cz <= br.f_45579_; ++cz) {
                ChunkPos cp = new ChunkPos(cx, cz);
                this.checkChunk(sender, level, cp, stats);
            }
        }
        TestOreGenCommand.sendLine(sender, "Checked %d chunks", stats.chunks.size());
        AggregatedStats oreCount = AggregatedStats.create(stats.chunks, cs -> cs.quartzOreCount);
        List chunksWithOre = stats.chunks.stream().filter(c -> c.quartzOreCount > 0).collect(Collectors.toList());
        AggregatedStats minHeight = AggregatedStats.create(chunksWithOre, cs -> cs.minHeight);
        AggregatedStats maxHeight = AggregatedStats.create(chunksWithOre, cs -> cs.maxHeight);
        TestOreGenCommand.sendLine(sender, "  Normal Quartz Ore: %s", oreCount);
        TestOreGenCommand.sendLine(sender, "  Min-Height: %s", minHeight);
        TestOreGenCommand.sendLine(sender, "  Max-Height: %s", maxHeight);
        AggregatedStats deepslateOreCount = AggregatedStats.create(stats.chunks, cs -> cs.deepslateQuartzOreCount);
        List chunksWithDeeepslateOre = stats.chunks.stream().filter(c -> c.deepslateQuartzOreCount > 0).collect(Collectors.toList());
        AggregatedStats deepslateMinHeight = AggregatedStats.create(chunksWithDeeepslateOre, cs -> cs.deepslateMinHeight);
        AggregatedStats deepslateMaxHeight = AggregatedStats.create(chunksWithDeeepslateOre, cs -> cs.deepslateMaxHeight);
        TestOreGenCommand.sendLine(sender, "  Deepslate Quartz Ore: %s", deepslateOreCount);
        TestOreGenCommand.sendLine(sender, "  Min-Height: %s", deepslateMinHeight);
        TestOreGenCommand.sendLine(sender, "  Max-Height: %s", deepslateMaxHeight);
    }

    private void checkChunk(CommandSourceStack sender, ServerLevel level, ChunkPos cp, Stats stats) {
        ChunkAccess chunk = level.m_6522_(cp.f_45578_, cp.f_45579_, ChunkStatus.f_62326_, false);
        if (chunk == null) {
            TestOreGenCommand.sendLine(sender, "Skipping chunk %s", cp);
            return;
        }
        ChunkStats chunkStats = new ChunkStats();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        TestOreGenCommand.sendLine(sender, "Checking chunk %s", cp);
        for (int x = cp.m_45604_(); x <= cp.m_45608_(); ++x) {
            blockPos.m_142451_(x);
            for (int z = cp.m_45605_(); z <= cp.m_45609_(); ++z) {
                blockPos.m_142443_(z);
                for (int y = level.m_141937_(); y < level.m_141928_(); ++y) {
                    blockPos.m_142448_(y);
                    BlockState state = chunk.m_8055_((BlockPos)blockPos);
                    if (state == this.quartzOre) {
                        chunkStats.minHeight = Math.min(chunkStats.minHeight, y);
                        chunkStats.maxHeight = Math.max(chunkStats.maxHeight, y);
                        ++chunkStats.quartzOreCount;
                        continue;
                    }
                    if (state != this.deepslateQuartzOre) continue;
                    chunkStats.deepslateMinHeight = Math.min(chunkStats.deepslateMinHeight, y);
                    chunkStats.deepslateMaxHeight = Math.max(chunkStats.deepslateMaxHeight, y);
                    ++chunkStats.deepslateQuartzOreCount;
                }
            }
        }
        stats.chunks.add(chunkStats);
    }

    private static void sendLine(CommandSourceStack sender, String text, Object ... args) {
        sender.m_81354_((Component)new TextComponent(String.format(Locale.ROOT, text, args)), true);
    }

    private static class Stats {
        public final List<ChunkStats> chunks = new ArrayList<ChunkStats>();

        private Stats() {
        }
    }

    private static class AggregatedStats {
        public final double min;
        public final double max;
        public final double mean;
        public final double stdDev;

        public AggregatedStats(double min, double max, double mean, double stdDev) {
            this.min = min;
            this.max = max;
            this.mean = mean;
            this.stdDev = stdDev;
        }

        public static <T> AggregatedStats create(List<T> values, ToDoubleFunction<T> getter) {
            if (values.isEmpty()) {
                return new AggregatedStats(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            }
            StatsAccumulator accumulator = new StatsAccumulator();
            for (T value : values) {
                accumulator.add(getter.applyAsDouble(value));
            }
            return new AggregatedStats(accumulator.min(), accumulator.max(), accumulator.mean(), accumulator.populationStandardDeviation());
        }

        public String toString() {
            if (Double.isNaN(this.min)) {
                return "Invalid";
            }
            return String.format(Locale.ROOT, "min=%.2f, max=%.2f, mean=%.2f, stdDev=%.2f", this.min, this.max, this.mean, this.stdDev);
        }
    }

    private static class ChunkStats {
        public int quartzOreCount = 0;
        public int minHeight = Integer.MAX_VALUE;
        public int maxHeight = Integer.MIN_VALUE;
        public int deepslateQuartzOreCount = 0;
        public int deepslateMinHeight = Integer.MAX_VALUE;
        public int deepslateMaxHeight = Integer.MIN_VALUE;

        private ChunkStats() {
        }
    }
}

