/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.jozufozu.flywheel.util.DiffuseLightCalculator;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.outliner.Outliner;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.element.PonderElement;
import com.simibubi.create.foundation.ponder.element.PonderOverlayElement;
import com.simibubi.create.foundation.ponder.element.PonderSceneElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.HideAllInstruction;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.ponder.ui.PonderUI;
import com.simibubi.create.foundation.render.ForcedDiffuseState;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class PonderScene {
    public static final String TITLE_KEY = "header";
    private boolean finished;
    private int textIndex;
    ResourceLocation sceneId;
    private IntList keyframeTimes;
    List<PonderInstruction> schedule;
    private List<PonderInstruction> activeSchedule;
    private Map<UUID, PonderElement> linkedElements;
    private Set<PonderElement> elements;
    private List<PonderTag> tags;
    private PonderWorld world;
    private String namespace;
    private ResourceLocation component;
    private SceneTransform transform;
    private SceneCamera camera;
    private Outliner outliner;
    private Vec3 pointOfInterest;
    private Vec3 chasingPointOfInterest;
    private WorldSectionElement baseWorldSection;
    @Nullable
    private Entity renderViewEntity;
    int basePlateOffsetX;
    int basePlateOffsetZ;
    int basePlateSize;
    float scaleFactor;
    float yOffset;
    boolean hidePlatformShadow;
    private boolean stoppedCounting;
    private int totalTime;
    private int currentTime;

    public PonderScene(PonderWorld world, String namespace, ResourceLocation component, Collection<PonderTag> tags) {
        if (world != null) {
            world.scene = this;
        }
        this.pointOfInterest = Vec3.f_82478_;
        this.textIndex = 1;
        this.hidePlatformShadow = false;
        this.world = world;
        this.namespace = namespace;
        this.component = component;
        this.outliner = new Outliner();
        this.elements = new HashSet<PonderElement>();
        this.linkedElements = new HashMap<UUID, PonderElement>();
        this.tags = new ArrayList<PonderTag>(tags);
        this.schedule = new ArrayList<PonderInstruction>();
        this.activeSchedule = new ArrayList<PonderInstruction>();
        this.transform = new SceneTransform();
        this.basePlateSize = this.getBounds().m_71056_();
        this.camera = new SceneCamera();
        this.baseWorldSection = new WorldSectionElement();
        this.renderViewEntity = world != null ? new ArmorStand((Level)world, 0.0, 0.0, 0.0) : null;
        this.keyframeTimes = new IntArrayList(4);
        this.scaleFactor = 1.0f;
        this.yOffset = 0.0f;
        this.setPointOfInterest(new Vec3(0.0, 4.0, 0.0));
    }

    public void deselect() {
        this.forEach(WorldSectionElement.class, WorldSectionElement::resetSelectedBlock);
    }

    public Pair<ItemStack, BlockPos> rayTraceScene(Vec3 from, Vec3 to) {
        MutableObject nearestHit = new MutableObject();
        MutableDouble bestDistance = new MutableDouble(0.0);
        this.forEach(WorldSectionElement.class, wse -> {
            wse.resetSelectedBlock();
            if (!wse.isVisible()) {
                return;
            }
            Pair<Vec3, BlockHitResult> rayTrace = wse.rayTrace(this.world, from, to);
            if (rayTrace == null) {
                return;
            }
            double distanceTo = rayTrace.getFirst().m_82554_(from);
            if (nearestHit.getValue() != null && distanceTo >= bestDistance.getValue()) {
                return;
            }
            nearestHit.setValue(Pair.of(wse, rayTrace));
            bestDistance.setValue(distanceTo);
        });
        if (nearestHit.getValue() == null) {
            return Pair.of(ItemStack.f_41583_, null);
        }
        Pair selectedHit = (Pair)((Pair)nearestHit.getValue()).getSecond();
        BlockPos selectedPos = ((BlockHitResult)selectedHit.getSecond()).m_82425_();
        BlockPos origin = new BlockPos(this.basePlateOffsetX, 0, this.basePlateOffsetZ);
        if (!this.world.getBounds().m_71051_((Vec3i)selectedPos)) {
            return Pair.of(ItemStack.f_41583_, null);
        }
        if (BoundingBox.m_162375_((Vec3i)origin, (Vec3i)origin.m_141952_(new Vec3i(this.basePlateSize - 1, 0, this.basePlateSize - 1))).m_71051_((Vec3i)selectedPos)) {
            if (PonderIndex.editingModeActive()) {
                ((WorldSectionElement)((Pair)nearestHit.getValue()).getFirst()).selectBlock(selectedPos);
            }
            return Pair.of(ItemStack.f_41583_, selectedPos);
        }
        ((WorldSectionElement)((Pair)nearestHit.getValue()).getFirst()).selectBlock(selectedPos);
        BlockState blockState = this.world.m_8055_(selectedPos);
        Direction direction = ((BlockHitResult)selectedHit.getSecond()).m_82434_();
        Vec3 location = ((BlockHitResult)selectedHit.getSecond()).m_82450_();
        ItemStack pickBlock = blockState.getCloneItemStack((HitResult)new BlockHitResult(location, direction, selectedPos, true), (BlockGetter)this.world, selectedPos, (Player)Minecraft.m_91087_().f_91074_);
        return Pair.of(pickBlock, selectedPos);
    }

    public void reset() {
        this.currentTime = 0;
        this.activeSchedule.clear();
        this.schedule.forEach((? super T mdi) -> mdi.reset(this));
    }

    public void begin() {
        this.reset();
        this.forEach(pe -> pe.reset(this));
        this.world.restore();
        this.elements.clear();
        this.linkedElements.clear();
        this.keyframeTimes.clear();
        this.transform = new SceneTransform();
        this.finished = false;
        this.setPointOfInterest(new Vec3(0.0, 4.0, 0.0));
        this.baseWorldSection.setEmpty();
        this.baseWorldSection.forceApplyFade(1.0f);
        this.elements.add(this.baseWorldSection);
        this.totalTime = 0;
        this.stoppedCounting = false;
        this.activeSchedule.addAll(this.schedule);
        this.activeSchedule.forEach((? super T i) -> i.onScheduled(this));
    }

    public WorldSectionElement getBaseWorldSection() {
        return this.baseWorldSection;
    }

    public float getSceneProgress() {
        return this.totalTime == 0 ? 0.0f : (float)this.currentTime / (float)this.totalTime;
    }

    public void fadeOut() {
        this.reset();
        this.activeSchedule.add(new HideAllInstruction(10, null));
    }

    public void renderScene(SuperRenderTypeBuffer buffer, PoseStack ms, float pt) {
        ForcedDiffuseState.pushCalculator(DiffuseLightCalculator.DEFAULT);
        ms.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        Entity prevRVE = mc.f_91075_;
        mc.f_91075_ = this.renderViewEntity;
        this.forEachVisible(PonderSceneElement.class, e -> e.renderFirst(this.world, buffer, ms, pt));
        mc.f_91075_ = prevRVE;
        for (RenderType type : RenderType.m_110506_()) {
            this.forEachVisible(PonderSceneElement.class, e -> e.renderLayer(this.world, buffer, type, ms, pt));
        }
        this.forEachVisible(PonderSceneElement.class, e -> e.renderLast(this.world, buffer, ms, pt));
        this.camera.set(this.transform.xRotation.getValue(pt) + 90.0f, this.transform.yRotation.getValue(pt) + 180.0f);
        this.world.renderEntities(ms, buffer, this.camera, pt);
        this.world.renderParticles(ms, buffer, this.camera, pt);
        this.outliner.renderOutlines(ms, buffer, Vec3.f_82478_, pt);
        ms.m_85849_();
        ForcedDiffuseState.popCalculator();
    }

    public void renderOverlay(PonderUI screen, PoseStack ms, float partialTicks) {
        ms.m_85836_();
        this.forEachVisible(PonderOverlayElement.class, e -> e.render(this, screen, ms, partialTicks));
        ms.m_85849_();
    }

    public void setPointOfInterest(Vec3 poi) {
        if (this.chasingPointOfInterest == null) {
            this.pointOfInterest = poi;
        }
        this.chasingPointOfInterest = poi;
    }

    public Vec3 getPointOfInterest() {
        return this.pointOfInterest;
    }

    public void tick() {
        if (this.chasingPointOfInterest != null) {
            this.pointOfInterest = VecHelper.lerp(0.25f, this.pointOfInterest, this.chasingPointOfInterest);
        }
        this.outliner.tickOutlines();
        this.world.tick();
        this.transform.tick();
        this.forEach(e -> e.tick(this));
        if (this.currentTime < this.totalTime) {
            ++this.currentTime;
        }
        Iterator<PonderInstruction> iterator = this.activeSchedule.iterator();
        while (iterator.hasNext()) {
            PonderInstruction instruction = iterator.next();
            instruction.tick(this);
            if (instruction.isComplete()) {
                iterator.remove();
                if (!instruction.isBlocking()) continue;
                break;
            }
            if (!instruction.isBlocking()) continue;
            break;
        }
        if (this.activeSchedule.isEmpty()) {
            this.finished = true;
        }
    }

    public void seekToTime(int time) {
        if (time < this.currentTime) {
            throw new IllegalStateException("Cannot seek backwards. Rewind first.");
        }
        while (this.currentTime < time && !this.finished) {
            this.forEach(e -> e.whileSkipping(this));
            this.tick();
        }
        this.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
    }

    public void addToSceneTime(int time) {
        if (!this.stoppedCounting) {
            this.totalTime += time;
        }
    }

    public void stopCounting() {
        this.stoppedCounting = true;
    }

    public void markKeyframe(int offset) {
        if (!this.stoppedCounting) {
            this.keyframeTimes.add(this.totalTime + offset);
        }
    }

    public void addElement(PonderElement e) {
        this.elements.add(e);
    }

    public <E extends PonderElement> void linkElement(E e, ElementLink<E> link) {
        this.linkedElements.put(link.getId(), e);
    }

    public <E extends PonderElement> E resolve(ElementLink<E> link) {
        return link.cast(this.linkedElements.get(link.getId()));
    }

    public <E extends PonderElement> void runWith(ElementLink<E> link, Consumer<E> callback) {
        callback.accept(this.resolve(link));
    }

    public <E extends PonderElement, F> F applyTo(ElementLink<E> link, Function<E, F> function) {
        return function.apply(this.resolve(link));
    }

    public void forEach(Consumer<? super PonderElement> function) {
        for (PonderElement elemtent : this.elements) {
            function.accept(elemtent);
        }
    }

    public <T extends PonderElement> void forEach(Class<T> type, Consumer<T> function) {
        for (PonderElement element : this.elements) {
            if (!type.isInstance(element)) continue;
            function.accept((PonderElement)type.cast(element));
        }
    }

    public <T extends PonderElement> void forEachVisible(Class<T> type, Consumer<T> function) {
        for (PonderElement element : this.elements) {
            if (!type.isInstance(element) || !element.isVisible()) continue;
            function.accept((PonderElement)type.cast(element));
        }
    }

    public <T extends Entity> void forEachWorldEntity(Class<T> type, Consumer<T> function) {
        this.world.getEntityStream().filter(type::isInstance).map(type::cast).forEach(function);
    }

    public Supplier<String> registerText(String defaultText) {
        String key = "text_" + this.textIndex;
        PonderLocalization.registerSpecific(this.sceneId, key, defaultText);
        Supplier<String> supplier = () -> PonderLocalization.getSpecific(this.sceneId, key);
        ++this.textIndex;
        return supplier;
    }

    public SceneBuilder builder() {
        return new SceneBuilder(this);
    }

    public SceneBuildingUtil getSceneBuildingUtil() {
        return new SceneBuildingUtil(this.getBounds());
    }

    public String getTitle() {
        return this.getString(TITLE_KEY);
    }

    public String getString(String key) {
        return PonderLocalization.getSpecific(this.sceneId, key);
    }

    public PonderWorld getWorld() {
        return this.world;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getKeyframeCount() {
        return this.keyframeTimes.size();
    }

    public int getKeyframeTime(int index) {
        return this.keyframeTimes.getInt(index);
    }

    public List<PonderTag> getTags() {
        return this.tags;
    }

    public ResourceLocation getComponent() {
        return this.component;
    }

    public Set<PonderElement> getElements() {
        return this.elements;
    }

    public BoundingBox getBounds() {
        return this.world == null ? new BoundingBox(BlockPos.f_121853_) : this.world.getBounds();
    }

    public ResourceLocation getId() {
        return this.sceneId;
    }

    public SceneTransform getTransform() {
        return this.transform;
    }

    public Outliner getOutliner() {
        return this.outliner;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getBasePlateOffsetX() {
        return this.basePlateOffsetX;
    }

    public int getBasePlateOffsetZ() {
        return this.basePlateOffsetZ;
    }

    public boolean shouldHidePlatformShadow() {
        return this.hidePlatformShadow;
    }

    public int getBasePlateSize() {
        return this.basePlateSize;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public class SceneTransform {
        public LerpedFloat xRotation = LerpedFloat.angular().disableSmartAngleChasing().startWithValue(-35.0);
        public LerpedFloat yRotation = LerpedFloat.angular().disableSmartAngleChasing().startWithValue(145.0);
        private int width;
        private int height;
        private double offset;
        private Matrix4f cachedMat;

        public void tick() {
            this.xRotation.tickChaser();
            this.yRotation.tickChaser();
        }

        public void updateScreenParams(int width, int height, double offset) {
            this.width = width;
            this.height = height;
            this.offset = offset;
            this.cachedMat = null;
        }

        public PoseStack apply(PoseStack ms) {
            return this.apply(ms, AnimationTickHolder.getPartialTicks((LevelAccessor)PonderScene.this.world));
        }

        public PoseStack apply(PoseStack ms, float pt) {
            ms.m_85837_((double)(this.width / 2), (double)(this.height / 2), 200.0 + this.offset);
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).rotateX(-35.0)).rotateY(55.0)).translate(this.offset, 0.0, 0.0)).rotateY(-55.0)).rotateX(35.0)).rotateX((double)this.xRotation.getValue(pt))).rotateY((double)this.yRotation.getValue(pt));
            UIRenderHelper.flipForGuiRender(ms);
            float f = 30.0f * PonderScene.this.scaleFactor;
            ms.m_85841_(f, f, f);
            ms.m_85837_((double)((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetX), (double)(-1.0f + PonderScene.this.yOffset), (double)((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetZ));
            return ms;
        }

        public void updateSceneRVE(float pt) {
            Vec3 v = this.screenToScene(this.width / 2, this.height / 2, 500, pt);
            if (PonderScene.this.renderViewEntity != null) {
                PonderScene.this.renderViewEntity.m_6034_(v.f_82479_, v.f_82480_, v.f_82481_);
            }
        }

        public Vec3 screenToScene(double x, double y, int depth, float pt) {
            this.refreshMatrix(pt);
            Vec3 vec = new Vec3(x, y, (double)depth);
            vec = vec.m_82492_((double)(this.width / 2), (double)(this.height / 2), 200.0 + this.offset);
            vec = VecHelper.rotate(vec, 35.0, Direction.Axis.X);
            vec = VecHelper.rotate(vec, -55.0, Direction.Axis.Y);
            vec = vec.m_82492_(this.offset, 0.0, 0.0);
            vec = VecHelper.rotate(vec, 55.0, Direction.Axis.Y);
            vec = VecHelper.rotate(vec, -35.0, Direction.Axis.X);
            vec = VecHelper.rotate(vec, -this.xRotation.getValue(pt), Direction.Axis.X);
            vec = VecHelper.rotate(vec, -this.yRotation.getValue(pt), Direction.Axis.Y);
            float f = 1.0f / (30.0f * PonderScene.this.scaleFactor);
            vec = vec.m_82542_((double)f, (double)(-f), (double)f);
            vec = vec.m_82492_((double)((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetX), (double)(-1.0f + PonderScene.this.yOffset), (double)((float)PonderScene.this.basePlateSize / -2.0f - (float)PonderScene.this.basePlateOffsetZ));
            return vec;
        }

        public Vec2 sceneToScreen(Vec3 vec, float pt) {
            this.refreshMatrix(pt);
            Vector4f vec4 = new Vector4f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_, 1.0f);
            vec4.m_123607_(this.cachedMat);
            return new Vec2(vec4.m_123601_(), vec4.m_123615_());
        }

        protected void refreshMatrix(float pt) {
            if (this.cachedMat != null) {
                return;
            }
            this.cachedMat = this.apply(new PoseStack(), pt).m_85850_().m_85861_();
        }
    }

    public class SceneCamera
    extends Camera {
        public void set(float xRotation, float yRotation) {
            this.m_90572_(yRotation, xRotation);
        }
    }
}

