/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class TrainCollisionPacket
extends SimplePacketBase {
    int damage;
    int contraptionEntityId;

    public TrainCollisionPacket(int damage, int contraptionEntityId) {
        this.damage = damage;
        this.contraptionEntityId = contraptionEntityId;
    }

    public TrainCollisionPacket(FriendlyByteBuf buffer) {
        this.contraptionEntityId = buffer.readInt();
        this.damage = buffer.readInt();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.contraptionEntityId);
        buffer.writeInt(this.damage);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            Level level = player.f_19853_;
            Entity entity = level.m_6815_(this.contraptionEntityId);
            if (!(entity instanceof CarriageContraptionEntity)) {
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            player.m_6469_((DamageSource)new EntityDamageSource("create.run_over", (Entity)cce), (float)this.damage);
            player.f_19853_.m_5594_((Player)player, entity.m_142538_(), SoundEvents.f_12313_, SoundSource.NEUTRAL, 1.0f, 0.75f);
        });
        return true;
    }
}

