/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllInteractionBehaviours;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlock;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.ChassisBlockEntity;
import com.simibubi.create.content.contraptions.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.gantry.GantryCarriageBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import com.simibubi.create.content.contraptions.render.EmptyLighter;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.gantry.GantryShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.ICoordinate;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.NBTProcessors;
import com.simibubi.create.foundation.utility.UniqueLinkedList;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class Contraption {
    public Optional<List<AABB>> simplifiedEntityColliders;
    public AbstractContraptionEntity entity;
    public AABB bounds;
    public BlockPos anchor;
    public boolean stalled;
    public boolean hasUniversalCreativeCrate;
    public boolean disassembled;
    protected Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
    protected List<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> actors;
    protected Map<BlockPos, MovingInteractionBehaviour> interactors;
    protected List<ItemStack> disabledActors;
    protected List<AABB> superglue;
    protected List<BlockPos> seats = new ArrayList<BlockPos>();
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    protected MountedStorageManager storage;
    private Set<SuperGlueEntity> glueToRemove;
    private Map<BlockPos, Entity> initialPassengers;
    private List<BlockFace> pendingSubContraptions;
    private CompletableFuture<Void> simplifiedEntityColliderProvider;
    public Map<BlockPos, IModelData> modelData;
    public Map<BlockPos, BlockEntity> presentBlockEntities;
    public List<BlockEntity> maybeInstancedBlockEntities;
    public List<BlockEntity> specialRenderedBlockEntities;
    protected ContraptionWorld world;
    public boolean deferInvalidate;

    public Contraption() {
        this.actors = new ArrayList<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>>();
        this.disabledActors = new ArrayList<ItemStack>();
        this.modelData = new HashMap<BlockPos, IModelData>();
        this.interactors = new HashMap<BlockPos, MovingInteractionBehaviour>();
        this.superglue = new ArrayList<AABB>();
        this.seatMapping = new HashMap<UUID, Integer>();
        this.glueToRemove = new HashSet<SuperGlueEntity>();
        this.initialPassengers = new HashMap<BlockPos, Entity>();
        this.presentBlockEntities = new HashMap<BlockPos, BlockEntity>();
        this.maybeInstancedBlockEntities = new ArrayList<BlockEntity>();
        this.specialRenderedBlockEntities = new ArrayList<BlockEntity>();
        this.pendingSubContraptions = new ArrayList<BlockFace>();
        this.stabilizedSubContraptions = new HashMap<UUID, BlockFace>();
        this.simplifiedEntityColliders = Optional.empty();
        this.storage = new MountedStorageManager();
    }

    public ContraptionWorld getContraptionWorld() {
        if (this.world == null) {
            this.world = new ContraptionWorld(this.entity.f_19853_, this);
        }
        return this.world;
    }

    public abstract boolean assemble(Level var1, BlockPos var2) throws AssemblyException;

    public abstract boolean canBeStabilized(Direction var1, BlockPos var2);

    public abstract ContraptionType getType();

    protected boolean customBlockPlacement(LevelAccessor world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean customBlockRemoval(LevelAccessor world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean addToInitialFrontier(Level world, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) throws AssemblyException {
        return true;
    }

    public static Contraption fromNBT(Level world, CompoundTag nbt, boolean spawnData) {
        String type = nbt.m_128461_("Type");
        Contraption contraption = ContraptionType.fromType(type);
        contraption.readNBT(world, nbt, spawnData);
        contraption.world = new ContraptionWorld(world, contraption);
        contraption.gatherBBsOffThread();
        return contraption;
    }

    public boolean searchMovedStructure(Level world, BlockPos pos, @Nullable Direction forcedDirection) throws AssemblyException {
        this.initialPassengers.clear();
        UniqueLinkedList<BlockPos> frontier = new UniqueLinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new AABB(BlockPos.f_121853_);
        }
        if (!BlockMovementChecks.isBrittle(world.m_8055_(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, forcedDirection, frontier, visited)) continue;
            return false;
        }
        throw AssemblyException.structureTooLarge();
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;
        for (BlockFace blockFace : this.pendingSubContraptions) {
            Direction face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            Level world = entity.f_19853_;
            BlockPos pos = blockFace.getPos();
            try {
                if (!subContraption.assemble(world, pos)) {
                }
            }
            catch (AssemblyException e) {}
            continue;
            subContraption.removeBlocksFromWorld(world, BlockPos.f_121853_);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, face);
            BlockPos anchor = blockFace.getConnectedPos();
            movedContraption.m_6034_((float)anchor.m_123341_() + 0.5f, anchor.m_123342_(), (float)anchor.m_123343_() + 0.5f);
            world.m_7967_((Entity)movedContraption);
            this.stabilizedSubContraptions.put(movedContraption.m_142081_(), new BlockFace(this.toLocalPos(pos), face));
        }
        this.storage.createHandlers();
        this.gatherBBsOffThread();
    }

    public void onEntityRemoved(AbstractContraptionEntity entity) {
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
            this.simplifiedEntityColliderProvider = null;
        }
    }

    public void onEntityInitialize(Level world, AbstractContraptionEntity contraptionEntity) {
        if (world.f_46443_) {
            return;
        }
        for (OrientedContraptionEntity orientedCE : world.m_45976_(OrientedContraptionEntity.class, contraptionEntity.m_142469_().m_82400_(1.0))) {
            if (!this.stabilizedSubContraptions.containsKey(orientedCE.m_142081_())) continue;
            orientedCE.m_20329_(contraptionEntity);
        }
        for (BlockPos seatPos : this.getSeats()) {
            int seatIndex;
            Entity passenger = this.initialPassengers.get(seatPos);
            if (passenger == null || (seatIndex = this.getSeats().indexOf(seatPos)) == -1) continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    protected boolean moveBlock(Level world, @Nullable Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        Direction offset;
        Object attached;
        BlockEntity blockEntity;
        BlockPos pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (world.m_151570_(pos)) {
            return true;
        }
        if (!world.m_46749_(pos)) {
            throw AssemblyException.unloadedChunk(pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return true;
        }
        if (!this.movementAllowed(state, world, pos)) {
            throw AssemblyException.unmovableBlock(pos, state);
        }
        if (state.m_60734_() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (AllBlocks.BELT.has(state)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state) && (blockEntity = world.m_7702_(pos)) instanceof WindmillBearingBlockEntity) {
            WindmillBearingBlockEntity wbbe = (WindmillBearingBlockEntity)blockEntity;
            wbbe.disassembleForMovement();
        }
        if (AllBlocks.GANTRY_CARRIAGE.has(state)) {
            this.moveGantryPinion(world, pos, frontier, visited, state);
        }
        if (AllBlocks.GANTRY_SHAFT.has(state)) {
            this.moveGantryShaft(world, pos, frontier, visited, state);
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.m_61143_((Property)StickerBlock.EXTENDED)).booleanValue() && !visited.contains(attached = pos.m_142300_(offset = (Direction)state.m_61143_((Property)StickerBlock.f_52588_))) && !BlockMovementChecks.isNotSupportive(world.m_8055_((BlockPos)attached), offset.m_122424_())) {
            frontier.add((BlockPos)attached);
        }
        if (state.m_61138_((Property)ChestBlock.f_51479_) && state.m_61138_((Property)ChestBlock.f_51478_) && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE && !visited.contains(attached = pos.m_142300_(offset = ChestBlock.m_51584_((BlockState)state)))) {
            frontier.add((BlockPos)attached);
        }
        if ((attached = state.m_60734_()) instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)attached;
            for (Direction d : bogey.getStickySurfaces((BlockGetter)world, pos, state)) {
                if (visited.contains(pos.m_142300_(d))) continue;
                frontier.add(pos.m_142300_(d));
            }
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (AllBlocks.WINDMILL_BEARING.has(state)) {
            this.moveWindmillBearing(pos, frontier, visited, state);
        }
        if (state.m_60734_() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.m_60734_() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.m_60734_() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            return false;
        }
        if (MechanicalPistonBlock.isExtensionPole(state)) {
            this.movePistonPole(world, pos, frontier, visited, state);
        }
        if (MechanicalPistonBlock.isPistonHead(state)) {
            this.movePistonHead(world, pos, frontier, visited, state);
        }
        BlockPos posDown = pos.m_7495_();
        BlockState stateBelow = world.m_8055_(posDown);
        if (!visited.contains(posDown) && AllBlocks.CART_ASSEMBLER.has(stateBelow)) {
            frontier.add(posDown);
        }
        for (Direction offset2 : Iterate.directions) {
            boolean canStick;
            BlockPos offsetPos = pos.m_142300_(offset2);
            BlockState blockState = world.m_8055_(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(blockState, world, offsetPos)) {
                if (offset2 != forcedDirection) continue;
                throw AssemblyException.unmovableBlock(pos, state);
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = SuperGlueEntity.isGlued((LevelAccessor)world, pos, offset2, this.glueToRemove);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards(blockState, world, offsetPos, offset2.m_122424_());
            boolean brittle = BlockMovementChecks.isBrittle(blockState);
            boolean bl = canStick = !brittle && state.canStickTo(blockState) && blockState.canStickTo(state);
            if (canStick) {
                if (state.m_60811_() == PushReaction.PUSH_ONLY || blockState.m_60811_() == PushReaction.PUSH_ONLY) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(state, offset2)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(blockState, offset2.m_122424_())) {
                    canStick = false;
                }
            }
            if (wasVisited || !canStick && !blockAttachedTowardsFace && !faceHasGlue && (offset2 != forcedDirection || BlockMovementChecks.isNotSupportive(state, forcedDirection))) continue;
            frontier.add(offsetPos);
        }
        this.addBlock(pos, this.capture(world, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    protected void movePistonHead(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos attached;
        Direction direction = (Direction)state.m_61143_((Property)MechanicalPistonHeadBlock.f_52588_);
        BlockPos offset = pos.m_142300_(direction.m_122424_());
        if (!visited.contains(offset)) {
            Direction pistonFacing;
            BlockState blockState = world.m_8055_(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((Direction)blockState.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_() == direction.m_122434_()) {
                frontier.add(offset);
            }
            if (blockState.m_60734_() instanceof MechanicalPistonBlock && (pistonFacing = (Direction)blockState.m_61143_((Property)MechanicalPistonBlock.FACING)) == direction && blockState.m_61143_(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
                frontier.add(offset);
            }
        }
        if (state.m_61143_(MechanicalPistonHeadBlock.TYPE) == PistonType.STICKY && !visited.contains(attached = pos.m_142300_(direction))) {
            frontier.add(attached);
        }
    }

    protected void movePistonPole(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (Direction d : Iterate.directionsInAxis(((Direction)state.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_())) {
            Direction pistonFacing;
            BlockPos offset = pos.m_142300_(d);
            if (visited.contains(offset)) continue;
            BlockState blockState = world.m_8055_(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((Direction)blockState.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_() == d.m_122434_()) {
                frontier.add(offset);
            }
            if (MechanicalPistonBlock.isPistonHead(blockState) && ((Direction)blockState.m_61143_((Property)MechanicalPistonHeadBlock.f_52588_)).m_122434_() == d.m_122434_()) {
                frontier.add(offset);
            }
            if (!(blockState.m_60734_() instanceof MechanicalPistonBlock) || (pistonFacing = (Direction)blockState.m_61143_((Property)MechanicalPistonBlock.FACING)) != d && (pistonFacing != d.m_122424_() || blockState.m_61143_(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.EXTENDED)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryPinion(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos offset = pos.m_142300_((Direction)state.m_61143_((Property)GantryCarriageBlock.FACING));
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
        Direction.Axis rotationAxis = ((IRotate)state.m_60734_()).getRotationAxis(state);
        for (Direction d : Iterate.directionsInAxis(rotationAxis)) {
            offset = pos.m_142300_(d);
            BlockState offsetState = world.m_8055_(offset);
            if (!AllBlocks.GANTRY_SHAFT.has(offsetState) || ((Direction)offsetState.m_61143_((Property)GantryShaftBlock.FACING)).m_122434_() != d.m_122434_() || visited.contains(offset)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryShaft(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (Direction d : Iterate.directions) {
            BlockPos offset = pos.m_142300_(d);
            if (visited.contains(offset)) continue;
            BlockState offsetState = world.m_8055_(offset);
            Direction facing = (Direction)state.m_61143_((Property)GantryShaftBlock.FACING);
            if (d.m_122434_() == facing.m_122434_() && AllBlocks.GANTRY_SHAFT.has(offsetState) && offsetState.m_61143_((Property)GantryShaftBlock.FACING) == facing) {
                frontier.add(offset);
                continue;
            }
            if (!AllBlocks.GANTRY_CARRIAGE.has(offsetState) || offsetState.m_61143_((Property)GantryCarriageBlock.FACING) != d) continue;
            frontier.add(offset);
        }
    }

    private void moveWindmillBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)WindmillBearingBlock.FACING);
        BlockPos offset = pos.m_142300_(facing);
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
    }

    private void moveBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)MechanicalBearingBlock.FACING);
        if (!this.canBeStabilized(facing, pos.m_141950_((Vec3i)this.anchor))) {
            BlockPos offset = pos.m_142300_(facing);
            if (!visited.contains(offset)) {
                frontier.add(offset);
            }
            return;
        }
        this.pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        BlockPos prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos)) {
            frontier.add(nextPos);
        }
        if (prevPos != null && !visited.contains(prevPos)) {
            frontier.add(prevPos);
        }
    }

    private void moveSeat(Level world, BlockPos pos) {
        SeatEntity seat;
        List passengers;
        BlockPos local = this.toLocalPos(pos);
        this.getSeats().add(local);
        List seatsEntities = world.m_45976_(SeatEntity.class, new AABB(pos));
        if (!seatsEntities.isEmpty() && !(passengers = (seat = (SeatEntity)((Object)seatsEntities.get(0))).m_20197_()).isEmpty()) {
            this.initialPassengers.put(local, (Entity)passengers.get(0));
        }
    }

    private void movePulley(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        int limit = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        BlockPos ropePos = pos;
        while (limit-- >= 0 && world.m_46749_(ropePos = ropePos.m_7495_())) {
            BlockState ropeState = world.m_8055_(ropePos);
            Block block = ropeState.m_60734_();
            if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                if (visited.contains(ropePos)) break;
                frontier.add(ropePos);
                break;
            }
            this.addBlock(ropePos, this.capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) throws AssemblyException {
        BlockState poleState;
        Direction direction = (Direction)state.m_61143_((Property)MechanicalPistonBlock.FACING);
        MechanicalPistonBlock.PistonState pistonState = (MechanicalPistonBlock.PistonState)((Object)state.m_61143_(MechanicalPistonBlock.STATE));
        if (pistonState == MechanicalPistonBlock.PistonState.MOVING) {
            return false;
        }
        BlockPos offset = pos.m_142300_(direction.m_122424_());
        if (!visited.contains(offset) && AllBlocks.PISTON_EXTENSION_POLE.has(poleState = world.m_8055_(offset)) && ((Direction)poleState.m_61143_((Property)PistonExtensionPoleBlock.f_52588_)).m_122434_() == direction.m_122434_()) {
            frontier.add(offset);
        }
        if ((pistonState == MechanicalPistonBlock.PistonState.EXTENDED || MechanicalPistonBlock.isStickyPiston(state)) && !visited.contains(offset = pos.m_142300_(direction))) {
            frontier.add(offset);
        }
        return true;
    }

    private boolean moveChassis(Level world, BlockPos pos, Direction movementDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof ChassisBlockEntity)) {
            return false;
        }
        ChassisBlockEntity chassis = (ChassisBlockEntity)be;
        chassis.addAttachedChasses(frontier, visited);
        List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (BlockPos blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        BlockState blockstate = world.m_8055_(pos);
        if (AllBlocks.REDSTONE_CONTACT.has(blockstate)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (AllBlocks.POWERED_SHAFT.has(blockstate)) {
            blockstate = BlockHelper.copyProperties(blockstate, AllBlocks.SHAFT.getDefaultState());
        }
        if (blockstate.m_60734_() instanceof ControlsBlock && this.getType() == ContraptionType.CARRIAGE) {
            blockstate = (BlockState)blockstate.m_61124_((Property)ControlsBlock.OPEN, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.m_61138_((Property)SlidingDoorBlock.VISIBLE)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.m_60734_() instanceof ButtonBlock) {
            blockstate = (BlockState)blockstate.m_61124_((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false));
            world.m_186460_(pos, blockstate.m_60734_(), -1);
        }
        if (blockstate.m_60734_() instanceof PressurePlateBlock) {
            blockstate = (BlockState)blockstate.m_61124_((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false));
            world.m_186460_(pos, blockstate.m_60734_(), -1);
        }
        CompoundTag compoundnbt = this.getBlockEntityNBT(world, pos);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PoweredShaftBlockEntity) {
            blockEntity = AllBlockEntityTypes.BRACKETED_KINETIC.create(pos, blockstate);
        }
        return Pair.of((Object)new StructureTemplate.StructureBlockInfo(pos, blockstate, compoundnbt), (Object)blockEntity);
    }

    protected void addBlock(BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair) {
        MovingInteractionBehaviour interactionBehaviour;
        StructureTemplate.StructureBlockInfo structureBlockInfo;
        StructureTemplate.StructureBlockInfo captured = (StructureTemplate.StructureBlockInfo)pair.getKey();
        BlockPos localPos = pos.m_141950_((Vec3i)this.anchor);
        if (this.blocks.put(localPos, structureBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, captured.f_74676_, captured.f_74677_)) != null) {
            return;
        }
        this.bounds = this.bounds.m_82367_(new AABB(localPos));
        BlockEntity be = (BlockEntity)pair.getValue();
        this.storage.addBlock(localPos, be);
        if (AllMovementBehaviours.getBehaviour(captured.f_74676_) != null) {
            this.actors.add((MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>)MutablePair.of((Object)structureBlockInfo, null));
        }
        if ((interactionBehaviour = AllInteractionBehaviours.getBehaviour(captured.f_74676_)) != null) {
            this.interactors.put(localPos, interactionBehaviour);
        }
        if (be instanceof CreativeCrateBlockEntity && ((CreativeCrateBlockEntity)be).getBehaviour(FilteringBehaviour.TYPE).getFilter().m_41619_()) {
            this.hasUniversalCreativeCrate = true;
        }
    }

    @Nullable
    protected CompoundTag getBlockEntityNBT(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        CompoundTag nbt = blockEntity.m_187480_();
        nbt.m_128473_("x");
        nbt.m_128473_("y");
        nbt.m_128473_("z");
        if ((blockEntity instanceof FluidTankBlockEntity || blockEntity instanceof ItemVaultBlockEntity) && nbt.m_128441_("Controller")) {
            nbt.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.toLocalPos(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Controller")))));
        }
        return nbt;
    }

    protected BlockPos toLocalPos(BlockPos globalPos) {
        return globalPos.m_141950_((Vec3i)this.anchor);
    }

    protected boolean movementAllowed(BlockState state, Level world, BlockPos pos) {
        return BlockMovementChecks.isMovementAllowed(state, world, pos);
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    public void readNBT(Level world, CompoundTag nbt, boolean spawnData) {
        this.blocks.clear();
        this.presentBlockEntities.clear();
        this.specialRenderedBlockEntities.clear();
        Tag blocks = nbt.m_128423_("Blocks");
        boolean usePalettedDeserialization = blocks != null && blocks.m_7060_() == 10 && ((CompoundTag)blocks).m_128441_("Palette");
        this.readBlocksCompound(blocks, world, usePalettedDeserialization);
        this.actors.clear();
        nbt.m_128437_("Actors", 10).forEach(c -> {
            CompoundTag comp = (CompoundTag)c;
            StructureTemplate.StructureBlockInfo info = this.blocks.get(NbtUtils.m_129239_((CompoundTag)comp.m_128469_("Pos")));
            if (info == null) {
                return;
            }
            MovementContext context = MovementContext.readNBT(world, info, comp, this);
            this.getActors().add((MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>)MutablePair.of((Object)info, (Object)context));
        });
        this.disabledActors = NBTHelper.readItemList(nbt.m_128437_("DisabledActors", 10));
        for (ItemStack stack : this.disabledActors) {
            this.setActorsActive(stack, false);
        }
        this.superglue.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("Superglue", 10), c -> this.superglue.add(SuperGlueEntity.readBoundingBox(c)));
        this.seats.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("Seats", 10), c -> this.seats.add(NbtUtils.m_129239_((CompoundTag)c)));
        this.seatMapping.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("Passengers", 10), c -> this.seatMapping.put(NbtUtils.m_129233_((Tag)NBTHelper.getINBT(c, "Id")), c.m_128451_("Seat")));
        this.stabilizedSubContraptions.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("SubContraptions", 10), c -> this.stabilizedSubContraptions.put(c.m_128342_("Id"), BlockFace.fromNBT(c.m_128469_("Location"))));
        this.interactors.clear();
        NBTHelper.iterateCompoundList(nbt.m_128437_("Interactors", 10), c -> {
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos"));
            StructureTemplate.StructureBlockInfo structureBlockInfo = this.getBlocks().get(pos);
            if (structureBlockInfo == null) {
                return;
            }
            MovingInteractionBehaviour behaviour = AllInteractionBehaviours.getBehaviour(structureBlockInfo.f_74676_);
            if (behaviour != null) {
                this.interactors.put(pos, behaviour);
            }
        });
        this.storage.read(nbt, this.presentBlockEntities, spawnData);
        if (nbt.m_128441_("BoundsFront")) {
            this.bounds = NBTHelper.readAABB(nbt.m_128437_("BoundsFront", 5));
        }
        this.stalled = nbt.m_128471_("Stalled");
        this.hasUniversalCreativeCrate = nbt.m_128471_("BottomlessSupply");
        this.anchor = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("Anchor"));
    }

    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Type", this.getType().id);
        CompoundTag blocksNBT = this.writeBlocksCompound();
        ListTag actorsNBT = new ListTag();
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor : this.getActors()) {
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)actor.left).f_74676_);
            if (behaviour == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)((StructureTemplate.StructureBlockInfo)actor.left).f_74675_));
            behaviour.writeExtraData((MovementContext)actor.right);
            ((MovementContext)actor.right).writeToNBT(compoundTag);
            actorsNBT.add((Object)compoundTag);
        }
        ListTag disabledActorsNBT = NBTHelper.writeItemList(this.disabledActors);
        ListTag superglueNBT = new ListTag();
        if (!spawnPacket) {
            for (AABB aABB : this.superglue) {
                CompoundTag c = new CompoundTag();
                SuperGlueEntity.writeBoundingBox(c, aABB);
                superglueNBT.add((Object)c);
            }
        }
        (spawnPacket ? this.getStorageForSpawnPacket() : this.storage).write(nbt, spawnPacket);
        ListTag interactorNBT = new ListTag();
        for (BlockPos pos : this.interactors.keySet()) {
            CompoundTag c = new CompoundTag();
            c.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            interactorNBT.add((Object)c);
        }
        nbt.m_128365_("Seats", (Tag)NBTHelper.writeCompoundList(this.getSeats(), NbtUtils::m_129224_));
        nbt.m_128365_("Passengers", (Tag)NBTHelper.writeCompoundList(this.getSeatMapping().entrySet(), e -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("Id", (Tag)NbtUtils.m_129226_((UUID)((UUID)e.getKey())));
            tag.m_128405_("Seat", ((Integer)e.getValue()).intValue());
            return tag;
        }));
        nbt.m_128365_("SubContraptions", (Tag)NBTHelper.writeCompoundList(this.stabilizedSubContraptions.entrySet(), e -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("Id", (UUID)e.getKey());
            tag.m_128365_("Location", (Tag)((BlockFace)e.getValue()).serializeNBT());
            return tag;
        }));
        nbt.m_128365_("Blocks", (Tag)blocksNBT);
        nbt.m_128365_("Actors", (Tag)actorsNBT);
        nbt.m_128365_("DisabledActors", (Tag)disabledActorsNBT);
        nbt.m_128365_("Interactors", (Tag)interactorNBT);
        nbt.m_128365_("Superglue", (Tag)superglueNBT);
        nbt.m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)this.anchor));
        nbt.m_128379_("Stalled", this.stalled);
        nbt.m_128379_("BottomlessSupply", this.hasUniversalCreativeCrate);
        if (this.bounds != null) {
            ListTag listTag = NBTHelper.writeAABB(this.bounds);
            nbt.m_128365_("BoundsFront", (Tag)listTag);
        }
        return nbt;
    }

    protected MountedStorageManager getStorageForSpawnPacket() {
        return this.storage;
    }

    private CompoundTag writeBlocksCompound() {
        CompoundTag compound = new CompoundTag();
        HashMapPalette palette = new HashMapPalette((IdMap)GameData.getBlockStateIDMap(), 16, (i, s) -> {
            throw new IllegalStateException("Palette Map index exceeded maximum");
        });
        ListTag blockList = new ListTag();
        for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
            int id = palette.m_6796_((Object)block.f_74676_);
            CompoundTag c = new CompoundTag();
            c.m_128356_("Pos", block.f_74675_.m_121878_());
            c.m_128405_("State", id);
            if (block.f_74677_ != null) {
                c.m_128365_("Data", (Tag)block.f_74677_);
            }
            blockList.add((Object)c);
        }
        ListTag paletteNBT = new ListTag();
        for (int i2 = 0; i2 < palette.m_142067_(); ++i2) {
            paletteNBT.add((Object)NbtUtils.m_129202_((BlockState)((BlockState)palette.f_62658_.m_7942_(i2))));
        }
        compound.m_128365_("Palette", (Tag)paletteNBT);
        compound.m_128365_("BlockList", (Tag)blockList);
        return compound;
    }

    private void readBlocksCompound(Tag compound, Level world, boolean usePalettedDeserialization) {
        ListTag blockList;
        HashMapPalette palette = null;
        if (usePalettedDeserialization) {
            CompoundTag c = (CompoundTag)compound;
            palette = new HashMapPalette((IdMap)GameData.getBlockStateIDMap(), 16, (i, s) -> {
                throw new IllegalStateException("Palette Map index exceeded maximum");
            });
            ListTag list = c.m_128437_("Palette", 10);
            palette.f_62658_.m_13554_();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                palette.f_62658_.m_13569_((Object)NbtUtils.m_129241_((CompoundTag)list.m_128728_(i2)));
            }
            blockList = c.m_128437_("BlockList", 10);
        } else {
            blockList = (ListTag)compound;
        }
        HashMapPalette finalPalette = palette;
        blockList.forEach(e -> {
            CompoundTag c = (CompoundTag)e;
            StructureTemplate.StructureBlockInfo info = usePalettedDeserialization ? Contraption.readStructureBlockInfo(c, (HashMapPalette<BlockState>)finalPalette) : Contraption.legacyReadStructureBlockInfo(c);
            this.blocks.put(info.f_74675_, info);
            if (!world.f_46443_) {
                return;
            }
            CompoundTag tag = info.f_74677_;
            if (tag == null) {
                return;
            }
            tag.m_128405_("x", info.f_74675_.m_123341_());
            tag.m_128405_("y", info.f_74675_.m_123342_());
            tag.m_128405_("z", info.f_74675_.m_123343_());
            BlockEntity be = BlockEntity.m_155241_((BlockPos)info.f_74675_, (BlockState)info.f_74676_, (CompoundTag)tag);
            if (be == null) {
                return;
            }
            be.m_142339_(world);
            this.modelData.put(info.f_74675_, be.getModelData());
            if (be instanceof KineticBlockEntity) {
                KineticBlockEntity kbe = (KineticBlockEntity)be;
                kbe.setSpeed(0.0f);
            }
            be.m_58900_();
            MovementBehaviour movementBehaviour = AllMovementBehaviours.getBehaviour(info.f_74676_);
            if (movementBehaviour == null || !movementBehaviour.hasSpecialInstancedRendering()) {
                this.maybeInstancedBlockEntities.add(be);
            }
            if (movementBehaviour != null && !movementBehaviour.renderAsNormalBlockEntity()) {
                return;
            }
            this.presentBlockEntities.put(info.f_74675_, be);
            this.specialRenderedBlockEntities.add(be);
        });
    }

    private static StructureTemplate.StructureBlockInfo readStructureBlockInfo(CompoundTag blockListEntry, HashMapPalette<BlockState> palette) {
        return new StructureTemplate.StructureBlockInfo(BlockPos.m_122022_((long)blockListEntry.m_128454_("Pos")), Objects.requireNonNull((BlockState)palette.m_5795_(blockListEntry.m_128451_("State"))), blockListEntry.m_128441_("Data") ? blockListEntry.m_128469_("Data") : null);
    }

    private static StructureTemplate.StructureBlockInfo legacyReadStructureBlockInfo(CompoundTag blockListEntry) {
        return new StructureTemplate.StructureBlockInfo(NbtUtils.m_129239_((CompoundTag)blockListEntry.m_128469_("Pos")), NbtUtils.m_129241_((CompoundTag)blockListEntry.m_128469_("Block")), blockListEntry.m_128441_("Data") ? blockListEntry.m_128469_("Data") : null);
    }

    public void removeBlocksFromWorld(Level world, BlockPos offset) {
        this.storage.removeStorageFromWorld();
        this.glueToRemove.forEach(glue -> {
            this.superglue.add(glue.m_142469_().m_82383_(Vec3.m_82528_((Vec3i)offset.m_141952_((Vec3i)this.anchor)).m_82490_(-1.0)));
            glue.m_146870_();
        });
        ArrayList<BoundingBox> minimisedGlue = new ArrayList<BoundingBox>();
        for (int i = 0; i < this.superglue.size(); ++i) {
            minimisedGlue.add(null);
        }
        for (boolean brittles : Iterate.trueAndFalse) {
            Iterator<StructureTemplate.StructureBlockInfo> iterator = this.blocks.values().iterator();
            while (iterator.hasNext()) {
                StructureTemplate.StructureBlockInfo block = iterator.next();
                if (brittles != BlockMovementChecks.isBrittle(block.f_74676_)) continue;
                for (int i = 0; i < this.superglue.size(); ++i) {
                    AABB aabb = this.superglue.get(i);
                    if (aabb == null || !aabb.m_82393_((double)block.f_74675_.m_123341_() + 0.5, (double)block.f_74675_.m_123342_() + 0.5, (double)block.f_74675_.m_123343_() + 0.5)) continue;
                    if (minimisedGlue.get(i) == null) {
                        minimisedGlue.set(i, new BoundingBox(block.f_74675_));
                        continue;
                    }
                    minimisedGlue.set(i, BBHelper.encapsulate((BoundingBox)minimisedGlue.get(i), block.f_74675_));
                }
                BlockPos add = block.f_74675_.m_141952_((Vec3i)this.anchor).m_141952_((Vec3i)offset);
                if (this.customBlockRemoval((LevelAccessor)world, add, block.f_74676_)) continue;
                BlockState oldState = world.m_8055_(add);
                Block blockIn = oldState.m_60734_();
                boolean blockMismatch = block.f_74676_.m_60734_() != blockIn;
                if (blockMismatch &= !AllBlocks.POWERED_SHAFT.is((IForgeRegistryEntry)blockIn) || !AllBlocks.SHAFT.has(block.f_74676_)) {
                    iterator.remove();
                }
                world.m_46747_(add);
                int flags = 122;
                if (blockIn instanceof SimpleWaterloggedBlock && oldState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)oldState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    world.m_7731_(add, Blocks.f_49990_.m_49966_(), flags);
                    continue;
                }
                world.m_7731_(add, Blocks.f_50016_.m_49966_(), flags);
            }
        }
        this.superglue.clear();
        Object object = minimisedGlue.iterator();
        while (object.hasNext()) {
            AABB bb;
            BoundingBox box = (BoundingBox)object.next();
            if (box == null || !((bb = new AABB((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_(), (double)(box.m_162399_() + 1), (double)(box.m_162400_() + 1), (double)(box.m_162401_() + 1))).m_82309_() > 1.01)) continue;
            this.superglue.add(bb);
        }
        for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
            BlockPos add = block.f_74675_.m_141952_((Vec3i)this.anchor).m_141952_((Vec3i)offset);
            int flags = 67;
            world.m_7260_(add, block.f_74676_, Blocks.f_50016_.m_49966_(), flags);
            ServerLevel serverWorld = (ServerLevel)world;
            PoiType.m_27390_((BlockState)block.f_74676_).ifPresent(poiType -> world.m_142572_().execute(() -> {
                serverWorld.m_8904_().m_27085_(add, poiType);
                DebugPackets.m_133679_((ServerLevel)serverWorld, (BlockPos)add);
            }));
            world.markAndNotifyBlock(add, world.m_46745_(add), block.f_74676_, Blocks.f_50016_.m_49966_(), flags, 512);
            block.f_74676_.m_60758_((LevelAccessor)world, add, flags & 0xFFFFFFFE);
        }
    }

    public void addBlocksToWorld(Level world, StructureTransform transform) {
        if (this.disassembled) {
            return;
        }
        this.disassembled = true;
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
                BlockState blockState;
                BlockState state;
                BlockPos targetPos;
                if (nonBrittles == BlockMovementChecks.isBrittle(block.f_74676_) || this.customBlockPlacement((LevelAccessor)world, targetPos = transform.apply(block.f_74675_), state = transform.apply(block.f_74676_))) continue;
                if (nonBrittles) {
                    for (Direction face : Iterate.directions) {
                        state = state.m_60728_(face, world.m_8055_(targetPos.m_142300_(face)), (LevelAccessor)world, targetPos, targetPos.m_142300_(face));
                    }
                }
                if ((blockState = world.m_8055_(targetPos)).m_60800_((BlockGetter)world, targetPos) == -1.0f || state.m_60812_((BlockGetter)world, targetPos).m_83281_() && !blockState.m_60812_((BlockGetter)world, targetPos).m_83281_()) {
                    if (targetPos.m_123342_() == world.m_141937_()) {
                        targetPos = targetPos.m_7494_();
                    }
                    world.m_46796_(2001, targetPos, Block.m_49956_((BlockState)state));
                    Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)targetPos, null);
                    continue;
                }
                if (state.m_60734_() instanceof SimpleWaterloggedBlock && state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    FluidState FluidState2 = world.m_6425_(targetPos);
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(FluidState2.m_76152_() == Fluids.f_76193_));
                }
                world.m_46961_(targetPos, true);
                if (AllBlocks.SHAFT.has(state)) {
                    state = ShaftBlock.pickCorrectShaftType(state, world, targetPos);
                }
                if (state.m_61138_((Property)SlidingDoorBlock.VISIBLE)) {
                    state = (BlockState)((BlockState)state.m_61124_((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)SlidingDoorBlock.f_52727_) == false))).m_61124_((Property)SlidingDoorBlock.f_52729_, (Comparable)Boolean.valueOf(false));
                }
                world.m_7731_(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.m_122479_();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != Rotation.NONE;
                if (verticalRotation && (state.m_60734_() instanceof PulleyBlock.RopeBlock || state.m_60734_() instanceof PulleyBlock.MagnetBlock || state.m_60734_() instanceof DoorBlock)) {
                    world.m_46961_(targetPos, true);
                }
                BlockEntity blockEntity = world.m_7702_(targetPos);
                CompoundTag tag = block.f_74677_;
                if (blockEntity != null) {
                    tag = NBTProcessors.process(blockEntity, tag, false);
                }
                if (blockEntity != null && tag != null) {
                    tag.m_128405_("x", targetPos.m_123341_());
                    tag.m_128405_("y", targetPos.m_123342_());
                    tag.m_128405_("z", targetPos.m_123343_());
                    if (verticalRotation && blockEntity instanceof PulleyBlockEntity) {
                        tag.m_128473_("Offset");
                        tag.m_128473_("InitialOffset");
                    }
                    if (blockEntity instanceof IMultiBlockEntityContainer && tag.m_128441_("LastKnownPos")) {
                        tag.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)BlockPos.f_121853_.m_6625_(0x7FFFFFFE)));
                    }
                    blockEntity.m_142466_(tag);
                    this.storage.addStorageToWorld(block, blockEntity);
                }
                transform.apply(blockEntity);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            StructureTemplate.StructureBlockInfo block = (StructureTemplate.StructureBlockInfo)object.next();
            if (!this.shouldUpdateAfterMovement(block)) continue;
            BlockPos targetPos = transform.apply(block.f_74675_);
            world.markAndNotifyBlock(targetPos, world.m_46745_(targetPos), block.f_74676_, block.f_74676_, 67, 512);
        }
        for (AABB box : this.superglue) {
            box = new AABB(transform.apply(new Vec3(box.f_82288_, box.f_82289_, box.f_82290_)), transform.apply(new Vec3(box.f_82291_, box.f_82292_, box.f_82293_)));
            if (world.f_46443_) continue;
            world.m_7967_((Entity)new SuperGlueEntity(world, box));
        }
        this.storage.clear();
    }

    public void addPassengersToWorld(Level world, StructureTransform transform, List<Entity> seatedEntities) {
        for (Entity seatedEntity : seatedEntities) {
            Integer seatIndex;
            if (this.getSeatMapping().isEmpty() || (seatIndex = this.getSeatMapping().get(seatedEntity.m_142081_())) == null) continue;
            BlockPos seatPos = this.getSeats().get(seatIndex);
            if (!(world.m_8055_(seatPos = transform.apply(seatPos)).m_60734_() instanceof SeatBlock) || SeatBlock.isSeatOccupied(world, seatPos)) continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(Level world) {
        this.disabledActors.clear();
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (StructureTemplate.StructureBlockInfo)pair.left, this);
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)pair.left).f_74676_);
            if (behaviour != null) {
                behaviour.startMoving(context);
            }
            pair.setRight((Object)context);
            if (!(behaviour instanceof ContraptionControlsMovement)) continue;
            this.disableActorOnStart(context);
        }
        for (ItemStack stack : this.disabledActors) {
            this.setActorsActive(stack, false);
        }
    }

    protected void disableActorOnStart(MovementContext context) {
        if (!ContraptionControlsMovement.isDisabledInitially(context)) {
            return;
        }
        ItemStack filter = ContraptionControlsMovement.getFilter(context);
        if (filter == null) {
            return;
        }
        if (this.isActorTypeDisabled(filter)) {
            return;
        }
        this.disabledActors.add(filter);
    }

    public boolean isActorTypeDisabled(ItemStack filter) {
        return this.disabledActors.stream().anyMatch(i -> ContraptionControlsMovement.isSameFilter(i, filter));
    }

    public void setActorsActive(ItemStack referenceStack, boolean enable) {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            ItemStack behaviourStack;
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)pair.left).f_74676_);
            if (behaviour == null || (behaviourStack = behaviour.canBeDisabledVia((MovementContext)pair.right)) == null || !referenceStack.m_41619_() && !ContraptionControlsMovement.isSameFilter(referenceStack, behaviourStack)) continue;
            boolean bl = ((MovementContext)pair.right).disabled = !enable;
            if (enable) continue;
            behaviour.onDisabledByControls((MovementContext)pair.right);
        }
    }

    public List<ItemStack> getDisabledActors() {
        return this.disabledActors;
    }

    public void stop(Level world) {
        this.forEachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = Vec3.f_82478_;
            ctx.relativeMotion = Vec3.f_82478_;
            ctx.rotation = v -> v;
        });
    }

    public void forEachActor(Level world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)pair.getLeft()).f_74676_);
            if (behaviour == null) continue;
            callBack.accept(behaviour, (MovementContext)pair.getRight());
        }
    }

    protected boolean shouldUpdateAfterMovement(StructureTemplate.StructureBlockInfo info) {
        if (PoiType.m_27390_((BlockState)info.f_74676_).isPresent()) {
            return false;
        }
        return !(info.f_74676_.m_60734_() instanceof SlidingDoorBlock);
    }

    public void expandBoundsAroundAxis(Direction.Axis axis) {
        Set<BlockPos> blocks = this.getBlocks().keySet();
        int radius = (int)Math.ceil(Math.sqrt(Contraption.getRadius(blocks, axis)));
        int maxX = radius + 2;
        int maxY = radius + 2;
        int maxZ = radius + 2;
        int minX = -radius - 1;
        int minY = -radius - 1;
        int minZ = -radius - 1;
        if (axis == Direction.Axis.X) {
            maxX = (int)this.bounds.f_82291_;
            minX = (int)this.bounds.f_82288_;
        } else if (axis == Direction.Axis.Y) {
            maxY = (int)this.bounds.f_82292_;
            minY = (int)this.bounds.f_82289_;
        } else if (axis == Direction.Axis.Z) {
            maxZ = (int)this.bounds.f_82293_;
            minZ = (int)this.bounds.f_82290_;
        }
        this.bounds = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public Map<UUID, Integer> getSeatMapping() {
        return this.seatMapping;
    }

    public BlockPos getSeatOf(UUID entityId) {
        if (!this.getSeatMapping().containsKey(entityId)) {
            return null;
        }
        int seatIndex = this.getSeatMapping().get(entityId);
        if (seatIndex >= this.getSeats().size()) {
            return null;
        }
        return this.getSeats().get(seatIndex);
    }

    public BlockPos getBearingPosOf(UUID subContraptionEntityId) {
        if (this.stabilizedSubContraptions.containsKey(subContraptionEntityId)) {
            return this.stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        }
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<BlockPos> getSeats() {
        return this.seats;
    }

    public Map<BlockPos, StructureTemplate.StructureBlockInfo> getBlocks() {
        return this.blocks;
    }

    public List<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> getActors() {
        return this.actors;
    }

    @Nullable
    public MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> getActorAt(BlockPos localPos) {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            if (!localPos.equals((Object)((StructureTemplate.StructureBlockInfo)pair.left).f_74675_)) continue;
            return pair;
        }
        return null;
    }

    public Map<BlockPos, MovingInteractionBehaviour> getInteractors() {
        return this.interactors;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new EmptyLighter(this);
    }

    public void invalidateColliders() {
        this.simplifiedEntityColliders = Optional.empty();
        this.gatherBBsOffThread();
    }

    private void gatherBBsOffThread() {
        this.getContraptionWorld();
        this.simplifiedEntityColliderProvider = CompletableFuture.supplyAsync(() -> {
            VoxelShape combinedShape = Shapes.m_83040_();
            for (Map.Entry<BlockPos, StructureTemplate.StructureBlockInfo> entry : this.blocks.entrySet()) {
                StructureTemplate.StructureBlockInfo info = entry.getValue();
                BlockPos localPos = entry.getKey();
                VoxelShape collisionShape = info.f_74676_.m_60742_((BlockGetter)this.world, localPos, CollisionContext.m_82749_());
                if (collisionShape.m_83281_()) continue;
                combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)collisionShape.m_83216_((double)localPos.m_123341_(), (double)localPos.m_123342_(), (double)localPos.m_123343_()), (BooleanOp)BooleanOp.f_82695_);
            }
            return combinedShape.m_83296_().m_83299_();
        }).thenAccept(r -> {
            this.simplifiedEntityColliders = Optional.of(r);
            this.simplifiedEntityColliderProvider = null;
        });
    }

    public static float getRadius(Set<BlockPos> blocks, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return Contraption.getMaxDistSqr(blocks, Vec3i::m_123342_, Vec3i::m_123343_);
            }
            case Y: {
                return Contraption.getMaxDistSqr(blocks, Vec3i::m_123341_, Vec3i::m_123343_);
            }
            case Z: {
                return Contraption.getMaxDistSqr(blocks, Vec3i::m_123341_, Vec3i::m_123342_);
            }
        }
        throw new IllegalStateException("Impossible axis");
    }

    public static float getMaxDistSqr(Set<BlockPos> blocks, ICoordinate one, ICoordinate other) {
        float maxDistSq = -1.0f;
        for (BlockPos pos : blocks) {
            float b;
            float a = one.get(pos);
            float distSq = a * a + (b = other.get(pos)) * b;
            if (!(distSq > maxDistSq)) continue;
            maxDistSq = distSq;
        }
        return maxDistSq;
    }

    public IItemHandlerModifiable getSharedInventory() {
        return this.storage.getItems();
    }

    public IItemHandlerModifiable getSharedFuelInventory() {
        return this.storage.getFuelItems();
    }

    public IFluidHandler getSharedFluidTanks() {
        return this.storage.getFluids();
    }

    public Collection<StructureTemplate.StructureBlockInfo> getRenderedBlocks() {
        return this.blocks.values();
    }

    public Collection<BlockEntity> getSpecialRenderedBEs() {
        return this.specialRenderedBlockEntities;
    }

    public boolean isHiddenInPortal(BlockPos localPos) {
        return false;
    }

    public Optional<List<AABB>> getSimplifiedEntityColliders() {
        return this.simplifiedEntityColliders;
    }

    public void handleContraptionFluidPacket(BlockPos localPos, FluidStack containedFluid) {
        this.storage.updateContainedFluid(localPos, containedFluid);
    }

    public void tickStorage(AbstractContraptionEntity entity) {
        this.storage.entityTick(entity);
    }

    public boolean containsBlockBreakers() {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)pair.getLeft()).f_74676_);
            if (!(behaviour instanceof BlockBreakingMovementBehaviour) && !(behaviour instanceof HarvesterMovementBehaviour)) continue;
            return true;
        }
        return false;
    }

    public static class ContraptionInvWrapper
    extends CombinedInvWrapper {
        protected final boolean isExternal;

        public ContraptionInvWrapper(boolean isExternal, IItemHandlerModifiable ... itemHandler) {
            super(itemHandler);
            this.isExternal = isExternal;
        }

        public ContraptionInvWrapper(IItemHandlerModifiable ... itemHandler) {
            this(false, itemHandler);
        }

        public boolean isSlotExternal(int slot) {
            if (this.isExternal) {
                return true;
            }
            IItemHandlerModifiable handler = this.getHandlerFromIndex(this.getIndexForSlot(slot));
            return handler instanceof ContraptionInvWrapper && ((ContraptionInvWrapper)handler).isSlotExternal(slot);
        }
    }
}

