/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.core.util.recipes.machine.InsolatorRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineInsolatorScreen;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeCategory
extends ThermalRecipeCategory<InsolatorRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public InsolatorRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineInsolatorScreen.TEXTURE, 26, 11, 130, 62).addPadding(0, 0, 16, 18).build();
        this.name = StringHelper.getTextComponent((String)((Block)ThermalCore.BLOCKS.get("machine_insolator")).m_7705_());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(9);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(9), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends InsolatorRecipe> getRecipeClass() {
        return InsolatorRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InsolatorRecipe recipe, IFocusGroup focuses) {
        List inputs = recipe.getInputItems();
        List inputFluids = recipe.getInputFluids();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(recipe.getOutputItems().size());
        List catalysts = InsolatorRecipeManager.instance().getCatalysts();
        for (ItemStack stack : recipe.getOutputItems()) {
            outputs.add(ItemHelper.cloneStack((ItemStack)stack));
        }
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            ((ItemStack)outputs.get(i)).m_41764_((int)chance);
        }
        IRecipeSlotBuilder[] outputSlots = new IRecipeSlotBuilder[4];
        builder.addSlot(RecipeIngredientRole.INPUT, 52, 6).addIngredients((Ingredient)inputs.get(0));
        IRecipeSlotBuilder catalystSlot = builder.addSlot(RecipeIngredientRole.INPUT, 52, 42);
        if (recipe.isCatalyzable()) {
            ((IRecipeSlotBuilder)catalystSlot.addItemStacks(catalysts)).addTooltipCallback(TCoreJeiPlugin.catalystTooltip());
        }
        outputSlots[0] = builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 15);
        outputSlots[1] = builder.addSlot(RecipeIngredientRole.OUTPUT, 124, 15);
        outputSlots[2] = builder.addSlot(RecipeIngredientRole.OUTPUT, 106, 33);
        outputSlots[3] = builder.addSlot(RecipeIngredientRole.OUTPUT, 124, 33);
        for (int i = 0; i < outputs.size(); ++i) {
            ((IRecipeSlotBuilder)outputSlots[i].addItemStack((ItemStack)outputs.get(i))).addTooltipCallback(TCoreJeiPlugin.catalyzedOutputTooltip((float)((Float)recipe.getOutputItemChances().get(i)).floatValue(), (boolean)recipe.isCatalyzable()));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 25, 11).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(((FluidIngredient)inputFluids.get(0)).getFluids()))).setFluidRenderer(TCoreJeiPlugin.tankSize((int)8000), false, 16, 40).setOverlay((IDrawable)this.tankOverlay, 0, 0).addTooltipCallback(TCoreJeiPlugin.defaultFluidTooltip());
    }

    public void draw(InsolatorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, recipeSlotsView, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 76, 24);
        this.tankBackground.draw(matrixStack, 24, 10);
        this.speedBackground.draw(matrixStack, 52, 24);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((PoseStack)matrixStack, (int)76, (int)24, (FluidStack)((FluidIngredient)recipe.getInputFluids().get(0)).getFluids()[0], (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 76, 24);
            this.progressFluid.draw(matrixStack, 76, 24);
        } else {
            this.progress.draw(matrixStack, 76, 24);
        }
        this.speed.draw(matrixStack, 52, 24);
    }
}

