/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.PacketDistributor;

public class RevolvershotEntity
extends IEProjectileEntity {
    private BulletHandler.IBullet bulletType;
    public boolean bulletElectro = false;
    public ItemStack bulletPotion = ItemStack.f_41583_;
    private float gravity;
    private float movementDecay;

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> type, Level world) {
        super(type, world);
    }

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, Level world, LivingEntity shooter, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(eType, world, shooter, x, y, z, ax, ay, az);
        this.m_6034_(x, y, z);
        this.bulletType = type;
    }

    public RevolvershotEntity(Level world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        this((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.REVOLVERSHOT.get()), world, null, x, y, z, ax, ay, az, type);
    }

    public RevolvershotEntity(Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        this((EntityType<? extends RevolvershotEntity>)((EntityType)IEEntityTypes.REVOLVERSHOT.get()), world, living, ax, ay, az, type);
    }

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, Level world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        this(eType, world, living, living.m_20185_() + ax, living.m_20186_() + (double)living.m_20192_() + ay, living.m_20189_() + az, ax, ay, az, type);
        this.setShooterSynced();
        this.m_20256_(Vec3.f_82478_);
    }

    @Override
    public boolean m_6783_(double distance) {
        double d1 = this.m_142469_().m_82309_() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    @Override
    public void m_6532_(HitResult mop) {
        Entity hitEntity;
        boolean headshot = false;
        if (mop instanceof EntityHitResult && (hitEntity = ((EntityHitResult)mop).m_82443_()) instanceof LivingEntity) {
            headshot = Utils.isVecInEntityHead((LivingEntity)hitEntity, this.m_20182_());
        }
        if (this.bulletType != null) {
            this.bulletType.onHitTarget(this.f_19853_, mop, this.shooterUUID, (Entity)this, headshot);
            if (mop instanceof EntityHitResult) {
                hitEntity = ((EntityHitResult)mop).m_82443_();
                if (this.shooterUUID != null && headshot && hitEntity instanceof LivingEntity && ((LivingEntity)hitEntity).m_6162_() && ((LivingEntity)hitEntity).m_21223_() <= 0.0f) {
                    Player shooter = this.f_19853_.m_46003_(this.shooterUUID);
                    if (shooter != null) {
                        Utils.unlockIEAdvancement(shooter, "tools/secret_birthdayparty");
                    }
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), IESounds.birthdayParty, SoundSource.PLAYERS, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> hitEntity), (Object)new MessageBirthdayParty((LivingEntity)hitEntity));
                }
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.secondaryImpact(mop);
        }
        if (mop instanceof BlockHitResult) {
            this.m_8060_((BlockHitResult)mop);
        }
        this.m_146870_();
    }

    public void secondaryImpact(HitResult mop) {
        if (!(mop instanceof EntityHitResult)) {
            return;
        }
        Entity hitEntity = ((EntityHitResult)mop).m_82443_();
        if (this.bulletElectro && hitEntity instanceof LivingEntity && this.shooterUUID != null) {
            Player shooter = this.f_19853_.m_46003_(this.shooterUUID);
            float percentualDrain = 0.15f / (float)(this.bulletType == null ? 1 : this.bulletType.getProjectileCount(shooter));
            ((LivingEntity)hitEntity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 15, 4));
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                int actualDrain;
                ItemStack stack = ((LivingEntity)hitEntity).m_6844_(slot);
                if (!EnergyHelper.isFluxReceiver((ICapabilityProvider)stack) || EnergyHelper.getEnergyStored((ICapabilityProvider)stack) <= 0) continue;
                int drain = (int)Math.max((float)EnergyHelper.getEnergyStored((ICapabilityProvider)stack), (float)EnergyHelper.getMaxEnergyStored((ICapabilityProvider)stack) * percentualDrain);
                for (int hasDrained = 0; hasDrained < drain && (actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false)) > 0; hasDrained += actualDrain) {
                }
            }
        }
    }

    public void onExpire() {
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("inGround", (byte)(this.f_36703_ ? 1 : 0));
        nbt.m_128359_("bulletType", BulletHandler.findRegistryName(this.bulletType).toString());
        if (!this.bulletPotion.m_41619_()) {
            nbt.m_128365_("bulletPotion", (Tag)this.bulletPotion.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.bulletType = BulletHandler.getBullet(new ResourceLocation(nbt.m_128461_("bulletType")));
        if (nbt.m_128425_("bulletPotion", 10)) {
            this.bulletPotion = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("bulletPotion"));
        }
    }

    public float m_6143_() {
        return 1.0f;
    }

    public float m_6073_() {
        return 1.0f;
    }

    public boolean m_6087_() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public double getGravity() {
        return this.gravity;
    }

    public void setMovementDecay(float movementDecay) {
        this.movementDecay = movementDecay;
    }

    @Override
    protected float getMotionDecayFactor() {
        return this.movementDecay;
    }
}

