/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.api.fluid.IPressurizedFluidOutput;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.WorldMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FluidPipeBlockEntity
extends IEBaseBlockEntity
implements IFluidPipe,
IEBlockInterfaces.IColouredBE,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IPlacementInteraction,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.IAdditionalDrops {
    static WorldMap<BlockPos, Set<DirectionalFluidOutput>> indirectConnections = new WorldMap();
    public static ArrayList<Predicate<Block>> validPipeCovers = new ArrayList();
    public static ArrayList<Predicate<Block>> climbablePipeCovers = new ArrayList();
    public Object2BooleanMap<Direction> sideConfig = new Object2BooleanOpenHashMap();
    public Block cover;
    private byte connections;
    @Nullable
    private DyeColor color;
    private final Map<Direction, ResettableCapability<IFluidHandler>> sidedHandlers;
    private final Map<Direction, CapabilityReference<IFluidHandler>> neighbors;
    private static final CachedVoxelShapes<BoundingBoxKey> SHAPES = new CachedVoxelShapes<BoundingBoxKey>(FluidPipeBlockEntity::getBoxes);

    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FLUID_PIPE.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put((Object)d, true);
        }
        this.cover = Blocks.f_50016_;
        this.connections = 0;
        this.color = null;
        this.sidedHandlers = new EnumMap<Direction, ResettableCapability<IFluidHandler>>(Direction.class);
        this.neighbors = CapabilityReference.forAllNeighbors(this, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        for (Direction f : DirectionUtils.VALUES) {
            this.sidedHandlers.put(f, this.registerCapability(new PipeFluidHandler(this, f)));
        }
    }

    public static void initCovers() {
        validPipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingAlu));
        validPipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingSteel));
        validPipeCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
        climbablePipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingAlu));
        climbablePipeCovers.add(b -> b.m_49966_().m_204336_(IETags.scaffoldingSteel));
        climbablePipeCovers.add(input -> input == IEBlocks.WoodenDecoration.TREATED_SCAFFOLDING.get());
    }

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlers(BlockPos node, Level world) {
        if (world.f_46443_) {
            return ImmutableSet.of();
        }
        Set<DirectionalFluidOutput> cachedResult = indirectConnections.get(world, node);
        if (cachedResult != null) {
            return cachedResult;
        }
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            BlockPos next = (BlockPos)openList.get(0);
            BlockEntity pipeTile = Utils.getExistingTileEntity(world, next);
            if (!closedList.contains(next) && pipeTile instanceof FluidPipeBlockEntity) {
                closedList.add(next);
                for (Direction fd : DirectionUtils.VALUES) {
                    BlockPos nextPos;
                    BlockEntity adjacentTile;
                    if (!((FluidPipeBlockEntity)pipeTile).hasOutputConnection(fd) || (adjacentTile = Utils.getExistingTileEntity(world, nextPos = next.m_142300_(fd))) == null) continue;
                    if (adjacentTile instanceof FluidPipeBlockEntity) {
                        openList.add(nextPos);
                        continue;
                    }
                    LazyOptional handlerOptional = adjacentTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, fd.m_122424_());
                    handlerOptional.ifPresent(handler -> {
                        if (handler.getTanks() > 0) {
                            fluidHandlers.add(new DirectionalFluidOutput((IFluidHandler)handler, fd, adjacentTile));
                        }
                    });
                }
            }
            openList.remove(0);
        }
        indirectConnections.put(world, node, fluidHandlers);
        return fluidHandlers;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EventHandler.SERVER_TASKS.add(() -> {
                boolean changed = false;
                for (Direction f : DirectionUtils.VALUES) {
                    changed |= this.updateConnectionByte(f);
                }
                if (changed) {
                    this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
                    this.markContainingBlockForUpdate(null);
                }
            });
        }
    }

    @Override
    public void setRemovedIE() {
        super.setRemovedIE();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            indirectConnections.clearDimension(this.f_58857_);
        }
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            indirectConnections.clearDimension(this.f_58857_);
        }
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (entity instanceof LivingEntity && !((LivingEntity)entity).m_6147_() && this.cover != Blocks.f_50016_) {
            boolean climb = false;
            for (Predicate<Block> f : climbablePipeCovers) {
                if (f == null || !f.test(this.cover)) continue;
                climb = true;
                break;
            }
            if (climb) {
                IEBaseBlock.IELadderBlock.applyLadderLogic(entity);
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] config = nbt.m_128465_("sideConfig");
        for (int i = 0; i < 6; ++i) {
            Direction curDir = Direction.m_122376_((int)i);
            if (i < config.length) {
                boolean connected = config[i] != 0;
                this.sideConfig.put((Object)curDir, connected);
                if (connected) {
                    this.setValidHandler(curDir);
                    continue;
                }
                this.invalidateHandler(curDir);
                continue;
            }
            this.sideConfig.put((Object)curDir, false);
            this.invalidateHandler(curDir);
        }
        this.cover = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("cover")));
        DyeColor oldColor = this.color;
        this.color = nbt.m_128425_("color", 3) ? DyeColor.m_41053_((int)nbt.m_128451_("color")) : null;
        byte oldConns = this.connections;
        this.connections = nbt.m_128445_("connections");
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && (this.connections != oldConns || this.color != oldColor)) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        int[] config = new int[6];
        for (int i = 0; i < 6; ++i) {
            if (!this.sideConfig.getBoolean((Object)Direction.m_122376_((int)i))) continue;
            config[i] = 1;
        }
        nbt.m_128385_("sideConfig", config);
        if (this.hasCover()) {
            nbt.m_128359_("cover", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.cover).toString());
        }
        nbt.m_128344_("connections", this.connections);
        if (this.color != null) {
            nbt.m_128405_("color", this.color.m_41060_());
        }
    }

    boolean canOutputPressurized(BlockEntity output, boolean consumePower) {
        if (output instanceof IFluidPipe) {
            return ((IFluidPipe)output).canOutputPressurized(consumePower);
        }
        return false;
    }

    private void invalidateHandler(Direction side) {
        ResettableCapability<IFluidHandler> handler = this.sidedHandlers.get(side);
        if (handler != null) {
            this.sidedHandlers.put(side, null);
            handler.reset();
        }
    }

    private void setValidHandler(Direction side) {
        ResettableCapability<IFluidHandler> handler = this.sidedHandlers.get(side);
        if (handler == null) {
            this.sidedHandlers.put(side, this.registerCapability(new PipeFluidHandler(this, side)));
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && this.sideConfig.getBoolean((Object)facing)) {
            return this.sidedHandlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    protected boolean hasCover() {
        return this.cover != Blocks.f_50016_;
    }

    @Override
    public Collection<ItemStack> getExtraDrops(Player player, BlockState state) {
        if (this.hasCover()) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this.cover)});
        }
        return null;
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        super.onNeighborBlockChange(otherPos);
        Direction dir = Direction.m_122372_((float)(otherPos.m_123341_() - this.f_58858_.m_123341_()), (float)(otherPos.m_123342_() - this.f_58858_.m_123342_()), (float)(otherPos.m_123343_() - this.f_58858_.m_123343_()));
        if (this.updateConnectionByte(dir)) {
            Level world = this.getLevelNonnull();
            world.m_46590_(this.f_58858_, this.m_58900_().m_60734_(), dir);
            this.markContainingBlockForUpdate(null);
            if (!world.f_46443_) {
                indirectConnections.clearDimension(world);
            }
        }
    }

    public boolean updateConnectionByte(Direction dir) {
        IFluidHandler handler;
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !SafeChunkUtils.isChunkSafe((LevelAccessor)this.f_58857_, this.f_58858_.m_142300_(dir))) {
            return false;
        }
        byte oldConn = this.connections;
        int i = dir.m_122411_();
        int mask = 1 << i;
        this.connections = (byte)(this.connections & ~mask);
        if (this.sideConfig.getBoolean((Object)dir) && (handler = this.neighbors.get(dir).getNullable()) != null && handler.getTanks() > 0) {
            this.connections = (byte)(this.connections | mask);
        }
        return oldConn != this.connections;
    }

    public byte getAvailableConnectionByte() {
        byte availableConnections = this.connections;
        int mask = 1;
        for (Direction dir : DirectionUtils.VALUES) {
            if ((availableConnections & mask) == 0) {
                if (this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir)) instanceof FluidPipeBlockEntity) {
                    availableConnections = (byte)(availableConnections | mask);
                } else {
                    IFluidHandler handler = this.neighbors.get(dir).getNullable();
                    if (handler != null && handler.getTanks() > 0) {
                        availableConnections = (byte)(availableConnections | mask);
                    }
                }
            }
            mask <<= 1;
        }
        return availableConnections;
    }

    public ConnectionStyle getConnectionStyle(Direction connection) {
        if ((this.connections & 1 << connection.m_122411_()) == 0) {
            return ConnectionStyle.NO_CONNECTION;
        }
        if (this.connections != 3 && this.connections != 12 && this.connections != 48) {
            return ConnectionStyle.FLANGE;
        }
        BlockEntity con = Utils.getExistingTileEntity(this.f_58857_, this.m_58899_().m_142300_(connection));
        if (con instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity pipe = (FluidPipeBlockEntity)con;
            int tileConnections = pipe.connections | 1 << connection.m_122424_().m_122411_();
            if (this.connections == tileConnections) {
                return ConnectionStyle.PLAIN;
            }
        }
        return ConnectionStyle.FLANGE;
    }

    public void toggleSide(Direction side) {
        boolean newSideConnected = !this.sideConfig.getBoolean((Object)side);
        this.setSide(side, newSideConnected);
    }

    public void setSide(Direction side, boolean connectable) {
        this.setSide(side, connectable, true);
    }

    public void setSide(Direction side, boolean connectable, boolean firstPipe) {
        this.sideConfig.put((Object)side, connectable);
        if (connectable) {
            this.setValidHandler(side);
        } else {
            this.invalidateHandler(side);
        }
        this.m_6596_();
        if (firstPipe) {
            BlockEntity neighborTile = this.f_58857_.m_7702_(this.m_58899_().m_142300_(side));
            if (neighborTile instanceof FluidPipeBlockEntity) {
                ((FluidPipeBlockEntity)neighborTile).setSide(side.m_122424_(), connectable, false);
            }
            this.updateConnectionByte(side);
        }
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(CollisionContext ctx) {
        return SHAPES.get(new BoundingBoxKey(false, this));
    }

    @Override
    public VoxelShape getSelectionShape(@Nullable CollisionContext ctx) {
        boolean hammer = ctx != null && ctx.m_7142_((Item)IEItems.Tools.HAMMER.get());
        return SHAPES.get(new BoundingBoxKey(hammer, this));
    }

    private static List<AABB> getBoxes(BoundingBoxKey key) {
        double[] dArray;
        ArrayList list = Lists.newArrayList();
        if (!key.showToolView && key.hasCover) {
            list.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).m_82400_(-0.03125));
            return list;
        }
        byte availableConnections = key.availableConnections;
        byte activeConnections = key.connections;
        if (key.hasCover) {
            double[] dArray2 = new double[6];
            dArray2[0] = 0.002;
            dArray2[1] = 0.998;
            dArray2[2] = 0.002;
            dArray2[3] = 0.998;
            dArray2[4] = 0.002;
            dArray = dArray2;
            dArray2[5] = 0.998;
        } else {
            double[] dArray3 = new double[6];
            dArray3[0] = 0.25;
            dArray3[1] = 0.75;
            dArray3[2] = 0.25;
            dArray3[3] = 0.75;
            dArray3[4] = 0.25;
            dArray = dArray3;
            dArray3[5] = 0.75;
        }
        double[] baseAABB = dArray;
        for (Direction d : DirectionUtils.VALUES) {
            int i = d.m_122411_();
            if ((availableConnections & 1) == 1 && ((activeConnections & 1) == 1 || key.showToolView)) {
                list.add(new AABB(i == 4 ? 0.0 : (i == 5 ? 0.75 : 0.25), i == 0 ? 0.0 : (i == 1 ? 0.75 : 0.25), i == 2 ? 0.0 : (i == 3 ? 0.75 : 0.25), i == 4 ? 0.25 : (i == 5 ? 1.0 : 0.75), i == 0 ? 0.25 : (i == 1 ? 1.0 : 0.75), i == 2 ? 0.25 : (i == 3 ? 1.0 : 0.75)));
                if (key.connectionStyles.get(d) == ConnectionStyle.FLANGE) {
                    list.add(new AABB(i == 4 ? 0.0 : (i == 5 ? 0.875 : 0.125), i == 0 ? 0.0 : (i == 1 ? 0.875 : 0.125), i == 2 ? 0.0 : (i == 3 ? 0.875 : 0.125), i == 4 ? 0.125 : (i == 5 ? 1.0 : 0.875), i == 0 ? 0.125 : (i == 1 ? 1.0 : 0.875), i == 2 ? 0.125 : (i == 3 ? 1.0 : 0.875)));
                }
            }
            availableConnections = (byte)(availableConnections >> 1);
            activeConnections = (byte)(activeConnections >> 1);
        }
        list.add(new AABB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3]));
        return list;
    }

    @Override
    public int getRenderColour(int tintIndex) {
        return 0xFFFFFF;
    }

    public void dropCover(Player player) {
        ItemEntity entityitem;
        if (!this.f_58857_.f_46443_ && this.hasCover() && this.f_58857_.m_46469_().m_46207_(GameRules.f_46136_) && (entityitem = player.m_36176_(new ItemStack((ItemLike)this.cover), false)) != null) {
            entityitem.m_32061_();
        }
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (heldItem.m_41619_() && player.m_6144_() && this.hasCover()) {
            this.dropCover(player);
            this.cover = Blocks.f_50016_;
            this.markContainingBlockForUpdate(null);
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
            return true;
        }
        if (!heldItem.m_41619_() && !player.m_6144_()) {
            DyeColor heldDye;
            Block heldBlock = Block.m_49814_((Item)heldItem.m_41720_());
            if (heldBlock != Blocks.f_50016_) {
                for (Predicate<Block> func : validPipeCovers) {
                    if (!func.test(heldBlock) || this.cover == heldBlock) continue;
                    this.dropCover(player);
                    this.cover = heldBlock;
                    heldItem.m_41774_(1);
                    this.markContainingBlockForUpdate(null);
                    this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 255, 0);
                    return true;
                }
            }
            if ((heldDye = Utils.getDye(heldItem)) != null) {
                this.color = heldDye;
                this.markContainingBlockForUpdate(null);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hammerUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.f_58857_.f_46443_) {
            return true;
        }
        hitVec = hitVec.m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_));
        Direction fd = side;
        List<AABB> boxes = FluidPipeBlockEntity.getBoxes(new BoundingBoxKey(true, this));
        block0: for (AABB box : boxes) {
            if (!box.m_82400_(0.002).m_82390_(hitVec)) continue;
            for (Direction d : DirectionUtils.VALUES) {
                Vec3 testVec = new Vec3(0.5 + 0.5 * (double)d.m_122429_(), 0.5 + 0.5 * (double)d.m_122430_(), 0.5 + 0.5 * (double)d.m_122431_());
                if (!box.m_82400_(0.002).m_82390_(testVec)) continue;
                fd = d;
                break block0;
            }
        }
        if (fd != null) {
            this.toggleSide(fd);
            this.markContainingBlockForUpdate(null);
            indirectConnections.clearDimension(this.f_58857_);
            return true;
        }
        return false;
    }

    @Override
    public void onBEPlaced(Level world, BlockPos pos, BlockState state, Direction side, float hitX, float hitY, float hitZ, LivingEntity placer, ItemStack stack) {
        if (!world.m_5776_()) {
            for (Direction dir : Direction.values()) {
                BlockEntity te = world.m_7702_(pos.m_142300_(dir));
                if (!(te instanceof FluidPipeBlockEntity)) continue;
                FluidPipeBlockEntity neighborPipe = (FluidPipeBlockEntity)te;
                if (neighborPipe.color == this.color && neighborPipe.sideConfig.getBoolean((Object)dir.m_122424_())) continue;
                this.setSide(dir, false);
            }
        }
    }

    public boolean hasOutputConnection(Direction side) {
        return this.sideConfig.getBoolean((Object)side);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload ev) {
        LevelAccessor levelAccessor;
        if (!ev.getWorld().m_5776_() && (levelAccessor = ev.getWorld()) instanceof Level) {
            Level level = (Level)levelAccessor;
            indirectConnections.clearDimension(level);
        }
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    static class PipeFluidHandler
    implements IFluidHandler {
        private static final Random CURRENT_TICK_RANDOM = new Random();
        FluidPipeBlockEntity pipe;
        Direction facing;

        public PipeFluidHandler(FluidPipeBlockEntity pipe, Direction facing) {
            this.pipe = pipe;
            this.facing = facing;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (resource == null) {
                return 0;
            }
            int canAccept = resource.getAmount();
            if (canAccept <= 0) {
                return 0;
            }
            Set<DirectionalFluidOutput> outputList = FluidPipeBlockEntity.getConnectedFluidHandlers(this.pipe.m_58899_(), this.pipe.f_58857_);
            if (outputList.size() < 1) {
                return 0;
            }
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.m_58899_().m_142300_(this.facing));
            int sum = 0;
            HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
            for (DirectionalFluidOutput output : outputList) {
                int limit;
                int tileSpecificAcceptedFluid;
                int temp;
                BlockPos cc = output.containingTile.m_58899_();
                if (cc.equals((Object)ccFrom) || !this.pipe.f_58857_.m_46805_(cc) || this.pipe.equals(output.containingTile) || (temp = output.output.fill(Utils.copyFluidStackWithAmount(resource, tileSpecificAcceptedFluid = Math.min(limit = this.getTransferableAmount(resource, output.containingTile), canAccept), output.stripPressure()), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                sorting.put(output, temp);
                sum += temp;
            }
            if (sum > 0) {
                int f = 0;
                for (DirectionalFluidOutput output : sorting.keySet()) {
                    int r;
                    int amount = (Integer)sorting.get(output);
                    if (sum > resource.getAmount()) {
                        int limit = this.getTransferableAmount(resource, output.containingTile);
                        int tileSpecificAcceptedFluid = Math.min(limit, canAccept);
                        float prio = (float)amount / (float)sum;
                        amount = (int)Math.ceil(Mth.m_14036_((float)amount, (float)1.0f, (float)Math.min((float)resource.getAmount() * prio, (float)tileSpecificAcceptedFluid)));
                        amount = Math.min(amount, canAccept);
                    }
                    if ((r = output.output.fill(Utils.copyFluidStackWithAmount(resource, amount, output.stripPressure()), doFill)) > 50) {
                        this.pipe.canOutputPressurized(output.containingTile, true);
                    }
                    f += r;
                    if ((canAccept -= r) > 0) continue;
                    break;
                }
                return f;
            }
            return 0;
        }

        private int getTransferableAmount(FluidStack resource, BlockEntity target) {
            if (target instanceof IPressurizedFluidOutput) {
                IPressurizedFluidOutput pressurizedOutput = (IPressurizedFluidOutput)target;
                return pressurizedOutput.getMaxAcceptedFluidAmount(resource);
            }
            return IFluidPipe.getTransferableAmount(resource.hasTag() && resource.getOrCreateTag().m_128441_("pressurized") || this.pipe.canOutputPressurized(target, false));
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return this.drain(resource.getAmount(), doDrain);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            Level world = this.pipe.getLevelNonnull();
            ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(FluidPipeBlockEntity.getConnectedFluidHandlers(this.pipe.m_58899_(), world));
            BlockPos ccFrom = new BlockPos((Vec3i)this.pipe.m_58899_().m_142300_(this.facing));
            outputList.removeIf(output -> ccFrom.equals((Object)output.containingTile.m_58899_()));
            if (outputList.size() < 1) {
                return FluidStack.EMPTY;
            }
            CURRENT_TICK_RANDOM.setSeed(HashCommon.mix((long)world.m_46467_()));
            int chosen = outputList.size() == 1 ? 0 : CURRENT_TICK_RANDOM.nextInt(outputList.size());
            DirectionalFluidOutput output2 = (DirectionalFluidOutput)outputList.get(chosen);
            FluidStack available = output2.output.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
            BlockEntity drainingBE = SafeChunkUtils.getSafeBE((LevelAccessor)world, this.pipe.m_58899_().m_142300_(this.facing));
            int limit = this.getTransferableAmount(available, drainingBE);
            int actualTake = Math.min(limit, maxDrain);
            return output2.output.drain(actualTake, doDrain);
        }
    }

    public static enum ConnectionStyle {
        NO_CONNECTION,
        PLAIN,
        FLANGE;

    }

    private static class BoundingBoxKey {
        private final boolean showToolView;
        private final byte connections;
        private final byte availableConnections;
        private final boolean hasCover;
        private final Map<Direction, ConnectionStyle> connectionStyles = new EnumMap<Direction, ConnectionStyle>(Direction.class);

        private BoundingBoxKey(boolean showToolView, FluidPipeBlockEntity te) {
            this.showToolView = showToolView;
            this.connections = te.connections;
            this.availableConnections = te.getAvailableConnectionByte();
            this.hasCover = te.hasCover();
            for (Direction d : DirectionUtils.VALUES) {
                this.connectionStyles.put(d, te.getConnectionStyle(d));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BoundingBoxKey that = (BoundingBoxKey)o;
            return this.showToolView == that.showToolView && this.connections == that.connections && this.availableConnections == that.availableConnections && this.hasCover == that.hasCover && this.connectionStyles.equals(that.connectionStyles);
        }

        public int hashCode() {
            return Objects.hash(this.showToolView, this.connections, this.availableConnections, this.hasCover, this.connectionStyles);
        }
    }

    public record DirectionalFluidOutput(IFluidHandler output, Direction direction, BlockEntity containingTile) {
        boolean stripPressure() {
            BlockEntity blockEntity = this.containingTile;
            if (blockEntity instanceof IFluidPipe) {
                IFluidPipe pipe = (IFluidPipe)blockEntity;
                return pipe.stripPressureTag();
            }
            return true;
        }
    }
}

