/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ClocheRecipeBuilder
extends IEFinishedRecipe<ClocheRecipeBuilder> {
    private boolean hasRender = false;

    private ClocheRecipeBuilder() {
        super((IERecipeSerializer)((Object)ClocheRecipe.SERIALIZER.get()));
        this.setMultipleResults(4);
    }

    public static ClocheRecipeBuilder builder(ItemLike result) {
        return (ClocheRecipeBuilder)new ClocheRecipeBuilder().addResult(result);
    }

    public static ClocheRecipeBuilder builder(ItemStack result) {
        return (ClocheRecipeBuilder)new ClocheRecipeBuilder().addResult(result);
    }

    public static ClocheRecipeBuilder builder(TagKey<Item> result, int count) {
        return (ClocheRecipeBuilder)new ClocheRecipeBuilder().addResult(new IngredientWithSize(result, count));
    }

    public ClocheRecipeBuilder addSoil(ItemLike itemProvider) {
        return (ClocheRecipeBuilder)this.addItem("soil", new ItemStack(itemProvider));
    }

    public ClocheRecipeBuilder addSoil(ItemStack itemStack) {
        return (ClocheRecipeBuilder)this.addItem("soil", itemStack);
    }

    public ClocheRecipeBuilder addSoil(TagKey<Item> tag) {
        return this.addSoil(Ingredient.m_204132_(tag));
    }

    public ClocheRecipeBuilder addSoil(Ingredient ingredient) {
        return (ClocheRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("soil", ingredient.m_43942_()));
    }

    public ClocheRecipeBuilder setRender(ClocheRenderFunction.ClocheRenderReference renderReference) {
        Preconditions.checkArgument((!this.hasRender ? 1 : 0) != 0, (Object)"This recipe already has a render set.");
        this.hasRender = true;
        return (ClocheRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("render", (JsonElement)renderReference.serialize()));
    }

    @Override
    protected boolean isComplete() {
        return super.isComplete() && this.hasRender;
    }
}

