/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

public class MixerRecipe
extends MultiblockRecipe {
    public static RecipeType<MixerRecipe> TYPE;
    public static RegistryObject<IERecipeSerializer<MixerRecipe>> SERIALIZER;
    public static final CachedRecipeList<MixerRecipe> RECIPES;
    public final IngredientWithSize[] itemInputs;
    public final FluidTagInput fluidInput;
    public final FluidStack fluidOutput;
    public final int fluidAmount;

    public MixerRecipe(ResourceLocation id, FluidStack fluidOutput, FluidTagInput fluidInput, IngredientWithSize[] itemInputs, int energy) {
        super((Lazy<ItemStack>)LAZY_EMPTY, TYPE, id);
        this.fluidOutput = fluidOutput;
        this.fluidAmount = fluidOutput.getAmount();
        this.fluidInput = fluidInput;
        this.itemInputs = itemInputs;
        this.setTimeAndEnergy(fluidOutput.getAmount(), energy);
        this.fluidInputList = Lists.newArrayList((Object[])new FluidTagInput[]{this.fluidInput});
        this.setInputListWithSizes(Lists.newArrayList((Object[])this.itemInputs));
        this.fluidOutputList = Lists.newArrayList((Object[])new FluidStack[]{this.fluidOutput});
    }

    protected IERecipeSerializer<MixerRecipe> getIESerializer() {
        return (IERecipeSerializer)((Object)SERIALIZER.get());
    }

    public static MixerRecipe findRecipe(Level level, FluidStack fluid, NonNullList<ItemStack> components) {
        if (fluid.isEmpty()) {
            return null;
        }
        for (MixerRecipe recipe : RECIPES.getRecipes(level)) {
            if (!recipe.matches(fluid, components)) continue;
            return recipe;
        }
        return null;
    }

    public FluidStack getFluidOutput(FluidStack input, NonNullList<ItemStack> components) {
        return this.fluidOutput;
    }

    public boolean matches(FluidStack fluid, NonNullList<ItemStack> components) {
        return this.compareToInputs(fluid, components, this.fluidInput, this.itemInputs);
    }

    protected boolean compareToInputs(FluidStack fluid, NonNullList<ItemStack> components, FluidTagInput fluidInput, IngredientWithSize[] itemInputs) {
        if (fluid != null && fluidInput.test(fluid)) {
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(components.size());
            for (ItemStack s : components) {
                if (s.m_41619_()) continue;
                queryList.add(s.m_41777_());
            }
            for (IngredientWithSize add : itemInputs) {
                if (add == null) continue;
                int addAmount = add.getCount();
                Iterator it = queryList.iterator();
                while (it.hasNext()) {
                    ItemStack query = (ItemStack)it.next();
                    if (query.m_41619_()) continue;
                    if (add.test(query)) {
                        if (query.m_41613_() > addAmount) {
                            query.m_41774_(addAmount);
                            addAmount = 0;
                        } else {
                            addAmount -= query.m_41613_();
                            query.m_41764_(0);
                        }
                    }
                    if (query.m_41613_() <= 0) {
                        it.remove();
                    }
                    if (addAmount > 0) continue;
                    break;
                }
                if (addAmount <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] getUsedSlots(FluidStack input, NonNullList<ItemStack> components) {
        HashSet<Integer> usedSlotSet = new HashSet<Integer>();
        block0: for (IngredientWithSize ingr : this.itemInputs) {
            for (int j = 0; j < components.size(); ++j) {
                if (usedSlotSet.contains(j) || ((ItemStack)components.get(j)).m_41619_() || !ingr.test((ItemStack)components.get(j))) continue;
                usedSlotSet.add(j);
                continue block0;
            }
        }
        int it = 0;
        int[] processSlots = new int[usedSlotSet.size()];
        for (Integer slot : usedSlotSet) {
            processSlots[it++] = slot;
        }
        return processSlots;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    @Override
    public boolean shouldCheckItemAvailability() {
        return false;
    }

    static {
        RECIPES = new CachedRecipeList<MixerRecipe>(() -> TYPE, MixerRecipe.class);
    }
}

