/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;

public class AffixConvertLootModifier
extends LootModifier {
    protected AffixConvertLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_CONVERT_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            LootRarity.Clamped rarities = AdventureConfig.AFFIX_CONVERT_RARITIES.get(context.m_78952_().m_46472_().m_135782_());
            Random rand = context.m_78933_();
            float luck = context.m_78945_();
            for (ItemStack s : generatedLoot) {
                if (LootCategory.forItem(s) == LootCategory.NONE || !AffixHelper.getAffixes(s).isEmpty() || !(rand.nextFloat() <= m.chance())) continue;
                LootController.createLootItem(s, LootRarity.random(rand, luck, rarities), rand);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AffixConvertLootModifier> {
        public AffixConvertLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new AffixConvertLootModifier(conditions);
        }

        public JsonObject write(AffixConvertLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

