/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.coremod.api.ASMAPI;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.util.AxisAlignedBBDeserializer;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.EntityTypeDeserializer;
import shadows.apotheosis.util.GearSet;
import shadows.placebo.json.DimWeightedJsonReloadListener;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.RandomAttributeModifier;
import shadows.placebo.json.SerializerBuilder;

public class BossItemManager
extends DimWeightedJsonReloadListener<BossItem> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(EntityType.class, (Object)new EntityTypeDeserializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(GearSet.SetPredicate.class, (Object)new GearSet.SetPredicateAdapter()).setFieldNamingStrategy(f -> f.getName().equals(ASMAPI.mapField((String)"field_76292_a")) ? "weight" : f.getName()).registerTypeAdapter(ChancedEffectInstance.class, (Object)new ChancedEffectInstance.Deserializer()).registerTypeAdapter(RandomAttributeModifier.class, (Object)new RandomAttributeModifier.Deserializer()).registerTypeAdapter(AABB.class, (Object)new AxisAlignedBBDeserializer()).registerTypeAdapter(LootRarity.class, (Object)new LootRarity.Serializer()).registerTypeAdapter(CompoundTag.class, (Object)new NBTAdapter()).create();
    public static final BossItemManager INSTANCE = new BossItemManager();

    public BossItemManager() {
        super(AdventureModule.LOGGER, "bosses", false, false);
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Map map = super.m_5944_(pResourceManager, pProfiler);
        map.keySet().removeIf(r -> r.m_135827_().equals("brutalbosses"));
        return map;
    }

    protected void validateItem(BossItem item) {
        super.validateItem((PlaceboJsonReloadListener.TypeKeyed)item);
        item.validate();
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new SerializerBuilder("Apotheosis Boss").withJsonDeserializer(obj -> (BossItem)GSON.fromJson((JsonElement)obj, BossItem.class)));
    }

    @Deprecated
    public BossItem getRandomItem(Random rand, float luck, ServerLevelAccessor level) {
        return (BossItem)super.getRandomItem(rand, luck, level);
    }

    public BossItem getRandomItem(Random rand, Player player, ServerLevelAccessor level) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().filter(DimWeightedJsonReloadListener.IDimWeighted.matches((ResourceLocation)level.m_6018_().m_46472_().m_135782_())).filter(i -> GameStagesCompat.hasStage(player, i.stages)).map(l -> l.wrap(player.m_36336_())).forEach(list::add);
        return WeightedRandom.m_146317_((Random)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }
}

