/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.client.BossSpawnMessage;
import shadows.placebo.network.PacketDistro;

public class BossEvents {
    public Object2IntMap<ResourceLocation> bossCooldowns = new Object2IntOpenHashMap();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void naturalBosses(LivingSpawnEvent.SpecialSpawn e) {
        if (e.getSpawnReason() == MobSpawnType.NATURAL || e.getSpawnReason() == MobSpawnType.CHUNK_GENERATION) {
            LivingEntity entity = e.getEntityLiving();
            Random rand = e.getWorld().m_5822_();
            if (this.bossCooldowns.getInt((Object)entity.f_19853_.m_46472_().m_135782_()) <= 0 && !e.getWorld().m_5776_() && entity instanceof Monster && e.getResult() != Event.Result.DENY) {
                ServerLevelAccessor sLevel = (ServerLevelAccessor)e.getWorld();
                Pair<Float, BossSpawnRules> rules = AdventureConfig.BOSS_SPAWN_RULES.get(sLevel.m_6018_().m_46472_().m_135782_());
                if (rules == null) {
                    return;
                }
                if (rand.nextFloat() <= ((Float)rules.getLeft()).floatValue() && ((BossSpawnRules)rules.getRight()).test(sLevel, new BlockPos(e.getX(), e.getY(), e.getZ()))) {
                    Player player = sLevel.m_45924_(e.getX(), e.getY(), e.getZ(), -1.0, false);
                    if (player == null) {
                        return;
                    }
                    BossItem item = BossItemManager.INSTANCE.getRandomItem(rand, player, sLevel);
                    Mob boss = item.createBoss(sLevel, new BlockPos(e.getX() - 0.5, e.getY(), e.getZ() - 0.5), rand, player.m_36336_());
                    if (BossEvents.canSpawn((LevelAccessor)sLevel, boss, player.m_20280_((Entity)boss))) {
                        sLevel.m_47205_((Entity)boss);
                        e.setResult(Event.Result.DENY);
                        AdventureModule.debugLog(boss.m_142538_(), "Surface Boss - " + boss.m_7755_().getString());
                        sLevel.m_6907_().forEach(p -> {
                            Vec3 tPos = new Vec3(boss.m_20185_(), AdventureConfig.bossAnnounceIgnoreY ? p.m_20186_() : boss.m_20186_(), boss.m_20189_());
                            if (p.m_20238_(tPos) <= (double)(AdventureConfig.bossAnnounceRange * AdventureConfig.bossAnnounceRange)) {
                                if (boss.m_7770_() == null || boss.m_7770_().m_7383_().m_131135_() == null) {
                                    AdventureModule.LOGGER.warn("A Boss {} ({}) has spawned without a colored name!", (Object)boss.m_7755_().getString(), (Object)boss.m_6095_().getRegistryName());
                                } else {
                                    ((ServerPlayer)p).f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)new TranslatableComponent("info.apotheosis.boss_spawn", new Object[]{boss.m_7770_(), (int)boss.m_20185_(), (int)boss.m_20186_()})));
                                    TextColor color = boss.m_7770_().m_7383_().m_131135_();
                                    PacketDistro.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)new BossSpawnMessage(boss.m_142538_(), color == null ? 0xFFFFFF : color.m_131265_()), (Player)player);
                                }
                            }
                        });
                        this.bossCooldowns.put((Object)entity.f_19853_.m_46472_().m_135782_(), AdventureConfig.bossSpawnCooldown);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            this.bossCooldowns.computeIntIfPresent((Object)e.world.m_46472_().m_135782_(), (key, value) -> Math.max(0, value - 1));
        }
    }

    @SubscribeEvent
    public void load(ServerStartedEvent e) {
        e.getServer().m_129880_(Level.f_46428_).m_8895_().m_164861_(this::loadTimes, () -> new TimerPersistData(), "apotheosis_boss_times");
    }

    private TimerPersistData loadTimes(CompoundTag tag) {
        this.bossCooldowns.clear();
        for (String s : tag.m_128431_()) {
            ResourceLocation id = new ResourceLocation(s);
            int val = tag.m_128451_(s);
            this.bossCooldowns.put((Object)id, val);
        }
        return new TimerPersistData();
    }

    private static boolean canSpawn(LevelAccessor world, Mob entity, double playerDist) {
        if (playerDist > (double)(entity.m_6095_().m_20674_().m_21611_() * entity.m_6095_().m_20674_().m_21611_()) && entity.m_6785_(playerDist)) {
            return false;
        }
        return entity.m_5545_(world, MobSpawnType.NATURAL) && entity.m_6914_((LevelReader)world);
    }

    public static enum BossSpawnRules implements BiPredicate<ServerLevelAccessor, BlockPos>
    {
        NEEDS_SKY((level, pos) -> level.m_45527_(pos)),
        NEEDS_SURFACE((level, pos) -> pos.m_123342_() >= level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_())),
        ANY((level, pos) -> true);

        BiPredicate<ServerLevelAccessor, BlockPos> pred;

        private BossSpawnRules(BiPredicate<ServerLevelAccessor, BlockPos> pred) {
            this.pred = pred;
        }

        @Override
        public boolean test(ServerLevelAccessor t, BlockPos u) {
            return this.pred.test(t, u);
        }
    }

    private class TimerPersistData
    extends SavedData {
        private TimerPersistData() {
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            for (Object2IntMap.Entry e : BossEvents.this.bossCooldowns.object2IntEntrySet()) {
                tag.m_128405_(((ResourceLocation)e.getKey()).toString(), e.getIntValue());
            }
            return tag;
        }
    }
}

