/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class CatalyzingAffix
extends Affix {
    protected final Map<LootRarity, StepFunction> values;

    public CatalyzingAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.EFFECT);
        this.values = values;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getId() + ".desc").m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.SHIELD && this.values.containsKey(rarity);
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        if (source.m_19372_()) {
            int time = (int)((float)this.values.get(rarity).getInt(level) * amount);
            int modifier = 1 + (int)(amount / 12.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time, modifier));
        }
        return super.onShieldBlock(stack, rarity, level, entity, source, amount);
    }

    public static CatalyzingAffix read(JsonObject obj) {
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        return new CatalyzingAffix(values);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_178355_(this.values, (b, key) -> b.m_130070_(key.id()), (b, func) -> func.write(b));
    }

    public static CatalyzingAffix read(FriendlyByteBuf buf) {
        Map values = buf.m_178368_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        return new CatalyzingAffix(values);
    }
}

